/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.utils.IdUtils;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public final class TaskRun {
    @NotNull
    private final String id;
    @NotNull
    private final String executionId;
    @NotNull
    private final String namespace;
    @NotNull
    private final String flowId;
    @NotNull
    private final String taskId;
    private final String parentTaskRunId;
    private final String value;
    private final List<TaskRunAttempt> attempts;
    private final Map<String, Object> outputs;
    @NotNull
    private final State state;

    public TaskRun withState(State.Type state) {
        return new TaskRun(this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, this.outputs, this.state.withState(state));
    }

    public TaskRun forChildExecution(Map<String, String> remapTaskRunId, String executionId, State state) {
        return TaskRun.builder().id(remapTaskRunId.get(this.getId())).executionId(executionId != null ? executionId : this.getExecutionId()).namespace(this.getNamespace()).flowId(this.getFlowId()).taskId(this.getTaskId()).parentTaskRunId(this.getParentTaskRunId() != null ? remapTaskRunId.get(this.getParentTaskRunId()) : null).value(this.getValue()).attempts(this.getAttempts()).outputs(this.getOutputs()).state(state == null ? this.getState() : state).build();
    }

    public static TaskRun of(Execution execution, ResolvedTask resolvedTask) {
        return TaskRun.builder().id(IdUtils.create()).executionId(execution.getId()).namespace(execution.getNamespace()).flowId(execution.getFlowId()).taskId(resolvedTask.getTask().getId()).parentTaskRunId(resolvedTask.getParentId()).value(resolvedTask.getValue()).state(new State()).build();
    }

    public int attemptNumber() {
        if (this.attempts == null) {
            return 0;
        }
        return this.attempts.size();
    }

    public TaskRunAttempt lastAttempt() {
        if (this.attempts == null) {
            return null;
        }
        return this.attempts.stream().reduce((a, b) -> b).orElse(null);
    }

    public TaskRun onRunningResend() {
        TaskRunBuilder taskRunBuilder = this.toBuilder();
        if (taskRunBuilder.attempts == null || taskRunBuilder.attempts.size() == 0) {
            taskRunBuilder.attempts = new ArrayList<TaskRunAttempt>();
            taskRunBuilder.attempts.add(TaskRunAttempt.builder().state(new State(this.state, State.Type.KILLED)).build());
        } else {
            ArrayList<TaskRunAttempt> taskRunAttempts = new ArrayList<TaskRunAttempt>(taskRunBuilder.attempts);
            TaskRunAttempt lastAttempt = taskRunAttempts.get(taskRunBuilder.attempts.size() - 1);
            if (!lastAttempt.getState().isTerninated()) {
                taskRunAttempts.set(taskRunBuilder.attempts.size() - 1, lastAttempt.withState(State.Type.KILLED));
            } else {
                taskRunAttempts.add(TaskRunAttempt.builder().state(new State().withState(State.Type.KILLED)).build());
            }
            taskRunBuilder.attempts(taskRunAttempts);
        }
        return taskRunBuilder.build();
    }

    public boolean isSame(TaskRun taskRun) {
        return this.getId().equals(taskRun.getId()) && (this.getValue() == null && taskRun.getValue() == null || this.getValue() != null && this.getValue().equals(taskRun.getValue()));
    }

    public String toString(boolean pretty) {
        if (!pretty) {
            return super.toString();
        }
        return "TaskRun(id=" + this.getId() + ", taskId=" + this.getTaskId() + ", value=" + this.getValue() + ", parentTaskRunId=" + this.getParentTaskRunId() + ", state=" + this.getState().getCurrent().toString() + ", outputs=" + this.getOutputs() + ", attemps=" + this.getAttempts() + ")";
    }

    public String toStringState() {
        return "TaskRun(id=" + this.getId() + ", taskId=" + this.getTaskId() + ", value=" + this.getValue() + ", state=" + this.getState().getCurrent().toString() + ")";
    }

    @ConstructorProperties(value={"id", "executionId", "namespace", "flowId", "taskId", "parentTaskRunId", "value", "attempts", "outputs", "state"})
    @Generated
    TaskRun(@NotNull String id, @NotNull String executionId, @NotNull String namespace, @NotNull String flowId, @NotNull String taskId, String parentTaskRunId, String value, List<TaskRunAttempt> attempts, Map<String, Object> outputs, @NotNull State state) {
        this.id = id;
        this.executionId = executionId;
        this.namespace = namespace;
        this.flowId = flowId;
        this.taskId = taskId;
        this.parentTaskRunId = parentTaskRunId;
        this.value = value;
        this.attempts = attempts;
        this.outputs = outputs;
        this.state = state;
    }

    @Generated
    public static TaskRunBuilder builder() {
        return new TaskRunBuilder();
    }

    @Generated
    public TaskRunBuilder toBuilder() {
        return new TaskRunBuilder().id(this.id).executionId(this.executionId).namespace(this.namespace).flowId(this.flowId).taskId(this.taskId).parentTaskRunId(this.parentTaskRunId).value(this.value).attempts(this.attempts).outputs(this.outputs).state(this.state);
    }

    @NotNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @NotNull
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @NotNull
    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getParentTaskRunId() {
        return this.parentTaskRunId;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public List<TaskRunAttempt> getAttempts() {
        return this.attempts;
    }

    @Generated
    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @NotNull
    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskRun)) {
            return false;
        }
        TaskRun other = (TaskRun)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$parentTaskRunId = this.getParentTaskRunId();
        String other$parentTaskRunId = other.getParentTaskRunId();
        if (this$parentTaskRunId == null ? other$parentTaskRunId != null : !this$parentTaskRunId.equals(other$parentTaskRunId)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<TaskRunAttempt> this$attempts = this.getAttempts();
        List<TaskRunAttempt> other$attempts = other.getAttempts();
        if (this$attempts == null ? other$attempts != null : !((Object)this$attempts).equals(other$attempts)) {
            return false;
        }
        Map<String, Object> this$outputs = this.getOutputs();
        Map<String, Object> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        return !(this$state == null ? other$state != null : !((Object)this$state).equals(other$state));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $parentTaskRunId = this.getParentTaskRunId();
        result = result * 59 + ($parentTaskRunId == null ? 43 : $parentTaskRunId.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<TaskRunAttempt> $attempts = this.getAttempts();
        result = result * 59 + ($attempts == null ? 43 : ((Object)$attempts).hashCode());
        Map<String, Object> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskRun(id=" + this.getId() + ", executionId=" + this.getExecutionId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", taskId=" + this.getTaskId() + ", parentTaskRunId=" + this.getParentTaskRunId() + ", value=" + this.getValue() + ", attempts=" + this.getAttempts() + ", outputs=" + this.getOutputs() + ", state=" + this.getState() + ")";
    }

    @Generated
    public TaskRun withAttempts(List<TaskRunAttempt> attempts) {
        return this.attempts == attempts ? this : new TaskRun(this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, attempts, this.outputs, this.state);
    }

    @Generated
    public TaskRun withOutputs(Map<String, Object> outputs) {
        return this.outputs == outputs ? this : new TaskRun(this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, outputs, this.state);
    }

    @Generated
    public static class TaskRunBuilder {
        @Generated
        private String id;
        @Generated
        private String executionId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String taskId;
        @Generated
        private String parentTaskRunId;
        @Generated
        private String value;
        @Generated
        private List<TaskRunAttempt> attempts;
        @Generated
        private Map<String, Object> outputs;
        @Generated
        private State state;

        @Generated
        TaskRunBuilder() {
        }

        @Generated
        public TaskRunBuilder id(@NotNull String id) {
            this.id = id;
            return this;
        }

        @Generated
        public TaskRunBuilder executionId(@NotNull String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Generated
        public TaskRunBuilder namespace(@NotNull String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public TaskRunBuilder flowId(@NotNull String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public TaskRunBuilder taskId(@NotNull String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public TaskRunBuilder parentTaskRunId(String parentTaskRunId) {
            this.parentTaskRunId = parentTaskRunId;
            return this;
        }

        @Generated
        public TaskRunBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public TaskRunBuilder attempts(List<TaskRunAttempt> attempts) {
            this.attempts = attempts;
            return this;
        }

        @Generated
        public TaskRunBuilder outputs(Map<String, Object> outputs) {
            this.outputs = outputs;
            return this;
        }

        @Generated
        public TaskRunBuilder state(@NotNull State state) {
            this.state = state;
            return this;
        }

        @Generated
        public TaskRun build() {
            return new TaskRun(this.id, this.executionId, this.namespace, this.flowId, this.taskId, this.parentTaskRunId, this.value, this.attempts, this.outputs, this.state);
        }

        @Generated
        public String toString() {
            return "TaskRun.TaskRunBuilder(id=" + this.id + ", executionId=" + this.executionId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", taskId=" + this.taskId + ", parentTaskRunId=" + this.parentTaskRunId + ", value=" + this.value + ", attempts=" + this.attempts + ", outputs=" + this.outputs + ", state=" + this.state + ")";
        }
    }
}

