/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions.metrics;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.AbstractMetricEntry;
import java.util.Map;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public final class Counter
extends AbstractMetricEntry<Double> {
    @NotNull
    @JsonInclude
    private final String type = "counter";
    @NotNull
    private Double value;

    private Counter(@NotNull String name, @NotNull Double value, String ... tags) {
        super(name, tags);
        this.value = value;
    }

    public static Counter of(@NotNull String name, @NotNull Double value, String ... tags) {
        return new Counter(name, value, tags);
    }

    public static Counter of(@NotNull String name, @NotNull Integer value, String ... tags) {
        return new Counter(name, (double)value, tags);
    }

    public static Counter of(@NotNull String name, @NotNull Long value, String ... tags) {
        return new Counter(name, (double)value, tags);
    }

    public static Counter of(@NotNull String name, @NotNull Float value, String ... tags) {
        return new Counter(name, Double.valueOf(value.floatValue()), tags);
    }

    @Override
    public void register(MetricRegistry meterRegistry, String prefix, Map<String, String> tags) {
        meterRegistry.counter(this.metricName(prefix), this.tagsAsArray(tags)).increment(this.value.doubleValue());
    }

    @Override
    public void increment(Double value) {
        this.value = this.value + value;
    }

    @Override
    @Generated
    public String toString() {
        return "Counter(super=" + super.toString() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Counter)) {
            return false;
        }
        Counter other = (Counter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Counter;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @NotNull
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    @Generated
    public Double getValue() {
        return this.value;
    }

    @Generated
    public Counter() {
    }
}

