/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.TaskDefault;
import io.kestra.core.models.listeners.Listener;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.TaskValidationInterface;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.serializers.JacksonMapper;
import io.micronaut.core.annotation.Introspected;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Introspected
public class Flow
implements DeletedInterface {
    private static final ObjectMapper jsonMapper = JacksonMapper.ofJson().copy().setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            List<String> exclusions = Arrays.asList("revision", "deleted");
            return exclusions.contains(m.getName()) || super.hasIgnoreMarker(m);
        }
    });
    @NotNull
    @NotBlank
    @Pattern(regexp="[a-zA-Z0-9._-]+")
    @NotNull @NotBlank @Pattern(regexp="[a-zA-Z0-9._-]+") String id;
    @NotNull
    @Pattern(regexp="[a-z0-9._-]+")
    @NotNull @Pattern(regexp="[a-z0-9._-]+") String namespace;
    @Min(value=1L)
    @Min(value=1L) Integer revision;
    String description;
    Map<String, String> labels;
    @Valid
    List<Input> inputs;
    Map<String, Object> variables;
    @Valid
    @NotEmpty
    List<Task> tasks;
    @Valid
    List<Task> errors;
    @Valid
    List<Listener> listeners;
    @Valid
    List<AbstractTrigger> triggers;
    List<TaskDefault> taskDefaults;
    @NotNull
    boolean disabled;
    @NotNull
    boolean deleted;

    public Logger logger() {
        return LoggerFactory.getLogger((String)("flow." + this.id));
    }

    @JsonIgnore
    public String uid() {
        return Flow.uid(this.getNamespace(), this.getId(), Optional.ofNullable(this.revision));
    }

    @JsonIgnore
    public String uidWithoutRevision() {
        return String.join((CharSequence)"_", Arrays.asList(this.getNamespace(), this.getId()));
    }

    public static String uid(Execution execution) {
        return String.join((CharSequence)"_", Arrays.asList(execution.getNamespace(), execution.getFlowId(), String.valueOf(execution.getFlowRevision())));
    }

    public static String uid(String namespace, String id, Optional<Integer> revision) {
        return String.join((CharSequence)"_", Arrays.asList(namespace, id, String.valueOf(revision.orElse(-1))));
    }

    public static String uidWithoutRevision(String namespace, String id) {
        return String.join((CharSequence)"_", Arrays.asList(namespace, id));
    }

    public static String uidWithoutRevision(Execution execution) {
        return String.join((CharSequence)"_", Arrays.asList(execution.getNamespace(), execution.getFlowId()));
    }

    public Stream<Task> allTasks() {
        return Stream.of(this.tasks != null ? this.tasks : new ArrayList(), this.errors != null ? this.errors : new ArrayList(), this.listenersTasks()).flatMap(Collection::stream);
    }

    public List<Task> allTasksWithChilds() {
        return this.allTasks().flatMap(this::allTasksWithChilds).collect(Collectors.toList());
    }

    private Stream<Task> allTasksWithChilds(Task task) {
        if (task.isFlowable()) {
            Stream taskStream = ((FlowableTask)((Object)task)).allChildTasks().stream().flatMap(this::allTasksWithChilds);
            return Stream.concat(Stream.of(task), taskStream);
        }
        return Stream.of(task);
    }

    public Task findTaskByTaskId(String taskId) throws InternalException {
        return (Task)this.allTasks().flatMap(t -> t.findById(taskId).stream()).findFirst().orElseThrow(() -> new InternalException("Can't find task with id '" + this.id + "' on flow '" + this.id + "'"));
    }

    public Flow updateTask(String taskId, Task newValue) throws InternalException {
        Task task = this.findTaskByTaskId(taskId);
        Map<String, Object> map = JacksonMapper.toMap(this);
        return JacksonMapper.toMap(Flow.recursiveUpdate(map, task, newValue), Flow.class);
    }

    private static Object recursiveUpdate(Object object, Task previous, Task newValue) {
        if (object instanceof Map) {
            Map value = (Map)object;
            if (value.containsKey("id") && value.get("id").equals(previous.getId()) && value.containsKey("type") && value.get("type").equals(previous.getType())) {
                return JacksonMapper.toMap(newValue);
            }
            return value.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), Flow.recursiveUpdate(e.getValue(), previous, newValue))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (object instanceof Collection) {
            Collection value = (Collection)object;
            return value.stream().map(r -> Flow.recursiveUpdate(r, previous, newValue)).collect(Collectors.toList());
        }
        return object;
    }

    private List<Task> listenersTasks() {
        if (this.getListeners() == null) {
            return new ArrayList<Task>();
        }
        return this.getListeners().stream().flatMap(listener -> listener.getTasks().stream()).collect(Collectors.toList());
    }

    public boolean equalsWithoutRevision(Flow o) {
        try {
            return jsonMapper.writeValueAsString((Object)this).equals(jsonMapper.writeValueAsString((Object)o));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<ConstraintViolationException> validate() {
        HashSet<ManualConstraintViolation<Flow>> violations = new HashSet<ManualConstraintViolation<Flow>>();
        List<Task> allTasks = this.allTasksWithChilds();
        List ids = allTasks.stream().map(Task::getId).collect(Collectors.toList());
        List duplicates = ids.stream().distinct().filter(entry -> Collections.frequency(ids, entry) > 1).collect(Collectors.toList());
        if (duplicates.size() > 0) {
            violations.add(ManualConstraintViolation.of("Duplicate task id with name [" + String.join((CharSequence)", ", duplicates) + "]", this, Flow.class, "flow.tasks", String.join((CharSequence)", ", duplicates)));
        }
        allTasks.forEach(task -> {
            if (task instanceof TaskValidationInterface) {
                violations.addAll(((TaskValidationInterface)((Object)task)).failedConstraints());
            }
        });
        if (violations.size() > 0) {
            return Optional.of(new ConstraintViolationException(violations));
        }
        return Optional.empty();
    }

    public Optional<ConstraintViolationException> validateUpdate(Flow updated) {
        HashSet<ManualConstraintViolation<Flow>> violations = new HashSet<ManualConstraintViolation<Flow>>();
        updated.validate().ifPresent(e -> violations.addAll(e.getConstraintViolations()));
        if (!updated.getId().equals(this.getId())) {
            violations.add(ManualConstraintViolation.of("Illegal flow id update", updated, Flow.class, "flow.id", updated.getId()));
        }
        if (!updated.getNamespace().equals(this.getNamespace())) {
            violations.add(ManualConstraintViolation.of("Illegal namespace update", updated, Flow.class, "flow.namespace", updated.getNamespace()));
        }
        if (violations.size() > 0) {
            return Optional.of(new ConstraintViolationException(violations));
        }
        return Optional.empty();
    }

    public Flow toDeleted() {
        return new Flow(this.id, this.namespace, this.revision + 1, this.description, this.labels, this.inputs, this.variables, this.tasks, this.errors, this.listeners, this.triggers, this.taskDefaults, this.disabled, true);
    }

    @Generated
    private static boolean $default$disabled() {
        return false;
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @Generated
    protected Flow(FlowBuilder<?, ?> b) {
        this.id = b.id;
        this.namespace = b.namespace;
        this.revision = b.revision;
        this.description = b.description;
        this.labels = b.labels;
        this.inputs = b.inputs;
        this.variables = b.variables;
        this.tasks = b.tasks;
        this.errors = b.errors;
        this.listeners = b.listeners;
        this.triggers = b.triggers;
        this.taskDefaults = b.taskDefaults;
        this.disabled = b.disabled$set ? b.disabled$value : Flow.$default$disabled();
        this.deleted = b.deleted$set ? b.deleted$value : Flow.$default$deleted();
    }

    @Generated
    public static FlowBuilder<?, ?> builder() {
        return new FlowBuilderImpl();
    }

    @NotNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public Integer getRevision() {
        return this.revision;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Generated
    public List<Input> getInputs() {
        return this.inputs;
    }

    @Generated
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public List<Listener> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<AbstractTrigger> getTriggers() {
        return this.triggers;
    }

    @Generated
    public List<TaskDefault> getTaskDefaults() {
        return this.taskDefaults;
    }

    @NotNull
    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @NotNull
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @ConstructorProperties(value={"id", "namespace", "revision", "description", "labels", "inputs", "variables", "tasks", "errors", "listeners", "triggers", "taskDefaults", "disabled", "deleted"})
    @Generated
    public Flow(@NotNull String id, @NotNull String namespace, Integer revision, String description, Map<String, String> labels, List<Input> inputs, Map<String, Object> variables, List<Task> tasks, List<Task> errors, List<Listener> listeners, List<AbstractTrigger> triggers, List<TaskDefault> taskDefaults, @NotNull boolean disabled, @NotNull boolean deleted) {
        this.id = id;
        this.namespace = namespace;
        this.revision = revision;
        this.description = description;
        this.labels = labels;
        this.inputs = inputs;
        this.variables = variables;
        this.tasks = tasks;
        this.errors = errors;
        this.listeners = listeners;
        this.triggers = triggers;
        this.taskDefaults = taskDefaults;
        this.disabled = disabled;
        this.deleted = deleted;
    }

    @Generated
    public Flow() {
        this.disabled = Flow.$default$disabled();
        this.deleted = Flow.$default$deleted();
    }

    @Generated
    public String toString() {
        return "Flow(id=" + this.getId() + ", namespace=" + this.getNamespace() + ", revision=" + this.getRevision() + ", description=" + this.getDescription() + ", labels=" + this.getLabels() + ", inputs=" + this.getInputs() + ", variables=" + this.getVariables() + ", tasks=" + this.getTasks() + ", errors=" + this.getErrors() + ", listeners=" + this.getListeners() + ", triggers=" + this.getTriggers() + ", taskDefaults=" + this.getTaskDefaults() + ", disabled=" + this.isDisabled() + ", deleted=" + this.isDeleted() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Integer this$revision = this.getRevision();
        Integer other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !((Object)this$revision).equals(other$revision)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<Input> this$inputs = this.getInputs();
        List<Input> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, Object> this$variables = this.getVariables();
        Map<String, Object> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Listener> this$listeners = this.getListeners();
        List<Listener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<AbstractTrigger> this$triggers = this.getTriggers();
        List<AbstractTrigger> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        List<TaskDefault> this$taskDefaults = this.getTaskDefaults();
        List<TaskDefault> other$taskDefaults = other.getTaskDefaults();
        return !(this$taskDefaults == null ? other$taskDefaults != null : !((Object)this$taskDefaults).equals(other$taskDefaults));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Integer $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : ((Object)$revision).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<Input> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, Object> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Listener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<AbstractTrigger> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        List<TaskDefault> $taskDefaults = this.getTaskDefaults();
        result = result * 59 + ($taskDefaults == null ? 43 : ((Object)$taskDefaults).hashCode());
        return result;
    }

    @Generated
    public Flow withRevision(Integer revision) {
        return this.revision == revision ? this : new Flow(this.id, this.namespace, revision, this.description, this.labels, this.inputs, this.variables, this.tasks, this.errors, this.listeners, this.triggers, this.taskDefaults, this.disabled, this.deleted);
    }

    @Generated
    public static abstract class FlowBuilder<C extends Flow, B extends FlowBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String namespace;
        @Generated
        private Integer revision;
        @Generated
        private String description;
        @Generated
        private Map<String, String> labels;
        @Generated
        private List<Input> inputs;
        @Generated
        private Map<String, Object> variables;
        @Generated
        private List<Task> tasks;
        @Generated
        private List<Task> errors;
        @Generated
        private List<Listener> listeners;
        @Generated
        private List<AbstractTrigger> triggers;
        @Generated
        private List<TaskDefault> taskDefaults;
        @Generated
        private boolean disabled$set;
        @Generated
        private boolean disabled$value;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B id(@NotNull String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B namespace(@NotNull String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B revision(Integer revision) {
            this.revision = revision;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B labels(Map<String, String> labels) {
            this.labels = labels;
            return this.self();
        }

        @Generated
        public B inputs(List<Input> inputs) {
            this.inputs = inputs;
            return this.self();
        }

        @Generated
        public B variables(Map<String, Object> variables) {
            this.variables = variables;
            return this.self();
        }

        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return this.self();
        }

        @Generated
        public B listeners(List<Listener> listeners) {
            this.listeners = listeners;
            return this.self();
        }

        @Generated
        public B triggers(List<AbstractTrigger> triggers) {
            this.triggers = triggers;
            return this.self();
        }

        @Generated
        public B taskDefaults(List<TaskDefault> taskDefaults) {
            this.taskDefaults = taskDefaults;
            return this.self();
        }

        @Generated
        public B disabled(@NotNull boolean disabled) {
            this.disabled$value = disabled;
            this.disabled$set = true;
            return this.self();
        }

        @Generated
        public B deleted(@NotNull boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this.self();
        }

        @Generated
        public String toString() {
            return "Flow.FlowBuilder(id=" + this.id + ", namespace=" + this.namespace + ", revision=" + this.revision + ", description=" + this.description + ", labels=" + this.labels + ", inputs=" + this.inputs + ", variables=" + this.variables + ", tasks=" + this.tasks + ", errors=" + this.errors + ", listeners=" + this.listeners + ", triggers=" + this.triggers + ", taskDefaults=" + this.taskDefaults + ", disabled$value=" + this.disabled$value + ", deleted$value=" + this.deleted$value + ")";
        }
    }

    @Generated
    private static final class FlowBuilderImpl
    extends FlowBuilder<Flow, FlowBuilderImpl> {
        @Generated
        private FlowBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Flow build() {
            return new Flow(this);
        }
    }
}

