/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.retrys;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.kestra.core.models.tasks.retrys.Constant;
import io.kestra.core.models.tasks.retrys.Exponential;
import io.kestra.core.models.tasks.retrys.Random;
import io.micronaut.core.annotation.Introspected;
import java.time.Duration;
import javax.validation.constraints.Min;
import lombok.Generated;
import net.jodah.failsafe.RetryPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Constant.class, name="constant"), @JsonSubTypes.Type(value=Exponential.class, name="exponential"), @JsonSubTypes.Type(value=Random.class, name="random")})
@Introspected
public abstract class AbstractRetry {
    private Duration maxDuration;
    @Min(value=1L)
    private @Min(value=1L) Integer maxAttempt;
    private Boolean warningOnRetry;

    public abstract String getType();

    public <T> RetryPolicy<T> toPolicy() {
        RetryPolicy policy = new RetryPolicy();
        if (this.maxDuration != null) {
            policy.withMaxDuration(this.maxDuration);
        }
        if (this.maxAttempt != null) {
            policy.withMaxAttempts(this.maxAttempt.intValue());
        }
        return policy;
    }

    public static <T> RetryPolicy<T> retryPolicy(AbstractRetry retry) {
        if (retry != null) {
            return retry.toPolicy();
        }
        return new RetryPolicy().withMaxAttempts(1);
    }

    @Generated
    private static Boolean $default$warningOnRetry() {
        return false;
    }

    @Generated
    protected AbstractRetry(AbstractRetryBuilder<?, ?> b) {
        this.maxDuration = b.maxDuration;
        this.maxAttempt = b.maxAttempt;
        this.warningOnRetry = b.warningOnRetry$set ? b.warningOnRetry$value : AbstractRetry.$default$warningOnRetry();
    }

    @Generated
    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    @Generated
    public Integer getMaxAttempt() {
        return this.maxAttempt;
    }

    @Generated
    public Boolean getWarningOnRetry() {
        return this.warningOnRetry;
    }

    @Generated
    public AbstractRetry() {
        this.warningOnRetry = AbstractRetry.$default$warningOnRetry();
    }

    @Generated
    public static abstract class AbstractRetryBuilder<C extends AbstractRetry, B extends AbstractRetryBuilder<C, B>> {
        @Generated
        private Duration maxDuration;
        @Generated
        private Integer maxAttempt;
        @Generated
        private boolean warningOnRetry$set;
        @Generated
        private Boolean warningOnRetry$value;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B maxDuration(Duration maxDuration) {
            this.maxDuration = maxDuration;
            return this.self();
        }

        @Generated
        public B maxAttempt(Integer maxAttempt) {
            this.maxAttempt = maxAttempt;
            return this.self();
        }

        @Generated
        public B warningOnRetry(Boolean warningOnRetry) {
            this.warningOnRetry$value = warningOnRetry;
            this.warningOnRetry$set = true;
            return this.self();
        }

        @Generated
        public String toString() {
            return "AbstractRetry.AbstractRetryBuilder(maxDuration=" + this.maxDuration + ", maxAttempt=" + this.maxAttempt + ", warningOnRetry$value=" + this.warningOnRetry$value + ")";
        }
    }
}

