/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.micronaut.core.annotation.Nullable;
import java.time.Instant;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class Trigger
extends TriggerContext {
    @NotNull
    private String executionId;
    @Nullable
    private Instant updatedDate;

    @Override
    public String uid() {
        return Trigger.uid(this);
    }

    public static String uid(Trigger trigger) {
        return String.join((CharSequence)"_", Arrays.asList(trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId()));
    }

    public static String uid(Execution execution) {
        return String.join((CharSequence)"_", Arrays.asList(execution.getNamespace(), execution.getFlowId(), execution.getTrigger().getId()));
    }

    public static String uid(Flow flow, AbstractTrigger abstractTrigger) {
        return String.join((CharSequence)"_", Arrays.asList(flow.getNamespace(), flow.getId(), abstractTrigger.getId()));
    }

    public static Trigger of(Flow flow, AbstractTrigger abstractTrigger) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(flow.getNamespace())).flowId(flow.getId())).flowRevision(flow.getRevision())).triggerId(abstractTrigger.getId())).build();
    }

    public static Trigger of(TriggerContext triggerContext, Execution execution) {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(triggerContext.getNamespace())).flowId(triggerContext.getFlowId())).flowRevision(triggerContext.getFlowRevision())).triggerId(triggerContext.getTriggerId())).date(triggerContext.getDate())).executionId(execution.getId())).updatedDate(Instant.now())).build();
    }

    public Trigger resetExecution() {
        return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)Trigger.builder().namespace(this.getNamespace())).flowId(this.getFlowId())).flowRevision(this.getFlowRevision())).triggerId(this.getTriggerId())).date(this.getDate())).build();
    }

    @Generated
    protected Trigger(TriggerBuilder<?, ?> b) {
        super((TriggerContext.TriggerContextBuilder)b);
        this.executionId = b.executionId;
        this.updatedDate = b.updatedDate;
    }

    @Generated
    public static TriggerBuilder<?, ?> builder() {
        return new TriggerBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Trigger(super=" + super.toString() + ", executionId=" + this.getExecutionId() + ", updatedDate=" + this.getUpdatedDate() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        Instant this$updatedDate = this.getUpdatedDate();
        Instant other$updatedDate = other.getUpdatedDate();
        return !(this$updatedDate == null ? other$updatedDate != null : !((Object)this$updatedDate).equals(other$updatedDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Trigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        Instant $updatedDate = this.getUpdatedDate();
        result = result * 59 + ($updatedDate == null ? 43 : ((Object)$updatedDate).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Generated
    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    @Generated
    public Trigger() {
    }

    @Generated
    public static abstract class TriggerBuilder<C extends Trigger, B extends TriggerBuilder<C, B>>
    extends TriggerContext.TriggerContextBuilder<C, B> {
        @Generated
        private String executionId;
        @Generated
        private Instant updatedDate;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B executionId(@NotNull String executionId) {
            this.executionId = executionId;
            return (B)this.self();
        }

        @Generated
        public B updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Trigger.TriggerBuilder(super=" + super.toString() + ", executionId=" + this.executionId + ", updatedDate=" + this.updatedDate + ")";
        }
    }

    @Generated
    private static final class TriggerBuilderImpl
    extends TriggerBuilder<Trigger, TriggerBuilderImpl> {
        @Generated
        private TriggerBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Trigger build() {
            return new Trigger(this);
        }
    }
}

