/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.micronaut.core.annotation.Introspected;
import java.time.ZonedDateTime;
import java.util.Arrays;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Introspected
public class TriggerContext {
    @NotNull
    private String namespace;
    @NotNull
    private String flowId;
    @NotNull
    private Integer flowRevision;
    @NotNull
    private String triggerId;
    @NotNull
    private ZonedDateTime date;

    public String uid() {
        return TriggerContext.uid(this);
    }

    public static String uid(TriggerContext trigger) {
        return String.join((CharSequence)"_", Arrays.asList(trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId()));
    }

    @Generated
    protected TriggerContext(TriggerContextBuilder<?, ?> b) {
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.flowRevision = b.flowRevision;
        this.triggerId = b.triggerId;
        this.date = b.date;
    }

    @Generated
    public static TriggerContextBuilder<?, ?> builder() {
        return new TriggerContextBuilderImpl();
    }

    @Generated
    public String toString() {
        return "TriggerContext(namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", flowRevision=" + this.getFlowRevision() + ", triggerId=" + this.getTriggerId() + ", date=" + this.getDate() + ")";
    }

    @NotNull
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @NotNull
    @Generated
    public Integer getFlowRevision() {
        return this.flowRevision;
    }

    @NotNull
    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @NotNull
    @Generated
    public ZonedDateTime getDate() {
        return this.date;
    }

    @Generated
    public TriggerContext() {
    }

    @Generated
    public static abstract class TriggerContextBuilder<C extends TriggerContext, B extends TriggerContextBuilder<C, B>> {
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Integer flowRevision;
        @Generated
        private String triggerId;
        @Generated
        private ZonedDateTime date;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B namespace(@NotNull String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B flowId(@NotNull String flowId) {
            this.flowId = flowId;
            return this.self();
        }

        @Generated
        public B flowRevision(@NotNull Integer flowRevision) {
            this.flowRevision = flowRevision;
            return this.self();
        }

        @Generated
        public B triggerId(@NotNull String triggerId) {
            this.triggerId = triggerId;
            return this.self();
        }

        @Generated
        public B date(@NotNull ZonedDateTime date) {
            this.date = date;
            return this.self();
        }

        @Generated
        public String toString() {
            return "TriggerContext.TriggerContextBuilder(namespace=" + this.namespace + ", flowId=" + this.flowId + ", flowRevision=" + this.flowRevision + ", triggerId=" + this.triggerId + ", date=" + this.date + ")";
        }
    }

    @Generated
    private static final class TriggerContextBuilderImpl
    extends TriggerContextBuilder<TriggerContext, TriggerContextBuilderImpl> {
        @Generated
        private TriggerContextBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerContextBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TriggerContext build() {
            return new TriggerContext(this);
        }
    }
}

