/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import com.github.jknack.handlebars.internal.lang3.ObjectUtils;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.ExternalPlugin;
import io.kestra.core.storages.StorageInterface;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;

public class RegisteredPlugin {
    private final ExternalPlugin externalPlugin;
    private final Manifest manifest;
    private final ClassLoader classLoader;
    private final List<Class<? extends Task>> tasks;
    private final List<Class<? extends AbstractTrigger>> triggers;
    private final List<Class<? extends Condition>> conditions;
    private final List<Class<?>> controllers;
    private final List<Class<? extends StorageInterface>> storages;

    public boolean isValid() {
        return this.tasks.size() > 0 || this.triggers.size() > 0 || this.conditions.size() > 0 || this.controllers.size() > 0 || this.storages.size() > 0;
    }

    public boolean hasClass(String cls) {
        return this.allClass().stream().anyMatch(r -> r.getName().equals(cls));
    }

    public Optional<Class> findClass(String cls) {
        return this.allClass().stream().filter(r -> r.getName().equals(cls)).findFirst();
    }

    public Class baseClass(String cls) {
        if (this.getTasks().stream().anyMatch(r -> r.getName().equals(cls))) {
            return Task.class;
        }
        if (this.getTriggers().stream().anyMatch(r -> r.getName().equals(cls))) {
            return AbstractTrigger.class;
        }
        if (this.getConditions().stream().anyMatch(r -> r.getName().equals(cls))) {
            return Condition.class;
        }
        if (this.getStorages().stream().anyMatch(r -> r.getName().equals(cls))) {
            return StorageInterface.class;
        }
        if (this.getTasks().stream().anyMatch(r -> r.getName().equals(cls))) {
            return Task.class;
        }
        throw new IllegalArgumentException("Unable to find base class from '" + cls + "'");
    }

    public List<Class> allClass() {
        return this.allClassGrouped().entrySet().stream().flatMap(map -> ((List)map.getValue()).stream()).collect(Collectors.toList());
    }

    public Map<String, List<Class>> allClassGrouped() {
        HashMap<String, List<Class>> result = new HashMap<String, List<Class>>();
        result.put("tasks", Arrays.asList((Class[])this.getTasks().toArray(Class[]::new)));
        result.put("triggers", Arrays.asList((Class[])this.getTriggers().toArray(Class[]::new)));
        result.put("conditions", Arrays.asList((Class[])this.getConditions().toArray(Class[]::new)));
        result.put("controllers", Arrays.asList((Class[])this.getControllers().toArray(Class[]::new)));
        result.put("storages", Arrays.asList((Class[])this.getStorages().toArray(Class[]::new)));
        return result;
    }

    public String title() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{this.getManifest() != null ? this.getManifest().getMainAttributes().getValue("X-Kestra-Title") : null, this.getExternalPlugin() != null ? FilenameUtils.getBaseName((String)this.getExternalPlugin().getLocation().getPath()) : null, "Core"});
    }

    public String group() {
        return this.getManifest() == null ? null : this.getManifest().getMainAttributes().getValue("X-Kestra-Group");
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.getExternalPlugin() != null) {
            b.append("Found plugin on path: ").append(this.getExternalPlugin().getLocation()).append(" ");
        } else {
            b.append("Core plugin: ");
        }
        if (!this.getTasks().isEmpty()) {
            b.append("[Tasks: ");
            b.append(this.getTasks().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getTriggers().isEmpty()) {
            b.append("[Triggers: ");
            b.append(this.getTriggers().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getConditions().isEmpty()) {
            b.append("[Conditions: ");
            b.append(this.getConditions().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getControllers().isEmpty()) {
            b.append("[Controllers: ");
            b.append(this.getControllers().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        if (!this.getStorages().isEmpty()) {
            b.append("[Storages: ");
            b.append(this.getStorages().stream().map(Class::getName).collect(Collectors.joining(", ")));
            b.append("] ");
        }
        return b.toString();
    }

    @Generated
    public static RegisteredPluginBuilder builder() {
        return new RegisteredPluginBuilder();
    }

    @ConstructorProperties(value={"externalPlugin", "manifest", "classLoader", "tasks", "triggers", "conditions", "controllers", "storages"})
    @Generated
    public RegisteredPlugin(ExternalPlugin externalPlugin, Manifest manifest, ClassLoader classLoader, List<Class<? extends Task>> tasks, List<Class<? extends AbstractTrigger>> triggers, List<Class<? extends Condition>> conditions, List<Class<?>> controllers, List<Class<? extends StorageInterface>> storages) {
        this.externalPlugin = externalPlugin;
        this.manifest = manifest;
        this.classLoader = classLoader;
        this.tasks = tasks;
        this.triggers = triggers;
        this.conditions = conditions;
        this.controllers = controllers;
        this.storages = storages;
    }

    @Generated
    public ExternalPlugin getExternalPlugin() {
        return this.externalPlugin;
    }

    @Generated
    public Manifest getManifest() {
        return this.manifest;
    }

    @Generated
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Generated
    public List<Class<? extends Task>> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<Class<? extends AbstractTrigger>> getTriggers() {
        return this.triggers;
    }

    @Generated
    public List<Class<? extends Condition>> getConditions() {
        return this.conditions;
    }

    @Generated
    public List<Class<?>> getControllers() {
        return this.controllers;
    }

    @Generated
    public List<Class<? extends StorageInterface>> getStorages() {
        return this.storages;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredPlugin)) {
            return false;
        }
        RegisteredPlugin other = (RegisteredPlugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExternalPlugin this$externalPlugin = this.getExternalPlugin();
        ExternalPlugin other$externalPlugin = other.getExternalPlugin();
        if (this$externalPlugin == null ? other$externalPlugin != null : !((Object)this$externalPlugin).equals(other$externalPlugin)) {
            return false;
        }
        Manifest this$manifest = this.getManifest();
        Manifest other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        ClassLoader this$classLoader = this.getClassLoader();
        ClassLoader other$classLoader = other.getClassLoader();
        if (this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader)) {
            return false;
        }
        List<Class<? extends Task>> this$tasks = this.getTasks();
        List<Class<? extends Task>> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Class<? extends AbstractTrigger>> this$triggers = this.getTriggers();
        List<Class<? extends AbstractTrigger>> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        List<Class<? extends Condition>> this$conditions = this.getConditions();
        List<Class<? extends Condition>> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<Class<?>> this$controllers = this.getControllers();
        List<Class<?>> other$controllers = other.getControllers();
        if (this$controllers == null ? other$controllers != null : !((Object)this$controllers).equals(other$controllers)) {
            return false;
        }
        List<Class<? extends StorageInterface>> this$storages = this.getStorages();
        List<Class<? extends StorageInterface>> other$storages = other.getStorages();
        return !(this$storages == null ? other$storages != null : !((Object)this$storages).equals(other$storages));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegisteredPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExternalPlugin $externalPlugin = this.getExternalPlugin();
        result = result * 59 + ($externalPlugin == null ? 43 : ((Object)$externalPlugin).hashCode());
        Manifest $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        ClassLoader $classLoader = this.getClassLoader();
        result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
        List<Class<? extends Task>> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Class<? extends AbstractTrigger>> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        List<Class<? extends Condition>> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<Class<?>> $controllers = this.getControllers();
        result = result * 59 + ($controllers == null ? 43 : ((Object)$controllers).hashCode());
        List<Class<? extends StorageInterface>> $storages = this.getStorages();
        result = result * 59 + ($storages == null ? 43 : ((Object)$storages).hashCode());
        return result;
    }

    @Generated
    public static class RegisteredPluginBuilder {
        @Generated
        private ExternalPlugin externalPlugin;
        @Generated
        private Manifest manifest;
        @Generated
        private ClassLoader classLoader;
        @Generated
        private List<Class<? extends Task>> tasks;
        @Generated
        private List<Class<? extends AbstractTrigger>> triggers;
        @Generated
        private List<Class<? extends Condition>> conditions;
        @Generated
        private List<Class<?>> controllers;
        @Generated
        private List<Class<? extends StorageInterface>> storages;

        @Generated
        RegisteredPluginBuilder() {
        }

        @Generated
        public RegisteredPluginBuilder externalPlugin(ExternalPlugin externalPlugin) {
            this.externalPlugin = externalPlugin;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder manifest(Manifest manifest) {
            this.manifest = manifest;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder tasks(List<Class<? extends Task>> tasks) {
            this.tasks = tasks;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder triggers(List<Class<? extends AbstractTrigger>> triggers) {
            this.triggers = triggers;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder conditions(List<Class<? extends Condition>> conditions) {
            this.conditions = conditions;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder controllers(List<Class<?>> controllers) {
            this.controllers = controllers;
            return this;
        }

        @Generated
        public RegisteredPluginBuilder storages(List<Class<? extends StorageInterface>> storages) {
            this.storages = storages;
            return this;
        }

        @Generated
        public RegisteredPlugin build() {
            return new RegisteredPlugin(this.externalPlugin, this.manifest, this.classLoader, this.tasks, this.triggers, this.conditions, this.controllers, this.storages);
        }

        @Generated
        public String toString() {
            return "RegisteredPlugin.RegisteredPluginBuilder(externalPlugin=" + this.externalPlugin + ", manifest=" + this.manifest + ", classLoader=" + this.classLoader + ", tasks=" + this.tasks + ", triggers=" + this.triggers + ", conditions=" + this.conditions + ", controllers=" + this.controllers + ", storages=" + this.storages + ")";
        }
    }
}

