/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.models.flows.Flow;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.serializers.YamlFlowParser;
import io.kestra.core.utils.Rethrow;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolationException;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalFlowRepositoryLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalFlowRepositoryLoader.class);
    @Inject
    private YamlFlowParser yamlFlowParser;
    @Inject
    private FlowRepositoryInterface flowRepository;

    public void load(URL basePath) throws IOException, URISyntaxException {
        URI uri = basePath.toURI();
        if (uri.getScheme().equals("jar")) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                String substring = uri.toString().substring(uri.toString().indexOf("!") + 1);
                Path tempDirectory = Files.createTempDirectory("loader", new FileAttribute[0]);
                for (Path path1 : fileSystem.getRootDirectories()) {
                    Files.walk(path1, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.startsWith(substring)).forEach(Rethrow.throwConsumer(path -> FileUtils.copyURLToFile((URL)path.toUri().toURL(), (File)tempDirectory.resolve(path.toString().substring(1)).toFile())));
                }
                this.load(tempDirectory.toFile());
            }
        } else {
            this.load(Paths.get(uri).toFile());
        }
    }

    public void load(File basePath) throws IOException {
        List list = Files.walk(basePath.toPath(), new FileVisitOption[0]).filter(YamlFlowParser::isValidExtension).collect(Collectors.toList());
        for (Path file : list) {
            try {
                Flow parse = this.yamlFlowParser.parse(file.toFile());
                this.flowRepository.create(parse);
                log.trace("Created flow {}.{}", (Object)parse.getNamespace(), (Object)parse.getId());
            }
            catch (ConstraintViolationException e) {
                log.warn("Unable to create flow {}", (Object)file, (Object)e);
            }
        }
    }
}

