/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.handlebars.helpers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import io.kestra.core.serializers.JacksonMapper;

public enum JsonHelper implements Helper<Object>
{
    json{

        public CharSequence apply(Object value, Options options) {
            try {
                return JacksonMapper.ofJson().writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }
    ,
    isJson{

        public Boolean apply(Object value, Options options) {
            try {
                JacksonMapper.ofJson().readTree((String)value);
                return true;
            }
            catch (JsonProcessingException e) {
                return false;
            }
        }
    };

}

