/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.hierarchies.AbstractGraphTask;
import io.kestra.core.models.hierarchies.FlowGraph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.GraphTask;
import io.kestra.core.models.hierarchies.Relation;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class GraphService {
    public static GraphCluster of(Flow flow, Execution execution) throws IllegalVariableEvaluationException {
        GraphCluster graph = new GraphCluster();
        GraphService.sequential(graph, flow.getTasks(), flow.getErrors(), null, execution);
        return graph;
    }

    public static List<AbstractGraphTask> nodes(GraphCluster graphCluster) {
        return graphCluster.getGraph().nodes().stream().flatMap(t -> t instanceof GraphCluster ? GraphService.nodes((GraphCluster)t).stream() : Stream.of(t)).distinct().collect(Collectors.toList());
    }

    private static List<Triple<AbstractGraphTask, AbstractGraphTask, Relation>> rawEdges(GraphCluster graphCluster) {
        return Stream.concat(graphCluster.getGraph().edges().stream().map(r -> Triple.of((Object)((AbstractGraphTask)r.getSource()), (Object)((AbstractGraphTask)r.getTarget()), (Object)((Relation)r.getValue()))), graphCluster.getGraph().nodes().stream().flatMap(t -> t instanceof GraphCluster ? GraphService.rawEdges((GraphCluster)t).stream() : Stream.of(new Triple[0]))).collect(Collectors.toList());
    }

    public static List<FlowGraph.Edge> edges(GraphCluster graphCluster) {
        return GraphService.rawEdges(graphCluster).stream().map(r -> new FlowGraph.Edge(((AbstractGraphTask)r.getLeft()).getUid(), ((AbstractGraphTask)r.getMiddle()).getUid(), (Relation)r.getRight())).collect(Collectors.toList());
    }

    public static List<Pair<GraphCluster, List<String>>> clusters(GraphCluster graphCluster, List<String> parents) {
        return graphCluster.getGraph().nodes().stream().flatMap(t -> {
            if (t instanceof GraphCluster) {
                ArrayList<String> currentParents = new ArrayList<String>(parents);
                currentParents.add(t.getUid());
                return Stream.concat(Stream.of(Pair.of((Object)((GraphCluster)t), (Object)parents)), GraphService.clusters((GraphCluster)t, currentParents).stream());
            }
            return Stream.of(new Pair[0]);
        }).collect(Collectors.toList());
    }

    public static Set<AbstractGraphTask> successors(GraphCluster graphCluster, List<String> taskRunIds) {
        List<FlowGraph.Edge> edges = GraphService.edges(graphCluster);
        List<AbstractGraphTask> nodes = GraphService.nodes(graphCluster);
        List selectedTaskRuns = nodes.stream().filter(task -> task.getTaskRun() != null && taskRunIds.contains(task.getTaskRun().getId())).collect(Collectors.toList());
        Set edgeUuid = selectedTaskRuns.stream().flatMap(task -> GraphService.recursiveEdge(edges, task.getUid()).stream()).map(FlowGraph.Edge::getSource).collect(Collectors.toSet());
        return nodes.stream().filter(task -> edgeUuid.contains(task.getUid())).collect(Collectors.toSet());
    }

    private static List<FlowGraph.Edge> recursiveEdge(List<FlowGraph.Edge> edges, String selectedUuid) {
        return edges.stream().filter(edge -> edge.getSource().equals(selectedUuid)).flatMap(edge -> Stream.concat(Stream.of(edge), GraphService.recursiveEdge(edges, edge.getTarget()).stream())).collect(Collectors.toList());
    }

    public static void sequential(GraphCluster graph, List<Task> tasks, List<Task> errors, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        GraphService.iterate(graph, tasks, errors, parent, execution, RelationType.SEQUENTIAL);
    }

    public static void parallel(GraphCluster graph, List<Task> tasks, List<Task> errors, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        GraphService.iterate(graph, tasks, errors, parent, execution, RelationType.PARALLEL);
    }

    public static void switchCase(GraphCluster graph, Map<String, List<Task>> tasks, List<Task> errors, TaskRun parent, Execution execution) throws IllegalVariableEvaluationException {
        for (Map.Entry<String, List<Task>> entry : tasks.entrySet()) {
            GraphService.fillGraph(graph, entry.getValue(), RelationType.SEQUENTIAL, parent, execution, entry.getKey());
        }
        if (errors != null && errors.size() > 0) {
            GraphService.fillGraph(graph, errors, RelationType.ERROR, parent, execution, null);
        }
    }

    private static void iterate(GraphCluster graph, List<Task> tasks, List<Task> errors, TaskRun parent, Execution execution, RelationType relationType) throws IllegalVariableEvaluationException {
        GraphService.fillGraph(graph, tasks, relationType, parent, execution, null);
        if (errors != null && errors.size() > 0) {
            GraphService.fillGraph(graph, errors, RelationType.ERROR, parent, execution, null);
        }
    }

    private static void fillGraph(GraphCluster graph, List<Task> tasks, RelationType relationType, TaskRun parent, Execution execution, String value) throws IllegalVariableEvaluationException {
        Iterator<Task> iterator = tasks.iterator();
        AbstractGraphTask previous = graph.getRoot();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            Task currentTask = iterator.next();
            for (TaskRun currentTaskRun : GraphService.findTaskRuns(currentTask, execution, parent)) {
                AbstractGraphTask currentGraph;
                List<String> parentValues = null;
                RelationType newRelation = graph.getRelationType();
                if (relationType == RelationType.ERROR) {
                    newRelation = relationType;
                } else if (!isFirst && relationType != RelationType.PARALLEL && graph.getRelationType() != RelationType.DYNAMIC) {
                    newRelation = relationType;
                }
                Relation relation = new Relation(newRelation, currentTaskRun == null ? value : currentTaskRun.getValue());
                if (execution != null && currentTaskRun != null) {
                    parentValues = execution.findChildsValues(currentTaskRun, true);
                }
                if (currentTask instanceof FlowableTask) {
                    FlowableTask flowableTask = (FlowableTask)((Object)currentTask);
                    currentGraph = flowableTask.tasksTree(execution, currentTaskRun, parentValues);
                } else {
                    currentGraph = new GraphTask(currentTask, currentTaskRun, parentValues, relationType);
                }
                graph.getGraph().addNode(currentGraph);
                if (previous != null) {
                    graph.getGraph().addEdge(previous instanceof GraphCluster ? ((GraphCluster)previous).getEnd() : previous, currentGraph instanceof GraphCluster ? ((GraphCluster)currentGraph).getRoot() : currentGraph, relation);
                }
                if (relationType != RelationType.PARALLEL) {
                    previous = currentGraph;
                }
                if (GraphService.isAllLinkToEnd(relationType)) {
                    graph.getGraph().addEdge(currentGraph instanceof GraphCluster ? ((GraphCluster)currentGraph).getEnd() : currentGraph, graph.getEnd(), new Relation());
                }
                isFirst = false;
                if (iterator.hasNext() || GraphService.isAllLinkToEnd(relationType)) continue;
                graph.getGraph().addEdge(currentGraph instanceof GraphCluster ? ((GraphCluster)currentGraph).getEnd() : currentGraph, graph.getEnd(), new Relation());
            }
        }
    }

    private static boolean isAllLinkToEnd(RelationType relationType) {
        return relationType == RelationType.PARALLEL || relationType == RelationType.CHOICE;
    }

    private static List<TaskRun> findTaskRuns(Task task, Execution execution, TaskRun parent) {
        List<Object> taskRuns;
        List<Object> list = taskRuns = execution != null ? execution.findTaskRunsByTaskId(task.getId()) : new ArrayList();
        if (taskRuns.size() == 0) {
            return Collections.singletonList(null);
        }
        return taskRuns.stream().filter(taskRun -> parent == null || taskRun.getParentTaskRunId().equals(parent.getId())).collect(Collectors.toList());
    }
}

