/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.runners.WorkerInstance;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WorkerInstanceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerInstanceService.class);

    public static List<WorkerInstance> removeEvictedPartitions(Stream<WorkerInstance> stream, WorkerInstance incoming) {
        List changedInstance = stream.filter(r -> !r.getWorkerUuid().toString().equals(incoming.getWorkerUuid().toString())).filter(r -> !Collections.disjoint(r.getPartitions(), incoming.getPartitions())).collect(Collectors.toList());
        if (changedInstance.size() >= 1) {
            return changedInstance.stream().map(evictedInstance -> {
                evictedInstance.getPartitions().removeAll(incoming.getPartitions());
                return evictedInstance;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

