/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.GraphService;
import io.kestra.core.tasks.flows.Sequential;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Execute a tasks for a list of value sequentially", description="For each `value`, `tasks` will be executed\nThe value must be valid json string representing an arrays, like `[\"value1\", \"value2\"]` or `[{\"key\":\"value1\"}, {\"key\":\"value2\"}]` \nThe current value is available on vars `{{ taskrun.value }}`.")
@Plugin(examples={@Example(code={"value: '[\"value 1\", \"value 2\", \"value 3\"]'", "tasks:", "  - id: each-value", "    type: io.kestra.core.tasks.debugs.Return", "    format: \"{{ task.id }} with current value '{{ taskrun.value }}'\""})})
public class EachSequential
extends Sequential
implements FlowableTask<VoidOutput> {
    @NotNull
    @NotBlank
    private String value;
    @Valid
    protected List<Task> errors;

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.DYNAMIC);
        GraphService.sequential(subGraph, this.getTasks(), this.errors, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.value);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = this.childTasks(runContext, parentTaskRun);
        if (childTasks.size() == 0) {
            return Optional.of(State.Type.SUCCESS);
        }
        return FlowableUtils.resolveState(execution, childTasks, FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), parentTaskRun, runContext);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveSequentialNexts(execution, FlowableUtils.resolveEachTasks(runContext, parentTaskRun, this.getTasks(), this.value), FlowableUtils.resolveTasks(this.errors, parentTaskRun), parentTaskRun);
    }

    @Generated
    protected EachSequential(EachSequentialBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder<?, ?>)b);
        this.value = b.value;
        this.errors = b.errors;
    }

    @Generated
    public static EachSequentialBuilder<?, ?> builder() {
        return new EachSequentialBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "EachSequential(super=" + super.toString() + ", value=" + this.getValue() + ", errors=" + this.getErrors() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EachSequential)) {
            return false;
        }
        EachSequential other = (EachSequential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EachSequential;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public String getValue() {
        return this.value;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public EachSequential() {
    }

    @Generated
    public static abstract class EachSequentialBuilder<C extends EachSequential, B extends EachSequentialBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Generated
        private String value;
        @Generated
        private List<Task> errors;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B value(@NotNull String value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "EachSequential.EachSequentialBuilder(super=" + super.toString() + ", value=" + this.value + ", errors=" + this.errors + ")";
        }
    }

    @Generated
    private static final class EachSequentialBuilderImpl
    extends EachSequentialBuilder<EachSequential, EachSequentialBuilderImpl> {
        @Generated
        private EachSequentialBuilderImpl() {
        }

        @Override
        @Generated
        protected EachSequentialBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EachSequential build() {
            return new EachSequential(this);
        }
    }
}

