/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.GraphService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Process task in parallel", description="This task processes tasks in parallel. It makes it convinient to process many tasks at once.")
@Plugin(examples={@Example(full=true, code={"id: parallel", "namespace: io.kestra.tests\n", "tasks:\n  - id: parallel\n    type: io.kestra.core.tasks.flows.Parallel\n    tasks:\n      - id: 1st\n        type: io.kestra.core.tasks.debugs.Return\n        format: \"{{task.id}} > {{taskrun.startDate}}\"\n      - id: 2nd\n        type: io.kestra.core.tasks.debugs.Return\n        format: \"{{task.id}} > {{taskrun.id}}\"\n  - id: last\n    type: io.kestra.core.tasks.debugs.Return\n    format: \"{{task.id}} > {{taskrun.startDate}}\""})})
public class Parallel
extends Task
implements FlowableTask<VoidOutput> {
    @NotNull
    @NotBlank
    @Schema(title="Number of concurrent parrallels tasks", description="If the value is `0`, no limit exist and all the tasks will start at the same time")
    private final Integer concurrent;
    @Valid
    private List<Task> tasks;
    @Valid
    private List<Task> errors;

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.PARALLEL);
        GraphService.parallel(subGraph, this.tasks, this.errors, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        return Stream.concat(this.tasks != null ? this.tasks.stream() : Stream.empty(), this.errors != null ? this.errors.stream() : Stream.empty()).collect(Collectors.toList());
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveTasks(this.tasks, parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        return FlowableUtils.resolveParallelNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), parentTaskRun, this.concurrent);
    }

    @Generated
    private static Integer $default$concurrent() {
        return 0;
    }

    @Generated
    protected Parallel(ParallelBuilder<?, ?> b) {
        super(b);
        this.concurrent = b.concurrent$set ? b.concurrent$value : Parallel.$default$concurrent();
        this.tasks = b.tasks;
        this.errors = b.errors;
    }

    @Generated
    public static ParallelBuilder<?, ?> builder() {
        return new ParallelBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Parallel(super=" + super.toString() + ", concurrent=" + this.getConcurrent() + ", tasks=" + this.getTasks() + ", errors=" + this.getErrors() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parallel)) {
            return false;
        }
        Parallel other = (Parallel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$concurrent = this.getConcurrent();
        Integer other$concurrent = other.getConcurrent();
        if (this$concurrent == null ? other$concurrent != null : !((Object)this$concurrent).equals(other$concurrent)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Parallel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $concurrent = this.getConcurrent();
        result = result * 59 + ($concurrent == null ? 43 : ((Object)$concurrent).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @NotNull
    @Generated
    public Integer getConcurrent() {
        return this.concurrent;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public Parallel() {
        this.concurrent = Parallel.$default$concurrent();
    }

    @Generated
    public static abstract class ParallelBuilder<C extends Parallel, B extends ParallelBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private boolean concurrent$set;
        @Generated
        private Integer concurrent$value;
        @Generated
        private List<Task> tasks;
        @Generated
        private List<Task> errors;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B concurrent(@NotNull Integer concurrent) {
            this.concurrent$value = concurrent;
            this.concurrent$set = true;
            return (B)this.self();
        }

        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Parallel.ParallelBuilder(super=" + super.toString() + ", concurrent$value=" + this.concurrent$value + ", tasks=" + this.tasks + ", errors=" + this.errors + ")";
        }
    }

    @Generated
    private static final class ParallelBuilderImpl
    extends ParallelBuilder<Parallel, ParallelBuilderImpl> {
        @Generated
        private ParallelBuilderImpl() {
        }

        @Override
        @Generated
        protected ParallelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Parallel build() {
            return new Parallel(this);
        }
    }
}

