/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.states;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.states.AbstractState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import java.util.Map;
import lombok.Generated;

@Schema(title="Get a state from internal storage.")
@Plugin(examples={@Example(title="Get a state isolated by flow with `default` state name ", code={"id: getState", "type: io.kestra.core.tasks.states.Get"}, full=true)})
public class Get
extends AbstractState
implements RunnableTask<Output> {
    @Schema(title="raise an error if the state is not found")
    @PluginProperty(dynamic=true)
    private final Boolean errorOnMissing;

    @Override
    public Output run(RunContext runContext) throws Exception {
        Map<String, Object> data;
        try {
            data = this.get(runContext);
        }
        catch (FileNotFoundException e) {
            if (this.errorOnMissing.booleanValue()) {
                throw e;
            }
            data = Map.of();
        }
        return Output.builder().count(data.size()).data(data).build();
    }

    @Generated
    private static Boolean $default$errorOnMissing() {
        return false;
    }

    @Generated
    protected Get(GetBuilder<?, ?> b) {
        super((AbstractState.AbstractStateBuilder)b);
        this.errorOnMissing = b.errorOnMissing$set ? b.errorOnMissing$value : Get.$default$errorOnMissing();
    }

    @Generated
    public static GetBuilder<?, ?> builder() {
        return new GetBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Get(super=" + super.toString() + ", errorOnMissing=" + this.getErrorOnMissing() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Get)) {
            return false;
        }
        Get other = (Get)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$errorOnMissing = this.getErrorOnMissing();
        Boolean other$errorOnMissing = other.getErrorOnMissing();
        return !(this$errorOnMissing == null ? other$errorOnMissing != null : !((Object)this$errorOnMissing).equals(other$errorOnMissing));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Get;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $errorOnMissing = this.getErrorOnMissing();
        result = result * 59 + ($errorOnMissing == null ? 43 : ((Object)$errorOnMissing).hashCode());
        return result;
    }

    @Generated
    public Boolean getErrorOnMissing() {
        return this.errorOnMissing;
    }

    @Generated
    public Get() {
        this.errorOnMissing = Get.$default$errorOnMissing();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The count of properties found in the state")
        private final int count;
        @Schema(title="The data extracted from state")
        private final Map<String, Object> data;

        @ConstructorProperties(value={"count", "data"})
        @Generated
        Output(int count, Map<String, Object> data) {
            this.count = count;
            this.data = data;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public Map<String, Object> getData() {
            return this.data;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private int count;
            @Generated
            private Map<String, Object> data;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder count(int count) {
                this.count = count;
                return this;
            }

            @Generated
            public OutputBuilder data(Map<String, Object> data) {
                this.data = data;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.count, this.data);
            }

            @Generated
            public String toString() {
                return "Get.Output.OutputBuilder(count=" + this.count + ", data=" + this.data + ")";
            }
        }
    }

    @Generated
    public static abstract class GetBuilder<C extends Get, B extends GetBuilder<C, B>>
    extends AbstractState.AbstractStateBuilder<C, B> {
        @Generated
        private boolean errorOnMissing$set;
        @Generated
        private Boolean errorOnMissing$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B errorOnMissing(Boolean errorOnMissing) {
            this.errorOnMissing$value = errorOnMissing;
            this.errorOnMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Get.GetBuilder(super=" + super.toString() + ", errorOnMissing$value=" + this.errorOnMissing$value + ")";
        }
    }

    @Generated
    private static final class GetBuilderImpl
    extends GetBuilder<Get, GetBuilderImpl> {
        @Generated
        private GetBuilderImpl() {
        }

        @Override
        @Generated
        protected GetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Get build() {
            return new Get(this);
        }
    }
}

