/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.storages;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.apache.commons.io.IOUtils;

@Schema(title="Concat files from internal storage.")
@Plugin(examples={@Example(title="Concat 2 files with a custom separator", code={"files: ", "  - \"kestra://long/url/file1.txt\"", "  - \"kestra://long/url/file2.txt\"", "separator: \"\\n\""}), @Example(title="Concat file generated by a each tasks", code={"tasks:", "  - id: each", "    type: io.kestra.core.tasks.flows.EachSequential", "    tasks:", "      - id: start_api_call", "        type: io.kestra.core.tasks.scripts.Bash", "        commands:", "          - echo {{ taskrun.value }} > {{ temp.generated }}", "        files:", "          - generated", "    value: '[\"value1\", \"value2\", \"value3\"]'", "  - id: concat", "    type: io.kestra.core.tasks.storages.Concat", "    files:", "      - \"{{ outputs.start_api_call.value1.files.generated }}\"", "      - \"{{ outputs.start_api_call.value2.files.generated }}\"", "      - \"{{ outputs.start_api_call.value3.files.generated }}\""}, full=true), @Example(title="Concat dynamic number of files", code={"tasks:", "  - id: echo", "    type: io.kestra.core.tasks.scripts.Bash", "    commands:", "      - echo \"Hello John\" > {{ outputDirs.output }}/1.txt", "      - echo \"Hello Jane\" > {{ outputDirs.output }}/2.txt", "      - echo \"Hello Doe\" > {{ outputDirs.output }}/3.txt", "    outputDirs:", "      - output", "  - id: concat", "    type: io.kestra.core.tasks.storages.Concat", "    files: \"{{ outputs.echo.files | jq('.[]') }}\""}, full=true)})
public class Concat
extends Task
implements RunnableTask<Output> {
    @Schema(title="List of files to be concatenated.", description="Must be a `kestra://` storage urls, can be a list of string or json string")
    @PluginProperty(dynamic=true)
    private Object files;
    @Schema(title="The separator to used between files, default is no separator")
    @PluginProperty(dynamic=true)
    private String separator;

    @Override
    public Output run(RunContext runContext) throws Exception {
        File tempFile = runContext.tempFile().toFile();
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
            List finalFiles;
            if (this.files instanceof List) {
                finalFiles = (List)this.files;
            } else if (this.files instanceof String) {
                TypeReference<List<String>> reference = new TypeReference<List<String>>(){};
                finalFiles = (List)JacksonMapper.ofJson(false).readValue(runContext.render((String)this.files), (TypeReference)reference);
            } else {
                throw new Exception("Invalid `files` properties with type '" + this.files.getClass() + "'");
            }
            finalFiles.forEach(Rethrow.throwConsumer(s -> {
                URI from = new URI(runContext.render((String)s));
                IOUtils.copyLarge((InputStream)runContext.uriToInputStream(from), (OutputStream)fileOutputStream);
                if (this.separator != null) {
                    IOUtils.copy((InputStream)new ByteArrayInputStream(this.separator.getBytes()), (OutputStream)fileOutputStream);
                }
            }));
        }
        return Output.builder().uri(runContext.putTempFile(tempFile)).build();
    }

    @Generated
    protected Concat(ConcatBuilder<?, ?> b) {
        super(b);
        this.files = b.files;
        this.separator = b.separator;
    }

    @Generated
    public static ConcatBuilder<?, ?> builder() {
        return new ConcatBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Concat(super=" + super.toString() + ", files=" + this.getFiles() + ", separator=" + this.getSeparator() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Concat)) {
            return false;
        }
        Concat other = (Concat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Object this$files = this.getFiles();
        Object other$files = other.getFiles();
        if (this$files == null ? other$files != null : !this$files.equals(other$files)) {
            return false;
        }
        String this$separator = this.getSeparator();
        String other$separator = other.getSeparator();
        return !(this$separator == null ? other$separator != null : !this$separator.equals(other$separator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Concat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Object $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : $files.hashCode());
        String $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        return result;
    }

    @Generated
    public Object getFiles() {
        return this.files;
    }

    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public Concat() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The concatenate file uri.")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "Concat.Output.OutputBuilder(uri=" + this.uri + ")";
            }
        }
    }

    @Generated
    public static abstract class ConcatBuilder<C extends Concat, B extends ConcatBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Object files;
        @Generated
        private String separator;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B files(Object files) {
            this.files = files;
            return (B)this.self();
        }

        @Generated
        public B separator(String separator) {
            this.separator = separator;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Concat.ConcatBuilder(super=" + super.toString() + ", files=" + this.files + ", separator=" + this.separator + ")";
        }
    }

    @Generated
    private static final class ConcatBuilderImpl
    extends ConcatBuilder<Concat, ConcatBuilderImpl> {
        @Generated
        private ConcatBuilderImpl() {
        }

        @Override
        @Generated
        protected ConcatBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Concat build() {
            return new Concat(this);
        }
    }
}

