/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.storages;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.NoSuchElementException;
import lombok.Generated;

@Schema(title="Delete a file from internal storage.")
@Plugin(examples={@Example(code={"uri: \"kestra://long/url/file.txt\""})})
public class Delete
extends Task
implements RunnableTask<Output> {
    @Schema(title="the file to delete", description="Must be a `kestra://` storage url")
    @PluginProperty(dynamic=true)
    private String uri;
    @Schema(title="raise an error if the file is not found")
    @PluginProperty(dynamic=true)
    private final Boolean errorOnMissing;

    @Override
    public Output run(RunContext runContext) throws Exception {
        StorageInterface storageInterface = (StorageInterface)runContext.getApplicationContext().getBean(StorageInterface.class);
        URI render = URI.create(runContext.render(this.uri));
        boolean delete = storageInterface.delete(render);
        if (this.errorOnMissing.booleanValue() && !delete) {
            throw new NoSuchElementException("Unable to find file '" + render + "'");
        }
        return Output.builder().uri(render).deleted(delete).build();
    }

    @Generated
    private static Boolean $default$errorOnMissing() {
        return false;
    }

    @Generated
    protected Delete(DeleteBuilder<?, ?> b) {
        super(b);
        this.uri = b.uri;
        this.errorOnMissing = b.errorOnMissing$set ? b.errorOnMissing$value : Delete.$default$errorOnMissing();
    }

    @Generated
    public static DeleteBuilder<?, ?> builder() {
        return new DeleteBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Delete(super=" + super.toString() + ", uri=" + this.getUri() + ", errorOnMissing=" + this.getErrorOnMissing() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$errorOnMissing = this.getErrorOnMissing();
        Boolean other$errorOnMissing = other.getErrorOnMissing();
        if (this$errorOnMissing == null ? other$errorOnMissing != null : !((Object)this$errorOnMissing).equals(other$errorOnMissing)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Delete;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $errorOnMissing = this.getErrorOnMissing();
        result = result * 59 + ($errorOnMissing == null ? 43 : ((Object)$errorOnMissing).hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        return result;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public Boolean getErrorOnMissing() {
        return this.errorOnMissing;
    }

    @Generated
    public Delete() {
        this.errorOnMissing = Delete.$default$errorOnMissing();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The deleted ")
        private final URI uri;
        @Schema(title="If the files was really deleted")
        private final Boolean deleted;

        @ConstructorProperties(value={"uri", "deleted"})
        @Generated
        Output(URI uri, Boolean deleted) {
            this.uri = uri;
            this.deleted = deleted;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public Boolean getDeleted() {
            return this.deleted;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;
            @Generated
            private Boolean deleted;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public OutputBuilder deleted(Boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri, this.deleted);
            }

            @Generated
            public String toString() {
                return "Delete.Output.OutputBuilder(uri=" + this.uri + ", deleted=" + this.deleted + ")";
            }
        }
    }

    @Generated
    public static abstract class DeleteBuilder<C extends Delete, B extends DeleteBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String uri;
        @Generated
        private boolean errorOnMissing$set;
        @Generated
        private Boolean errorOnMissing$value;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B uri(String uri) {
            this.uri = uri;
            return (B)this.self();
        }

        @Generated
        public B errorOnMissing(Boolean errorOnMissing) {
            this.errorOnMissing$value = errorOnMissing;
            this.errorOnMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Delete.DeleteBuilder(super=" + super.toString() + ", uri=" + this.uri + ", errorOnMissing$value=" + this.errorOnMissing$value + ")";
        }
    }

    @Generated
    private static final class DeleteBuilderImpl
    extends DeleteBuilder<Delete, DeleteBuilderImpl> {
        @Generated
        private DeleteBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Delete build() {
            return new Delete(this);
        }
    }
}

