/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.storages;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import lombok.Generated;

@Schema(title="Purge all files from internal storage created by this execution.", description="Will delete all the generated files from a flow for this current execution. This will delete:\n+- inputs\n- outputs\n- triggers\n\n + If the current execution don't have any generated files, the task will not failed.\nIf you pass a internal storage uri from another execution, it **will not** be deleted, only current execution is deleted.")
@Plugin(examples={@Example(code={})})
public class PurgeExecution
extends Task
implements RunnableTask<Output> {
    @Override
    public Output run(RunContext runContext) throws Exception {
        return Output.builder().uris(runContext.purgeStorageExecution()).build();
    }

    @Generated
    protected PurgeExecution(PurgeExecutionBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static PurgeExecutionBuilder<?, ?> builder() {
        return new PurgeExecutionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "PurgeExecution(super=" + super.toString() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PurgeExecution)) {
            return false;
        }
        PurgeExecution other = (PurgeExecution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PurgeExecution;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public PurgeExecution() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The deleted files")
        private final List<URI> uris;

        @ConstructorProperties(value={"uris"})
        @Generated
        Output(List<URI> uris) {
            this.uris = uris;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<URI> getUris() {
            return this.uris;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<URI> uris;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uris(List<URI> uris) {
                this.uris = uris;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uris);
            }

            @Generated
            public String toString() {
                return "PurgeExecution.Output.OutputBuilder(uris=" + this.uris + ")";
            }
        }
    }

    @Generated
    private static final class PurgeExecutionBuilderImpl
    extends PurgeExecutionBuilder<PurgeExecution, PurgeExecutionBuilderImpl> {
        @Generated
        private PurgeExecutionBuilderImpl() {
        }

        @Override
        @Generated
        protected PurgeExecutionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PurgeExecution build() {
            return new PurgeExecution(this);
        }
    }

    @Generated
    public static abstract class PurgeExecutionBuilder<C extends PurgeExecution, B extends PurgeExecutionBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PurgeExecution.PurgeExecutionBuilder(super=" + super.toString() + ")";
        }
    }
}

