/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.storages;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import lombok.Generated;

@Schema(title="Get a filesize from internal storage.")
@Plugin(examples={@Example(code={"uri: \"kestra://long/url/file.txt\""})})
public class Size
extends Task
implements RunnableTask<Output> {
    @Schema(title="the file", description="Must be a `kestra://` storage url")
    @PluginProperty(dynamic=true)
    private String uri;

    @Override
    public Output run(RunContext runContext) throws Exception {
        StorageInterface storageInterface = (StorageInterface)runContext.getApplicationContext().getBean(StorageInterface.class);
        URI render = URI.create(runContext.render(this.uri));
        Long size = storageInterface.size(render);
        return Output.builder().size(size).build();
    }

    @Generated
    protected Size(SizeBuilder<?, ?> b) {
        super(b);
        this.uri = b.uri;
    }

    @Generated
    public static SizeBuilder<?, ?> builder() {
        return new SizeBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Size(super=" + super.toString() + ", uri=" + this.getUri() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Size)) {
            return false;
        }
        Size other = (Size)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        return !(this$uri == null ? other$uri != null : !this$uri.equals(other$uri));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Size;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        return result;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public Size() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The size of the file ")
        private final Long size;

        @ConstructorProperties(value={"size"})
        @Generated
        Output(Long size) {
            this.size = size;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Long getSize() {
            return this.size;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Long size;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder size(Long size) {
                this.size = size;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.size);
            }

            @Generated
            public String toString() {
                return "Size.Output.OutputBuilder(size=" + this.size + ")";
            }
        }
    }

    @Generated
    public static abstract class SizeBuilder<C extends Size, B extends SizeBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String uri;

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B uri(String uri) {
            this.uri = uri;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Size.SizeBuilder(super=" + super.toString() + ", uri=" + this.uri + ")";
        }
    }

    @Generated
    private static final class SizeBuilderImpl
    extends SizeBuilder<Size, SizeBuilderImpl> {
        @Generated
        private SizeBuilderImpl() {
        }

        @Override
        @Generated
        protected SizeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Size build() {
            return new Size(this);
        }
    }
}

