/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Debug {
    private static final String NAME = Thread.currentThread().getStackTrace()[2].getClassName();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)NAME);
    private static ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);

    private static String caller() {
        return Thread.currentThread().getStackTrace()[3].getClassName() + " -> " + Thread.currentThread().getStackTrace()[3].getMethodName() + " # " + Thread.currentThread().getStackTrace()[3].getLineNumber();
    }

    public static <T> String toJson(T arg) {
        String output;
        if (arg instanceof String) {
            output = (String)arg;
        } else if (arg instanceof byte[]) {
            output = new String((byte[])arg);
        } else {
            try {
                output = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(arg);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return output;
    }

    @SafeVarargs
    public static <T> void log(T ... args) {
        LOGGER.trace("\u001b[44;30m " + Debug.caller() + " \u001b[0m");
        for (T arg : args) {
            LOGGER.trace("\u001b[46;30m " + arg.getClass().getName() + " \u001b[0m " + Debug.toJson(arg));
        }
    }
}

