/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import com.google.common.base.CaseFormat;
import io.kestra.core.docs.DocumentationGenerator;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.plugins.RegisteredPlugin;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;

public class ClassPluginDocumentation<T> {
    private Boolean deprecated;
    private String cls;
    private String icon;
    private String group;
    private String subGroup;
    private String shortName;
    private String docDescription;
    private String docBody;
    private List<ExampleDoc> docExamples;
    private List<MetricDoc> docMetrics;
    private Map<String, Object> defs = new TreeMap<String, Object>();
    private Map<String, Object> inputs = new TreeMap<String, Object>();
    private Map<String, Object> outputs = new TreeMap<String, Object>();
    private Map<String, Object> propertiesSchema;
    private Map<String, Object> outputsSchema;

    private ClassPluginDocumentation(JsonSchemaGenerator jsonSchemaGenerator, RegisteredPlugin plugin, Class<? extends T> cls, Class<T> baseCls) {
        this.cls = cls.getName();
        this.group = plugin.group();
        this.icon = DocumentationGenerator.icon(plugin, cls);
        if (this.group != null && cls.getPackageName().startsWith(this.group) && cls.getPackageName().length() > this.group.length()) {
            this.subGroup = cls.getPackageName().substring(this.group.length() + 1);
        }
        this.shortName = cls.getSimpleName();
        this.propertiesSchema = jsonSchemaGenerator.properties(baseCls, cls);
        this.outputsSchema = jsonSchemaGenerator.outputs(baseCls, cls);
        if (this.propertiesSchema.containsKey("$defs")) {
            this.defs.putAll((Map)this.propertiesSchema.get("$defs"));
            this.propertiesSchema.remove("$defs");
        }
        if (this.outputsSchema.containsKey("$defs")) {
            this.defs.putAll((Map)this.outputsSchema.get("$defs"));
            this.outputsSchema.remove("$defs");
        }
        this.defs = this.getDefs().entrySet().stream().map(entry -> {
            Map value = (Map)entry.getValue();
            value.put("properties", ClassPluginDocumentation.flatten(ClassPluginDocumentation.properties(value), ClassPluginDocumentation.required(value)));
            return new AbstractMap.SimpleEntry<String, Map>((String)entry.getKey(), value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.docDescription = this.propertiesSchema.containsKey("title") ? (String)this.propertiesSchema.get("title") : null;
        this.docBody = this.propertiesSchema.containsKey("description") ? (String)this.propertiesSchema.get("description") : null;
        this.deprecated = this.propertiesSchema.containsKey("$deprecated");
        if (this.propertiesSchema.containsKey("$examples")) {
            List examples = (List)this.propertiesSchema.get("$examples");
            this.docExamples = examples.stream().map(r -> new ExampleDoc((String)r.get("title"), String.join((CharSequence)"\n", (CharSequence[])ArrayUtils.addAll((Object[])((Boolean)r.get("full") != false ? new ArrayList() : Arrays.asList("id: \"" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, cls.getSimpleName()) + "\"", "type: \"" + cls.getName() + "\"")).toArray(new String[0]), (Object[])new String[]{(String)r.get("code")})))).collect(Collectors.toList());
        }
        if (this.propertiesSchema.containsKey("$metrics")) {
            List metrics = (List)this.propertiesSchema.get("$metrics");
            this.docMetrics = metrics.stream().map(r -> new MetricDoc((String)r.get("name"), (String)r.get("type"), (String)r.get("unit"), (String)r.get("description"))).collect(Collectors.toList());
        }
        if (this.propertiesSchema.containsKey("properties")) {
            this.inputs = ClassPluginDocumentation.flatten(ClassPluginDocumentation.properties(this.propertiesSchema), ClassPluginDocumentation.required(this.propertiesSchema));
        }
        if (this.outputsSchema.containsKey("properties")) {
            this.outputs = ClassPluginDocumentation.flatten(ClassPluginDocumentation.properties(this.outputsSchema), ClassPluginDocumentation.required(this.outputsSchema));
        }
    }

    private static Map<String, Object> flatten(Map<String, Object> map, List<String> required) {
        map.remove("type");
        return ClassPluginDocumentation.flatten(map, required, null);
    }

    private static Map<String, Object> flatten(Map<String, Object> map, List<String> required, String parentName) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> current : map.entrySet()) {
            Map value;
            Map finalValue = (Map)current.getValue();
            if (required.contains(current.getKey())) {
                finalValue.put("$required", true);
            }
            result.put(ClassPluginDocumentation.flattenKey(current.getKey(), parentName), finalValue);
            if (!(current.getValue() instanceof Map) || !(value = (Map)current.getValue()).containsKey("properties")) continue;
            result.putAll(ClassPluginDocumentation.flatten(ClassPluginDocumentation.properties(value), ClassPluginDocumentation.required(value), current.getKey()));
        }
        return result;
    }

    private static String flattenKey(String current, String parent) {
        return (String)(parent != null ? parent + "." : "") + current;
    }

    private static Map<String, Object> properties(Map<String, Object> props) {
        Map properties = (Map)props.get("properties");
        return properties != null ? properties : new HashMap();
    }

    private static List<String> required(Map<String, Object> props) {
        if (!props.containsKey("required")) {
            return Collections.emptyList();
        }
        return (List)props.get("required");
    }

    public static <T> ClassPluginDocumentation<T> of(JsonSchemaGenerator jsonSchemaGenerator, RegisteredPlugin plugin, Class<? extends T> cls, Class<T> baseCls) {
        return new ClassPluginDocumentation<T>(jsonSchemaGenerator, plugin, cls, baseCls);
    }

    @ConstructorProperties(value={"deprecated", "cls", "icon", "group", "subGroup", "shortName", "docDescription", "docBody", "docExamples", "docMetrics", "defs", "inputs", "outputs", "propertiesSchema", "outputsSchema"})
    @Generated
    public ClassPluginDocumentation(Boolean deprecated, String cls, String icon, String group, String subGroup, String shortName, String docDescription, String docBody, List<ExampleDoc> docExamples, List<MetricDoc> docMetrics, Map<String, Object> defs, Map<String, Object> inputs, Map<String, Object> outputs, Map<String, Object> propertiesSchema, Map<String, Object> outputsSchema) {
        this.deprecated = deprecated;
        this.cls = cls;
        this.icon = icon;
        this.group = group;
        this.subGroup = subGroup;
        this.shortName = shortName;
        this.docDescription = docDescription;
        this.docBody = docBody;
        this.docExamples = docExamples;
        this.docMetrics = docMetrics;
        this.defs = defs;
        this.inputs = inputs;
        this.outputs = outputs;
        this.propertiesSchema = propertiesSchema;
        this.outputsSchema = outputsSchema;
    }

    @Generated
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Generated
    public String getCls() {
        return this.cls;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getSubGroup() {
        return this.subGroup;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public String getDocDescription() {
        return this.docDescription;
    }

    @Generated
    public String getDocBody() {
        return this.docBody;
    }

    @Generated
    public List<ExampleDoc> getDocExamples() {
        return this.docExamples;
    }

    @Generated
    public List<MetricDoc> getDocMetrics() {
        return this.docMetrics;
    }

    @Generated
    public Map<String, Object> getDefs() {
        return this.defs;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Map<String, Object> getPropertiesSchema() {
        return this.propertiesSchema;
    }

    @Generated
    public Map<String, Object> getOutputsSchema() {
        return this.outputsSchema;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassPluginDocumentation)) {
            return false;
        }
        ClassPluginDocumentation other = (ClassPluginDocumentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$deprecated = this.getDeprecated();
        Boolean other$deprecated = other.getDeprecated();
        if (this$deprecated == null ? other$deprecated != null : !((Object)this$deprecated).equals(other$deprecated)) {
            return false;
        }
        String this$cls = this.getCls();
        String other$cls = other.getCls();
        if (this$cls == null ? other$cls != null : !this$cls.equals(other$cls)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$subGroup = this.getSubGroup();
        String other$subGroup = other.getSubGroup();
        if (this$subGroup == null ? other$subGroup != null : !this$subGroup.equals(other$subGroup)) {
            return false;
        }
        String this$shortName = this.getShortName();
        String other$shortName = other.getShortName();
        if (this$shortName == null ? other$shortName != null : !this$shortName.equals(other$shortName)) {
            return false;
        }
        String this$docDescription = this.getDocDescription();
        String other$docDescription = other.getDocDescription();
        if (this$docDescription == null ? other$docDescription != null : !this$docDescription.equals(other$docDescription)) {
            return false;
        }
        String this$docBody = this.getDocBody();
        String other$docBody = other.getDocBody();
        if (this$docBody == null ? other$docBody != null : !this$docBody.equals(other$docBody)) {
            return false;
        }
        List<ExampleDoc> this$docExamples = this.getDocExamples();
        List<ExampleDoc> other$docExamples = other.getDocExamples();
        if (this$docExamples == null ? other$docExamples != null : !((Object)this$docExamples).equals(other$docExamples)) {
            return false;
        }
        List<MetricDoc> this$docMetrics = this.getDocMetrics();
        List<MetricDoc> other$docMetrics = other.getDocMetrics();
        if (this$docMetrics == null ? other$docMetrics != null : !((Object)this$docMetrics).equals(other$docMetrics)) {
            return false;
        }
        Map<String, Object> this$defs = this.getDefs();
        Map<String, Object> other$defs = other.getDefs();
        if (this$defs == null ? other$defs != null : !((Object)this$defs).equals(other$defs)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, Object> this$outputs = this.getOutputs();
        Map<String, Object> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Map<String, Object> this$propertiesSchema = this.getPropertiesSchema();
        Map<String, Object> other$propertiesSchema = other.getPropertiesSchema();
        if (this$propertiesSchema == null ? other$propertiesSchema != null : !((Object)this$propertiesSchema).equals(other$propertiesSchema)) {
            return false;
        }
        Map<String, Object> this$outputsSchema = this.getOutputsSchema();
        Map<String, Object> other$outputsSchema = other.getOutputsSchema();
        return !(this$outputsSchema == null ? other$outputsSchema != null : !((Object)this$outputsSchema).equals(other$outputsSchema));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassPluginDocumentation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $deprecated = this.getDeprecated();
        result = result * 59 + ($deprecated == null ? 43 : ((Object)$deprecated).hashCode());
        String $cls = this.getCls();
        result = result * 59 + ($cls == null ? 43 : $cls.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $subGroup = this.getSubGroup();
        result = result * 59 + ($subGroup == null ? 43 : $subGroup.hashCode());
        String $shortName = this.getShortName();
        result = result * 59 + ($shortName == null ? 43 : $shortName.hashCode());
        String $docDescription = this.getDocDescription();
        result = result * 59 + ($docDescription == null ? 43 : $docDescription.hashCode());
        String $docBody = this.getDocBody();
        result = result * 59 + ($docBody == null ? 43 : $docBody.hashCode());
        List<ExampleDoc> $docExamples = this.getDocExamples();
        result = result * 59 + ($docExamples == null ? 43 : ((Object)$docExamples).hashCode());
        List<MetricDoc> $docMetrics = this.getDocMetrics();
        result = result * 59 + ($docMetrics == null ? 43 : ((Object)$docMetrics).hashCode());
        Map<String, Object> $defs = this.getDefs();
        result = result * 59 + ($defs == null ? 43 : ((Object)$defs).hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, Object> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Map<String, Object> $propertiesSchema = this.getPropertiesSchema();
        result = result * 59 + ($propertiesSchema == null ? 43 : ((Object)$propertiesSchema).hashCode());
        Map<String, Object> $outputsSchema = this.getOutputsSchema();
        result = result * 59 + ($outputsSchema == null ? 43 : ((Object)$outputsSchema).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClassPluginDocumentation(deprecated=" + this.getDeprecated() + ", cls=" + this.getCls() + ", icon=" + this.getIcon() + ", group=" + this.getGroup() + ", subGroup=" + this.getSubGroup() + ", shortName=" + this.getShortName() + ", docDescription=" + this.getDocDescription() + ", docBody=" + this.getDocBody() + ", docExamples=" + this.getDocExamples() + ", docMetrics=" + this.getDocMetrics() + ", defs=" + this.getDefs() + ", inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", propertiesSchema=" + this.getPropertiesSchema() + ", outputsSchema=" + this.getOutputsSchema() + ")";
    }

    @Generated
    public ClassPluginDocumentation() {
    }

    public static class MetricDoc {
        String name;
        String type;
        String unit;
        String description;

        @ConstructorProperties(value={"name", "type", "unit", "description"})
        @Generated
        public MetricDoc(String name, String type, String unit, String description) {
            this.name = name;
            this.type = type;
            this.unit = unit;
            this.description = description;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }

    public static class ExampleDoc {
        String title;
        String task;

        @ConstructorProperties(value={"title", "task"})
        @Generated
        public ExampleDoc(String title, String task) {
            this.title = title;
            this.task = task;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getTask() {
            return this.task;
        }
    }
}

