/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.docs.DocumentationGenerator;
import io.kestra.core.models.annotations.PluginSubGroup;
import io.kestra.core.plugins.RegisteredPlugin;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class PluginDocumentation {
    private String title;
    private String group;
    private String icon;
    private Map<SubGroup, Map<String, List<ClassPlugin>>> classPlugins;
    private Map<String, String> guides;

    private PluginDocumentation(RegisteredPlugin plugin) {
        this.title = plugin.title();
        this.group = plugin.group();
        this.icon = DocumentationGenerator.icon(plugin, "plugin-icon");
        this.classPlugins = plugin.allClassGrouped().entrySet().stream().filter(r -> !((String)r.getKey()).equals("controllers") && !((String)r.getKey()).equals("storages")).flatMap(entry -> ((List)entry.getValue()).stream().map(cls -> {
            ClassPlugin.ClassPluginBuilder builder = ClassPlugin.builder().name(cls.getName()).simpleName(cls.getSimpleName()).type((String)entry.getKey());
            if (cls.getPackageName().startsWith(this.group)) {
                PluginSubGroup pluginSubGroup = cls.getPackage().getDeclaredAnnotation(PluginSubGroup.class);
                String subGroupName = cls.getPackageName().length() > this.group.length() ? cls.getPackageName().substring(this.group.length() + 1) : "";
                String subGroupTitle = pluginSubGroup != null ? pluginSubGroup.title() : subGroupName;
                String subGroupDescription = pluginSubGroup != null ? pluginSubGroup.description() : null;
                boolean subgroupIsGroup = cls.getPackageName().length() <= this.group.length();
                String subGroupIcon = DocumentationGenerator.icon(plugin, cls.getPackageName());
                SubGroup subgroup = new SubGroup(subGroupName, subGroupTitle, subGroupDescription, subGroupIcon, subgroupIsGroup);
                builder.subgroup(subgroup);
            } else {
                builder.subgroup(new SubGroup(""));
            }
            return builder.build();
        })).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(ClassPlugin::getSubgroup).thenComparing(ClassPlugin::getType).thenComparing(ClassPlugin::getName)).collect(Collectors.groupingBy(ClassPlugin::getSubgroup, Collectors.groupingBy(ClassPlugin::getType)));
    }

    public static PluginDocumentation of(RegisteredPlugin plugin) {
        return new PluginDocumentation(plugin);
    }

    @ConstructorProperties(value={"title", "group", "icon", "classPlugins", "guides"})
    @Generated
    public PluginDocumentation(String title, String group, String icon, Map<SubGroup, Map<String, List<ClassPlugin>>> classPlugins, Map<String, String> guides) {
        this.title = title;
        this.group = group;
        this.icon = icon;
        this.classPlugins = classPlugins;
        this.guides = guides;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public Map<SubGroup, Map<String, List<ClassPlugin>>> getClassPlugins() {
        return this.classPlugins;
    }

    @Generated
    public Map<String, String> getGuides() {
        return this.guides;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDocumentation)) {
            return false;
        }
        PluginDocumentation other = (PluginDocumentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        Map<SubGroup, Map<String, List<ClassPlugin>>> this$classPlugins = this.getClassPlugins();
        Map<SubGroup, Map<String, List<ClassPlugin>>> other$classPlugins = other.getClassPlugins();
        if (this$classPlugins == null ? other$classPlugins != null : !((Object)this$classPlugins).equals(other$classPlugins)) {
            return false;
        }
        Map<String, String> this$guides = this.getGuides();
        Map<String, String> other$guides = other.getGuides();
        return !(this$guides == null ? other$guides != null : !((Object)this$guides).equals(other$guides));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PluginDocumentation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        Map<SubGroup, Map<String, List<ClassPlugin>>> $classPlugins = this.getClassPlugins();
        result = result * 59 + ($classPlugins == null ? 43 : ((Object)$classPlugins).hashCode());
        Map<String, String> $guides = this.getGuides();
        result = result * 59 + ($guides == null ? 43 : ((Object)$guides).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PluginDocumentation(title=" + this.getTitle() + ", group=" + this.getGroup() + ", icon=" + this.getIcon() + ", classPlugins=" + this.getClassPlugins() + ", guides=" + this.getGuides() + ")";
    }

    @Generated
    public PluginDocumentation() {
    }

    public static class ClassPlugin {
        String name;
        String simpleName;
        SubGroup subgroup;
        String group;
        String type;

        @Generated
        public static ClassPluginBuilder builder() {
            return new ClassPluginBuilder();
        }

        @ConstructorProperties(value={"name", "simpleName", "subgroup", "group", "type"})
        @Generated
        public ClassPlugin(String name, String simpleName, SubGroup subgroup, String group, String type) {
            this.name = name;
            this.simpleName = simpleName;
            this.subgroup = subgroup;
            this.group = group;
            this.type = type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getSimpleName() {
            return this.simpleName;
        }

        @Generated
        public SubGroup getSubgroup() {
            return this.subgroup;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public static class ClassPluginBuilder {
            @Generated
            private String name;
            @Generated
            private String simpleName;
            @Generated
            private SubGroup subgroup;
            @Generated
            private String group;
            @Generated
            private String type;

            @Generated
            ClassPluginBuilder() {
            }

            @Generated
            public ClassPluginBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public ClassPluginBuilder simpleName(String simpleName) {
                this.simpleName = simpleName;
                return this;
            }

            @Generated
            public ClassPluginBuilder subgroup(SubGroup subgroup) {
                this.subgroup = subgroup;
                return this;
            }

            @Generated
            public ClassPluginBuilder group(String group) {
                this.group = group;
                return this;
            }

            @Generated
            public ClassPluginBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public ClassPlugin build() {
                return new ClassPlugin(this.name, this.simpleName, this.subgroup, this.group, this.type);
            }

            @Generated
            public String toString() {
                return "PluginDocumentation.ClassPlugin.ClassPluginBuilder(name=" + this.name + ", simpleName=" + this.simpleName + ", subgroup=" + this.subgroup + ", group=" + this.group + ", type=" + this.type + ")";
            }
        }
    }

    public static class SubGroup
    implements Comparable<SubGroup> {
        String name;
        String title;
        String description;
        String icon;
        boolean subgroupIsGroup;

        SubGroup(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(SubGroup o) {
            return this.name.compareTo(o.getName());
        }

        @ConstructorProperties(value={"name", "title", "description", "icon", "subgroupIsGroup"})
        @Generated
        public SubGroup(String name, String title, String description, String icon, boolean subgroupIsGroup) {
            this.name = name;
            this.title = title;
            this.description = description;
            this.icon = icon;
            this.subgroupIsGroup = subgroupIsGroup;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getIcon() {
            return this.icon;
        }

        @Generated
        public boolean isSubgroupIsGroup() {
            return this.subgroupIsGroup;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubGroup)) {
                return false;
            }
            SubGroup other = (SubGroup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubGroup;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

