/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Condition for a flow namespace")
@Plugin(examples={@Example(full=true, code={"- conditions:", "    - type: io.kestra.core.models.conditions.types.FlowNamespaceCondition", "      namespace: io.kestra.tests", "      prefix: true"})})
public class FlowNamespaceCondition
extends Condition {
    @NotNull
    @Schema(title="The namespace of the flow or the prefix if `prefix` is true")
    @PluginProperty
    private String namespace;
    @Schema(title="If we must look at the flow namespace by prefix (simple startWith case sensitive)")
    @PluginProperty
    private final Boolean prefix;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        if (!this.prefix.booleanValue() && conditionContext.getFlow().getNamespace().equals(this.namespace)) {
            return true;
        }
        return this.prefix != false && conditionContext.getFlow().getNamespace().startsWith(this.namespace);
    }

    @Generated
    private static Boolean $default$prefix() {
        return false;
    }

    @Generated
    protected FlowNamespaceCondition(FlowNamespaceConditionBuilder<?, ?> b) {
        super((Condition.ConditionBuilder)b);
        this.namespace = b.namespace;
        this.prefix = b.prefix$set ? b.prefix$value : FlowNamespaceCondition.$default$prefix();
    }

    @Generated
    public static FlowNamespaceConditionBuilder<?, ?> builder() {
        return new FlowNamespaceConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "FlowNamespaceCondition(super=" + super.toString() + ", namespace=" + this.getNamespace() + ", prefix=" + this.getPrefix() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowNamespaceCondition)) {
            return false;
        }
        FlowNamespaceCondition other = (FlowNamespaceCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$prefix = this.getPrefix();
        Boolean other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !((Object)this$prefix).equals(other$prefix)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowNamespaceCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : ((Object)$prefix).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        return result;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public Boolean getPrefix() {
        return this.prefix;
    }

    @Generated
    public FlowNamespaceCondition() {
        this.prefix = FlowNamespaceCondition.$default$prefix();
    }

    @Generated
    public static abstract class FlowNamespaceConditionBuilder<C extends FlowNamespaceCondition, B extends FlowNamespaceConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private String namespace;
        @Generated
        private boolean prefix$set;
        @Generated
        private Boolean prefix$value;

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B prefix(Boolean prefix) {
            this.prefix$value = prefix;
            this.prefix$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FlowNamespaceCondition.FlowNamespaceConditionBuilder(super=" + super.toString() + ", namespace=" + this.namespace + ", prefix$value=" + this.prefix$value + ")";
        }
    }

    @Generated
    private static final class FlowNamespaceConditionBuilderImpl
    extends FlowNamespaceConditionBuilder<FlowNamespaceCondition, FlowNamespaceConditionBuilderImpl> {
        @Generated
        private FlowNamespaceConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowNamespaceConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowNamespaceCondition build() {
            return new FlowNamespaceCondition(this);
        }
    }
}

