/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.conditions.types;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Condition for a list of flow", description="Trigger the first time all the flow are successfully executed during the `window` duration ")
@Plugin(examples={@Example(full=true, title="A flow that is waiting for 2 flows that is successful in 1 days", code={"triggers:", "  - id: multiple-listen-flow", "    type: io.kestra.core.models.triggers.types.Flow", "    conditions:", "      - id: multiple", "        type: io.kestra.core.models.conditions.types.MultipleCondition", "        window: P1D", "        windowAdvance: P0D", "        conditions:", "          success:", "            type: io.kestra.core.models.conditions.types.ExecutionStatusCondition", "            in:", "              - SUCCESS", "          flow-a:", "            type: io.kestra.core.models.conditions.types.ExecutionFlowCondition", "            namespace: io.kestra.tests", "            flowId: trigger-multiplecondition-flow-a", "          flow-b:", "            type: io.kestra.core.models.conditions.types.ExecutionFlowCondition", "            namespace: io.kestra.tests", "            flowId: trigger-multiplecondition-flow-b"})})
public class MultipleCondition
extends Condition {
    @NotNull
    @NotBlank
    @Pattern(regexp="[a-zA-Z0-9_-]+")
    @Schema(title="A unique id for the whole flow")
    @PluginProperty
    protected @NotNull @NotBlank @Pattern(regexp="[a-zA-Z0-9_-]+") String id;
    @NotNull
    @Schema(title="The duration of the window", description="See [ISO_8601 Durations](https://en.wikipedia.org/wiki/ISO_8601#Durations) for more information of available duration value.\nThe start of the window is always based on midnight except if you set windowAdvance parameter. Eg if you have a 10 minutes (PT10M) window, the first window will be 00:00 to 00:10 and a new window will be started each 10 minutes")
    @PluginProperty
    private Duration window;
    @NotNull
    @Schema(title="The window advance duration", description="Allow to specify the start hour of the window\nEg: you want a window of 6 hours (window=PT6H). By default the check will be done between: \n00:00 and 06:00 - 06:00 and 12:00 - 12:00 and 18:00 - 18:00 and 00:00 If you want to check the window between: \n03:00 and 09:00 - 09:00 and 15:00 - 15:00 and 21:00 - 21:00 and 3:00You will have to shift the window of 3 hours by settings windowAdvance: PT3H")
    @PluginProperty
    private Duration windowAdvance;
    @NotNull
    @NotEmpty
    @Schema(title="The list of conditions to wait for", description="The key must be unique for a trigger since it will be use to store previous result.")
    @PluginProperty(additionalProperties=Condition.class)
    private Map<String, Condition> conditions;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        boolean result;
        Logger logger = conditionContext.getRunContext().logger();
        MultipleConditionStorageInterface multipleConditionStorage = conditionContext.getMultipleConditionStorage();
        Objects.requireNonNull(multipleConditionStorage);
        Optional<MultipleConditionWindow> triggerExecutionWindow = multipleConditionStorage.get(conditionContext.getFlow(), this.getId());
        Map<String, Boolean> results = this.conditions.keySet().stream().map(condition -> new AbstractMap.SimpleEntry<String, Boolean>((String)condition, triggerExecutionWindow.isPresent() && ((MultipleConditionWindow)triggerExecutionWindow.get()).getResults() != null && ((MultipleConditionWindow)triggerExecutionWindow.get()).getResults().containsKey(condition) && ((MultipleConditionWindow)triggerExecutionWindow.get()).getResults().get(condition) != false)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        long validatedCount = results.entrySet().stream().filter(Map.Entry::getValue).count();
        boolean bl = result = (long)this.conditions.size() == validatedCount;
        if (result && logger.isDebugEnabled()) {
            logger.debug("[namespace: {}] [flow: {}] Multiple conditions validated !", (Object)conditionContext.getFlow().getNamespace(), (Object)conditionContext.getFlow().getId());
        } else if (logger.isTraceEnabled()) {
            logger.trace("[namespace: {}] [flow: {}] Multiple conditions failed ({}/{}) with '{}'", new Object[]{conditionContext.getFlow().getNamespace(), conditionContext.getFlow().getId(), validatedCount, this.conditions.size(), results});
        }
        return result;
    }

    @Generated
    protected MultipleCondition(MultipleConditionBuilder<?, ?> b) {
        super((Condition.ConditionBuilder)b);
        this.id = b.id;
        this.window = b.window;
        this.windowAdvance = b.windowAdvance;
        this.conditions = b.conditions;
    }

    @Generated
    public static MultipleConditionBuilder<?, ?> builder() {
        return new MultipleConditionBuilderImpl();
    }

    @Generated
    public String toString() {
        return "MultipleCondition(super=" + super.toString() + ", id=" + this.getId() + ", window=" + this.getWindow() + ", windowAdvance=" + this.getWindowAdvance() + ", conditions=" + this.getConditions() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleCondition)) {
            return false;
        }
        MultipleCondition other = (MultipleCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Duration this$window = this.getWindow();
        Duration other$window = other.getWindow();
        if (this$window == null ? other$window != null : !((Object)this$window).equals(other$window)) {
            return false;
        }
        Duration this$windowAdvance = this.getWindowAdvance();
        Duration other$windowAdvance = other.getWindowAdvance();
        if (this$windowAdvance == null ? other$windowAdvance != null : !((Object)this$windowAdvance).equals(other$windowAdvance)) {
            return false;
        }
        Map<String, Condition> this$conditions = this.getConditions();
        Map<String, Condition> other$conditions = other.getConditions();
        return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultipleCondition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Duration $window = this.getWindow();
        result = result * 59 + ($window == null ? 43 : ((Object)$window).hashCode());
        Duration $windowAdvance = this.getWindowAdvance();
        result = result * 59 + ($windowAdvance == null ? 43 : ((Object)$windowAdvance).hashCode());
        Map<String, Condition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        return result;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Duration getWindow() {
        return this.window;
    }

    @Generated
    public Duration getWindowAdvance() {
        return this.windowAdvance;
    }

    @Generated
    public Map<String, Condition> getConditions() {
        return this.conditions;
    }

    @Generated
    public MultipleCondition() {
    }

    @Generated
    public static abstract class MultipleConditionBuilder<C extends MultipleCondition, B extends MultipleConditionBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private String id;
        @Generated
        private Duration window;
        @Generated
        private Duration windowAdvance;
        @Generated
        private Map<String, Condition> conditions;

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B window(Duration window) {
            this.window = window;
            return (B)this.self();
        }

        @Generated
        public B windowAdvance(Duration windowAdvance) {
            this.windowAdvance = windowAdvance;
            return (B)this.self();
        }

        @Generated
        public B conditions(Map<String, Condition> conditions) {
            this.conditions = conditions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "MultipleCondition.MultipleConditionBuilder(super=" + super.toString() + ", id=" + this.id + ", window=" + this.window + ", windowAdvance=" + this.windowAdvance + ", conditions=" + this.conditions + ")";
        }
    }

    @Generated
    private static final class MultipleConditionBuilderImpl
    extends MultipleConditionBuilder<MultipleCondition, MultipleConditionBuilderImpl> {
        @Generated
        private MultipleConditionBuilderImpl() {
        }

        @Override
        @Generated
        protected MultipleConditionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MultipleCondition build() {
            return new MultipleCondition(this);
        }
    }
}

