/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.utils.MapUtils;
import io.micronaut.core.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Execution
implements DeletedInterface {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Execution.class);
    @NotNull
    private final String id;
    @NotNull
    private final String namespace;
    @NotNull
    private final String flowId;
    @NotNull
    private final Integer flowRevision;
    private final List<TaskRun> taskRunList;
    private final Map<String, Object> inputs;
    private final Map<String, Object> variables;
    @NotNull
    private final State state;
    private final String parentId;
    private final String originalId;
    private final ExecutionTrigger trigger;
    @NotNull
    private final boolean deleted;

    public static ExecutionBuilder builder() {
        return new CustomExecutionBuilder();
    }

    public Execution withState(State.Type state) {
        return new Execution(this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.variables, this.state.withState(state), this.parentId, this.originalId, this.trigger, this.deleted);
    }

    public Execution withTaskRun(TaskRun taskRun) throws InternalException {
        ArrayList<TaskRun> newTaskRunList = new ArrayList<TaskRun>(this.taskRunList);
        boolean b = Collections.replaceAll(newTaskRunList, this.findTaskRunByTaskRunId(taskRun.getId()), taskRun);
        if (!b) {
            throw new IllegalStateException("Can't replace taskRun '" + taskRun.getId() + "' on execution'" + this.getId() + "'");
        }
        return new Execution(this.id, this.namespace, this.flowId, this.flowRevision, newTaskRunList, this.inputs, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted);
    }

    public Execution childExecution(String childExecutionId, List<TaskRun> taskRunList, State state) {
        return new Execution(childExecutionId != null ? childExecutionId : this.getId(), this.namespace, this.flowId, this.flowRevision, taskRunList, this.inputs, this.variables, state, childExecutionId != null ? this.getId() : null, this.originalId, this.trigger, this.deleted);
    }

    public List<TaskRun> findTaskRunsByTaskId(String id) {
        if (this.taskRunList == null) {
            return new ArrayList<TaskRun>();
        }
        return this.taskRunList.stream().filter(taskRun -> taskRun.getTaskId().equals(id)).collect(Collectors.toList());
    }

    public TaskRun findTaskRunByTaskRunId(String id) throws InternalException {
        Optional<TaskRun> find = (this.taskRunList == null ? new ArrayList() : this.taskRunList).stream().filter(taskRun -> taskRun.getId().equals(id)).findFirst();
        if (find.isEmpty()) {
            throw new InternalException("Can't find taskrun with taskrunId '" + id + "' on execution '" + this.id + "' " + this.toStringState());
        }
        return find.get();
    }

    public TaskRun findTaskRunByTaskIdAndValue(String id, List<String> values) throws InternalException {
        Optional<TaskRun> find = (this.taskRunList == null ? new ArrayList() : this.taskRunList).stream().filter(taskRun -> taskRun.getTaskId().equals(id) && this.findChildsValues((TaskRun)taskRun, true).equals(values)).findFirst();
        if (find.isEmpty()) {
            throw new InternalException("Can't find taskrun with taskrunId '" + id + "' & value '" + values + "' on execution '" + this.id + "' " + this.toStringState());
        }
        return find.get();
    }

    public List<ResolvedTask> findTaskDependingFlowState(List<ResolvedTask> resolvedTasks, List<ResolvedTask> resolvedErrors) {
        return this.findTaskDependingFlowState(resolvedTasks, resolvedErrors, null);
    }

    public List<ResolvedTask> findTaskDependingFlowState(List<ResolvedTask> resolvedTasks, @Nullable List<ResolvedTask> resolvedErrors, TaskRun parentTaskRun) {
        resolvedTasks = this.removeDisabled(resolvedTasks);
        List<TaskRun> errorsFlow = this.findTaskRunByTasks(resolvedErrors = this.removeDisabled(resolvedErrors), parentTaskRun);
        if (errorsFlow.size() > 0 || this.hasFailed(resolvedTasks, parentTaskRun)) {
            return resolvedErrors == null ? new ArrayList() : resolvedErrors;
        }
        return resolvedTasks;
    }

    public List<ResolvedTask> findTaskDependingFlowState(List<ResolvedTask> resolvedTasks) {
        resolvedTasks = this.removeDisabled(resolvedTasks);
        return resolvedTasks;
    }

    private List<ResolvedTask> removeDisabled(List<ResolvedTask> tasks) {
        if (tasks == null) {
            return null;
        }
        return tasks.stream().filter(resolvedTask -> resolvedTask.getTask().getDisabled() == false).collect(Collectors.toList());
    }

    public List<TaskRun> findTaskRunByTasks(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        if (resolvedTasks == null || this.taskRunList == null) {
            return new ArrayList<TaskRun>();
        }
        return this.getTaskRunList().stream().filter(t -> resolvedTasks.stream().anyMatch(resolvedTask -> FlowableUtils.isTaskRunFor(resolvedTask, t, parentTaskRun))).collect(Collectors.toList());
    }

    public Optional<TaskRun> findFirstByState(State.Type state) {
        if (this.taskRunList == null) {
            return Optional.empty();
        }
        return this.taskRunList.stream().filter(t -> t.getState().getCurrent() == state).findFirst();
    }

    public Optional<TaskRun> findFirstRunning() {
        if (this.taskRunList == null) {
            return Optional.empty();
        }
        return this.taskRunList.stream().filter(t -> t.getState().isRunning()).findFirst();
    }

    public Optional<TaskRun> findLastNotTerminated() {
        if (this.taskRunList == null) {
            return Optional.empty();
        }
        return Streams.findLast(this.taskRunList.stream().filter(t -> !t.getState().isTerminated() || !t.getState().isPaused()));
    }

    public Optional<TaskRun> findLastByState(List<ResolvedTask> resolvedTasks, State.Type state, TaskRun taskRun) {
        return Streams.findLast(this.findTaskRunByTasks(resolvedTasks, taskRun).stream().filter(t -> t.getState().getCurrent() == state));
    }

    public Optional<TaskRun> findLastCreated(List<ResolvedTask> resolvedTasks, TaskRun taskRun) {
        return Streams.findLast(this.findTaskRunByTasks(resolvedTasks, taskRun).stream().filter(t -> t.getState().isCreated()));
    }

    public Optional<TaskRun> findLastRunning(List<ResolvedTask> resolvedTasks, TaskRun taskRun) {
        return Streams.findLast(this.findTaskRunByTasks(resolvedTasks, taskRun).stream().filter(t -> t.getState().isRunning()));
    }

    public Optional<TaskRun> findLastTerminated(List<ResolvedTask> resolvedTasks, TaskRun taskRun) {
        List<TaskRun> taskRuns = this.findTaskRunByTasks(resolvedTasks, taskRun);
        ArrayList<TaskRun> reverse = new ArrayList<TaskRun>(taskRuns);
        Collections.reverse(reverse);
        return Streams.findLast(this.findTaskRunByTasks(resolvedTasks, taskRun).stream().filter(t -> t.getState().isTerminated()));
    }

    public boolean isTerminated(List<ResolvedTask> resolvedTasks) {
        return this.isTerminated(resolvedTasks, null);
    }

    public boolean isTerminated(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        long terminatedCount = this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().filter(taskRun -> taskRun.getState().isTerminated()).count();
        return terminatedCount == (long)resolvedTasks.size();
    }

    public boolean hasWarning() {
        return this.taskRunList != null && this.taskRunList.stream().anyMatch(taskRun -> taskRun.getState().getCurrent() == State.Type.WARNING);
    }

    public boolean hasWarning(List<ResolvedTask> resolvedTasks) {
        return this.hasWarning(resolvedTasks, null);
    }

    public boolean hasWarning(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> taskRun.getState().getCurrent() == State.Type.WARNING);
    }

    public boolean hasFailed() {
        return this.taskRunList != null && this.taskRunList.stream().anyMatch(taskRun -> taskRun.getState().isFailed());
    }

    public boolean hasFailed(List<ResolvedTask> resolvedTasks) {
        return this.hasFailed(resolvedTasks, null);
    }

    public boolean hasFailed(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> taskRun.getState().isFailed());
    }

    public boolean hasCreated() {
        return this.taskRunList != null && this.taskRunList.stream().anyMatch(taskRun -> taskRun.getState().isCreated());
    }

    public boolean hasCreated(List<ResolvedTask> resolvedTasks) {
        return this.hasCreated(resolvedTasks, null);
    }

    public boolean hasCreated(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> taskRun.getState().isCreated());
    }

    public boolean hasRunning(List<ResolvedTask> resolvedTasks) {
        return this.hasRunning(resolvedTasks, null);
    }

    public boolean hasRunning(List<ResolvedTask> resolvedTasks, TaskRun parentTaskRun) {
        return this.findTaskRunByTasks(resolvedTasks, parentTaskRun).stream().anyMatch(taskRun -> taskRun.getState().isRunning());
    }

    public State.Type guessFinalState(Flow flow) {
        return this.guessFinalState(ResolvedTask.of(flow.getTasks()), null);
    }

    public State.Type guessFinalState(List<ResolvedTask> currentTasks, TaskRun parentTaskRun) {
        return this.findLastByState(currentTasks, State.Type.KILLED, parentTaskRun).map(taskRun -> taskRun.getState().getCurrent()).or(() -> this.findLastByState(currentTasks, State.Type.FAILED, parentTaskRun).map(taskRun -> taskRun.getState().getCurrent())).or(() -> this.findLastByState(currentTasks, State.Type.WARNING, parentTaskRun).map(taskRun -> taskRun.getState().getCurrent())).or(() -> this.findLastByState(currentTasks, State.Type.PAUSED, parentTaskRun).map(taskRun -> taskRun.getState().getCurrent())).orElse(State.Type.SUCCESS);
    }

    @JsonIgnore
    public boolean hasTaskRunJoinable(TaskRun taskRun) {
        if (this.taskRunList == null) {
            return true;
        }
        TaskRun current = this.taskRunList.stream().filter(r -> r.isSame(taskRun)).findFirst().orElse(null);
        if (current == null) {
            return true;
        }
        if (current.getAttempts() == null && taskRun.getAttempts() != null || current.getAttempts() != null && taskRun.getAttempts() != null && current.getAttempts().size() < taskRun.getAttempts().size()) {
            return true;
        }
        if (current.getState().getCurrent() == taskRun.getState().getCurrent()) {
            return false;
        }
        if (current.getState().isTerminated() && !taskRun.getState().isTerminated()) {
            return false;
        }
        return current.getState().getHistories().size() <= taskRun.getState().getHistories().size();
    }

    public FailedExecutionWithLog failedExecutionFromExecutor(Exception e) {
        if (log.isWarnEnabled()) {
            log.warn("[namespace: {}] [flow: {}] [execution: {}] Flow failed from executor in {} with exception '{}'", new Object[]{this.getNamespace(), this.getFlowId(), this.getId(), this.getState().humanDuration(), e.getMessage(), e});
        }
        return this.findLastNotTerminated().map(taskRun -> {
            TaskRunAttempt lastAttempt = taskRun.lastAttempt();
            if (lastAttempt == null) {
                return Execution.newAttemptsTaskRunForFailedExecution(taskRun, e);
            }
            return Execution.lastAttemptsTaskRunForFailedExecution(taskRun, lastAttempt, e);
        }).map(t -> {
            try {
                return new FailedExecutionWithLog(this.withTaskRun(t.getTaskRun()), t.getLogs());
            }
            catch (InternalException ex) {
                return null;
            }
        }).filter(Objects::nonNull).orElseGet(() -> new FailedExecutionWithLog(this.state.getCurrent() != State.Type.FAILED ? this.withState(State.Type.FAILED) : this, RunContextLogger.logEntries(Execution.loggingEventFromException(e), LogEntry.of(this))));
    }

    private static FailedTaskRunWithLog newAttemptsTaskRunForFailedExecution(TaskRun taskRun, Exception e) {
        return new FailedTaskRunWithLog(taskRun.withAttempts(Collections.singletonList(TaskRunAttempt.builder().state(new State()).build().withState(State.Type.FAILED))).withState(State.Type.FAILED), RunContextLogger.logEntries(Execution.loggingEventFromException(e), LogEntry.of(taskRun)));
    }

    private static FailedTaskRunWithLog lastAttemptsTaskRunForFailedExecution(TaskRun taskRun, TaskRunAttempt lastAttempt, Exception e) {
        return new FailedTaskRunWithLog(taskRun.withAttempts(Stream.concat(taskRun.getAttempts().stream().limit(taskRun.getAttempts().size() - 1), Stream.of(lastAttempt.withState(State.Type.FAILED))).collect(Collectors.toList())).withState(State.Type.FAILED), RunContextLogger.logEntries(Execution.loggingEventFromException(e), LogEntry.of(taskRun)));
    }

    public static ILoggingEvent loggingEventFromException(Exception e) {
        LoggingEvent loggingEvent = new LoggingEvent();
        loggingEvent.setLevel(Level.ERROR);
        loggingEvent.setThrowableProxy(new ThrowableProxy((Throwable)e));
        loggingEvent.setMessage(e.getMessage());
        loggingEvent.setThreadName(Thread.currentThread().getName());
        loggingEvent.setTimeStamp(Instant.now().toEpochMilli());
        loggingEvent.setLoggerName(Execution.class.getName());
        return loggingEvent;
    }

    public Map<String, Object> outputs() {
        if (this.taskRunList == null) {
            return ImmutableMap.of();
        }
        Map<String, Object> result = new HashMap<String, Object>();
        for (TaskRun current : this.taskRunList) {
            if (current.getOutputs() == null) continue;
            result = MapUtils.merge(result, this.outputs(current));
        }
        return result;
    }

    private Map<String, Object> outputs(TaskRun taskRun) {
        HashMap<String, Object> result;
        List childs = this.findChilds(taskRun).stream().filter(r -> r.getValue() != null).collect(Collectors.toList());
        if (childs.size() == 0) {
            if (taskRun.getValue() == null) {
                return Map.of(taskRun.getTaskId(), taskRun.getOutputs());
            }
            return Map.of(taskRun.getTaskId(), Map.of(taskRun.getValue(), taskRun.getOutputs()));
        }
        HashMap<String, Object> current = result = new HashMap<String, Object>();
        for (TaskRun t : childs) {
            if (t.getValue() == null) continue;
            HashMap item = new HashMap();
            current.put(t.getValue(), item);
            current = item;
        }
        if (taskRun.getOutputs() != null) {
            if (taskRun.getValue() != null) {
                current.put(taskRun.getValue(), taskRun.getOutputs());
            } else {
                current.putAll(taskRun.getOutputs());
            }
        }
        return Map.of(taskRun.getTaskId(), result);
    }

    public List<Map<String, Object>> parents(TaskRun taskRun) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<TaskRun> childs = this.findChilds(taskRun);
        Collections.reverse(childs);
        for (TaskRun childTaskRun : childs) {
            HashMap<String, Map<String, Object>> current = new HashMap<String, Map<String, Object>>();
            if (childTaskRun.getValue() != null) {
                current.put("taskrun", Map.of("value", childTaskRun.getValue()));
            }
            if (childTaskRun.getOutputs() != null) {
                current.put("outputs", childTaskRun.getOutputs());
            }
            if (current.size() <= 0) continue;
            result.add(current);
        }
        return result;
    }

    public List<TaskRun> findChilds(TaskRun taskRun) {
        if (taskRun.getParentTaskRunId() == null) {
            return new ArrayList<TaskRun>();
        }
        ArrayList<TaskRun> result = new ArrayList<TaskRun>();
        boolean ended = false;
        while (!ended) {
            TaskRun finalTaskRun = taskRun;
            Optional<TaskRun> find = this.taskRunList.stream().filter(t -> t.getId().equals(finalTaskRun.getParentTaskRunId())).findFirst();
            if (find.isPresent()) {
                result.add(find.get());
                taskRun = find.get();
                continue;
            }
            ended = true;
        }
        Collections.reverse(result);
        return result;
    }

    public List<String> findChildsValues(TaskRun taskRun, boolean withCurrent) {
        return (withCurrent ? Stream.concat(this.findChilds(taskRun).stream(), Stream.of(taskRun)) : this.findChilds(taskRun).stream()).filter(t -> t.getValue() != null).map(TaskRun::getValue).collect(Collectors.toList());
    }

    public Execution toDeleted() {
        return this.toBuilder().deleted(true).build();
    }

    public String toString(boolean pretty) {
        if (!pretty) {
            return super.toString();
        }
        return "Execution(\n  id=" + this.getId() + "\n  flowId=" + this.getFlowId() + "\n  state=" + this.getState().getCurrent().toString() + "\n  taskRunList=\n  [\n    " + (this.taskRunList == null ? "" : this.taskRunList.stream().map(t -> t.toString(true)).collect(Collectors.joining(",\n    "))) + "\n  ], \n  inputs=" + this.getInputs() + "\n)";
    }

    public String toStringState() {
        return "(\n  state=" + this.getState().getCurrent().toString() + "\n  taskRunList=\n  [\n    " + (this.taskRunList == null ? "" : this.taskRunList.stream().map(TaskRun::toStringState).collect(Collectors.joining(",\n    "))) + "\n  ] \n)";
    }

    public Long toCrc32State() {
        CRC32 crc32 = new CRC32();
        crc32.update(this.toStringState().getBytes());
        return crc32.getValue();
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @ConstructorProperties(value={"id", "namespace", "flowId", "flowRevision", "taskRunList", "inputs", "variables", "state", "parentId", "originalId", "trigger", "deleted"})
    @Generated
    Execution(String id, String namespace, String flowId, Integer flowRevision, List<TaskRun> taskRunList, Map<String, Object> inputs, Map<String, Object> variables, State state, String parentId, String originalId, ExecutionTrigger trigger, boolean deleted) {
        this.id = id;
        this.namespace = namespace;
        this.flowId = flowId;
        this.flowRevision = flowRevision;
        this.taskRunList = taskRunList;
        this.inputs = inputs;
        this.variables = variables;
        this.state = state;
        this.parentId = parentId;
        this.originalId = originalId;
        this.trigger = trigger;
        this.deleted = deleted;
    }

    @Generated
    public ExecutionBuilder toBuilder() {
        return new ExecutionBuilder().id(this.id).namespace(this.namespace).flowId(this.flowId).flowRevision(this.flowRevision).taskRunList(this.taskRunList).inputs(this.inputs).variables(this.variables).state(this.state).parentId(this.parentId).originalId(this.originalId).trigger(this.trigger).deleted(this.deleted);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public Integer getFlowRevision() {
        return this.flowRevision;
    }

    @Generated
    public List<TaskRun> getTaskRunList() {
        return this.taskRunList;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public String getOriginalId() {
        return this.originalId;
    }

    @Generated
    public ExecutionTrigger getTrigger() {
        return this.trigger;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Execution)) {
            return false;
        }
        Execution other = (Execution)o;
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Integer this$flowRevision = this.getFlowRevision();
        Integer other$flowRevision = other.getFlowRevision();
        if (this$flowRevision == null ? other$flowRevision != null : !((Object)this$flowRevision).equals(other$flowRevision)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        List<TaskRun> this$taskRunList = this.getTaskRunList();
        List<TaskRun> other$taskRunList = other.getTaskRunList();
        if (this$taskRunList == null ? other$taskRunList != null : !((Object)this$taskRunList).equals(other$taskRunList)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, Object> this$variables = this.getVariables();
        Map<String, Object> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$originalId = this.getOriginalId();
        String other$originalId = other.getOriginalId();
        if (this$originalId == null ? other$originalId != null : !this$originalId.equals(other$originalId)) {
            return false;
        }
        ExecutionTrigger this$trigger = this.getTrigger();
        ExecutionTrigger other$trigger = other.getTrigger();
        return !(this$trigger == null ? other$trigger != null : !((Object)this$trigger).equals(other$trigger));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Integer $flowRevision = this.getFlowRevision();
        result = result * 59 + ($flowRevision == null ? 43 : ((Object)$flowRevision).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        List<TaskRun> $taskRunList = this.getTaskRunList();
        result = result * 59 + ($taskRunList == null ? 43 : ((Object)$taskRunList).hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, Object> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $originalId = this.getOriginalId();
        result = result * 59 + ($originalId == null ? 43 : $originalId.hashCode());
        ExecutionTrigger $trigger = this.getTrigger();
        result = result * 59 + ($trigger == null ? 43 : ((Object)$trigger).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Execution(id=" + this.getId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", flowRevision=" + this.getFlowRevision() + ", taskRunList=" + this.getTaskRunList() + ", inputs=" + this.getInputs() + ", variables=" + this.getVariables() + ", state=" + this.getState() + ", parentId=" + this.getParentId() + ", originalId=" + this.getOriginalId() + ", trigger=" + this.getTrigger() + ", deleted=" + this.isDeleted() + ")";
    }

    @Generated
    public Execution withFlowRevision(Integer flowRevision) {
        return this.flowRevision == flowRevision ? this : new Execution(this.id, this.namespace, this.flowId, flowRevision, this.taskRunList, this.inputs, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted);
    }

    @Generated
    public Execution withTaskRunList(List<TaskRun> taskRunList) {
        return this.taskRunList == taskRunList ? this : new Execution(this.id, this.namespace, this.flowId, this.flowRevision, taskRunList, this.inputs, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted);
    }

    @Generated
    public Execution withInputs(Map<String, Object> inputs) {
        return this.inputs == inputs ? this : new Execution(this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, inputs, this.variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted);
    }

    @Generated
    public Execution withVariables(Map<String, Object> variables) {
        return this.variables == variables ? this : new Execution(this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, variables, this.state, this.parentId, this.originalId, this.trigger, this.deleted);
    }

    @Generated
    public Execution withTrigger(ExecutionTrigger trigger) {
        return this.trigger == trigger ? this : new Execution(this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.variables, this.state, this.parentId, this.originalId, trigger, this.deleted);
    }

    private static class CustomExecutionBuilder
    extends ExecutionBuilder {
        private CustomExecutionBuilder() {
        }

        @Override
        public Execution build() {
            this.prebuild();
            return super.build();
        }
    }

    public static final class FailedExecutionWithLog {
        private final Execution execution;
        private final List<LogEntry> logs;

        @ConstructorProperties(value={"execution", "logs"})
        @Generated
        FailedExecutionWithLog(Execution execution, List<LogEntry> logs) {
            this.execution = execution;
            this.logs = logs;
        }

        @Generated
        public static FailedExecutionWithLogBuilder builder() {
            return new FailedExecutionWithLogBuilder();
        }

        @Generated
        public Execution getExecution() {
            return this.execution;
        }

        @Generated
        public List<LogEntry> getLogs() {
            return this.logs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedExecutionWithLog)) {
                return false;
            }
            FailedExecutionWithLog other = (FailedExecutionWithLog)o;
            Execution this$execution = this.getExecution();
            Execution other$execution = other.getExecution();
            if (this$execution == null ? other$execution != null : !((Object)this$execution).equals(other$execution)) {
                return false;
            }
            List<LogEntry> this$logs = this.getLogs();
            List<LogEntry> other$logs = other.getLogs();
            return !(this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Execution $execution = this.getExecution();
            result = result * 59 + ($execution == null ? 43 : ((Object)$execution).hashCode());
            List<LogEntry> $logs = this.getLogs();
            result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Execution.FailedExecutionWithLog(execution=" + this.getExecution() + ", logs=" + this.getLogs() + ")";
        }

        @Generated
        public static class FailedExecutionWithLogBuilder {
            @Generated
            private Execution execution;
            @Generated
            private List<LogEntry> logs;

            @Generated
            FailedExecutionWithLogBuilder() {
            }

            @Generated
            public FailedExecutionWithLogBuilder execution(Execution execution) {
                this.execution = execution;
                return this;
            }

            @Generated
            public FailedExecutionWithLogBuilder logs(List<LogEntry> logs) {
                this.logs = logs;
                return this;
            }

            @Generated
            public FailedExecutionWithLog build() {
                return new FailedExecutionWithLog(this.execution, this.logs);
            }

            @Generated
            public String toString() {
                return "Execution.FailedExecutionWithLog.FailedExecutionWithLogBuilder(execution=" + this.execution + ", logs=" + this.logs + ")";
            }
        }
    }

    public static final class FailedTaskRunWithLog {
        private final TaskRun taskRun;
        private final List<LogEntry> logs;

        @ConstructorProperties(value={"taskRun", "logs"})
        @Generated
        public FailedTaskRunWithLog(TaskRun taskRun, List<LogEntry> logs) {
            this.taskRun = taskRun;
            this.logs = logs;
        }

        @Generated
        public TaskRun getTaskRun() {
            return this.taskRun;
        }

        @Generated
        public List<LogEntry> getLogs() {
            return this.logs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedTaskRunWithLog)) {
                return false;
            }
            FailedTaskRunWithLog other = (FailedTaskRunWithLog)o;
            TaskRun this$taskRun = this.getTaskRun();
            TaskRun other$taskRun = other.getTaskRun();
            if (this$taskRun == null ? other$taskRun != null : !((Object)this$taskRun).equals(other$taskRun)) {
                return false;
            }
            List<LogEntry> this$logs = this.getLogs();
            List<LogEntry> other$logs = other.getLogs();
            return !(this$logs == null ? other$logs != null : !((Object)this$logs).equals(other$logs));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskRun $taskRun = this.getTaskRun();
            result = result * 59 + ($taskRun == null ? 43 : ((Object)$taskRun).hashCode());
            List<LogEntry> $logs = this.getLogs();
            result = result * 59 + ($logs == null ? 43 : ((Object)$logs).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Execution.FailedTaskRunWithLog(taskRun=" + this.getTaskRun() + ", logs=" + this.getLogs() + ")";
        }
    }

    public static class ExecutionBuilder {
        @Generated
        private String id;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Integer flowRevision;
        @Generated
        private List<TaskRun> taskRunList;
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private Map<String, Object> variables;
        @Generated
        private State state;
        @Generated
        private String parentId;
        @Generated
        private String originalId;
        @Generated
        private ExecutionTrigger trigger;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;

        void prebuild() {
            this.originalId = this.id;
        }

        @Generated
        ExecutionBuilder() {
        }

        @Generated
        public ExecutionBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ExecutionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public ExecutionBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public ExecutionBuilder flowRevision(Integer flowRevision) {
            this.flowRevision = flowRevision;
            return this;
        }

        @Generated
        public ExecutionBuilder taskRunList(List<TaskRun> taskRunList) {
            this.taskRunList = taskRunList;
            return this;
        }

        @Generated
        public ExecutionBuilder inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return this;
        }

        @Generated
        public ExecutionBuilder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        @Generated
        public ExecutionBuilder state(State state) {
            this.state = state;
            return this;
        }

        @Generated
        public ExecutionBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        @Generated
        public ExecutionBuilder originalId(String originalId) {
            this.originalId = originalId;
            return this;
        }

        @Generated
        public ExecutionBuilder trigger(ExecutionTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        @Generated
        public ExecutionBuilder deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this;
        }

        @Generated
        public Execution build() {
            boolean deleted$value = this.deleted$value;
            if (!this.deleted$set) {
                deleted$value = Execution.$default$deleted();
            }
            return new Execution(this.id, this.namespace, this.flowId, this.flowRevision, this.taskRunList, this.inputs, this.variables, this.state, this.parentId, this.originalId, this.trigger, deleted$value);
        }

        @Generated
        public String toString() {
            return "Execution.ExecutionBuilder(id=" + this.id + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", flowRevision=" + this.flowRevision + ", taskRunList=" + this.taskRunList + ", inputs=" + this.inputs + ", variables=" + this.variables + ", state=" + this.state + ", parentId=" + this.parentId + ", originalId=" + this.originalId + ", trigger=" + this.trigger + ", deleted$value=" + this.deleted$value + ")";
        }
    }
}

