/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.hierarchies;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.Relation;
import io.kestra.core.services.GraphService;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class FlowGraph {
    private final List<AbstractGraph> nodes;
    private final List<Edge> edges;
    private final List<Cluster> clusters;
    private final List<String> flowables;

    public static FlowGraph of(Flow flow) throws IllegalVariableEvaluationException {
        return FlowGraph.of(flow, null);
    }

    public static FlowGraph of(Flow flow, Execution execution) throws IllegalVariableEvaluationException {
        GraphCluster graph = GraphService.of(flow, execution);
        return FlowGraph.builder().flowables(GraphService.flowables(flow)).nodes(GraphService.nodes(graph)).edges(GraphService.edges(graph)).clusters(GraphService.clusters(graph, new ArrayList<String>()).stream().map(g -> new Cluster((AbstractGraph)g.getKey(), ((GraphCluster)g.getKey()).getGraph().nodes().stream().map(AbstractGraph::getUid).collect(Collectors.toList()), (List)g.getValue(), ((GraphCluster)g.getKey()).getRoot().getUid(), ((GraphCluster)g.getKey()).getEnd().getUid())).collect(Collectors.toList())).build();
    }

    @ConstructorProperties(value={"nodes", "edges", "clusters", "flowables"})
    @Generated
    FlowGraph(List<AbstractGraph> nodes, List<Edge> edges, List<Cluster> clusters, List<String> flowables) {
        this.nodes = nodes;
        this.edges = edges;
        this.clusters = clusters;
        this.flowables = flowables;
    }

    @Generated
    public static FlowGraphBuilder builder() {
        return new FlowGraphBuilder();
    }

    @Generated
    public List<AbstractGraph> getNodes() {
        return this.nodes;
    }

    @Generated
    public List<Edge> getEdges() {
        return this.edges;
    }

    @Generated
    public List<Cluster> getClusters() {
        return this.clusters;
    }

    @Generated
    public List<String> getFlowables() {
        return this.flowables;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowGraph)) {
            return false;
        }
        FlowGraph other = (FlowGraph)o;
        List<AbstractGraph> this$nodes = this.getNodes();
        List<AbstractGraph> other$nodes = other.getNodes();
        if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
            return false;
        }
        List<Edge> this$edges = this.getEdges();
        List<Edge> other$edges = other.getEdges();
        if (this$edges == null ? other$edges != null : !((Object)this$edges).equals(other$edges)) {
            return false;
        }
        List<Cluster> this$clusters = this.getClusters();
        List<Cluster> other$clusters = other.getClusters();
        if (this$clusters == null ? other$clusters != null : !((Object)this$clusters).equals(other$clusters)) {
            return false;
        }
        List<String> this$flowables = this.getFlowables();
        List<String> other$flowables = other.getFlowables();
        return !(this$flowables == null ? other$flowables != null : !((Object)this$flowables).equals(other$flowables));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AbstractGraph> $nodes = this.getNodes();
        result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
        List<Edge> $edges = this.getEdges();
        result = result * 59 + ($edges == null ? 43 : ((Object)$edges).hashCode());
        List<Cluster> $clusters = this.getClusters();
        result = result * 59 + ($clusters == null ? 43 : ((Object)$clusters).hashCode());
        List<String> $flowables = this.getFlowables();
        result = result * 59 + ($flowables == null ? 43 : ((Object)$flowables).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FlowGraph(nodes=" + this.getNodes() + ", edges=" + this.getEdges() + ", clusters=" + this.getClusters() + ", flowables=" + this.getFlowables() + ")";
    }

    @Generated
    public static class FlowGraphBuilder {
        @Generated
        private List<AbstractGraph> nodes;
        @Generated
        private List<Edge> edges;
        @Generated
        private List<Cluster> clusters;
        @Generated
        private List<String> flowables;

        @Generated
        FlowGraphBuilder() {
        }

        @Generated
        public FlowGraphBuilder nodes(List<AbstractGraph> nodes) {
            this.nodes = nodes;
            return this;
        }

        @Generated
        public FlowGraphBuilder edges(List<Edge> edges) {
            this.edges = edges;
            return this;
        }

        @Generated
        public FlowGraphBuilder clusters(List<Cluster> clusters) {
            this.clusters = clusters;
            return this;
        }

        @Generated
        public FlowGraphBuilder flowables(List<String> flowables) {
            this.flowables = flowables;
            return this;
        }

        @Generated
        public FlowGraph build() {
            return new FlowGraph(this.nodes, this.edges, this.clusters, this.flowables);
        }

        @Generated
        public String toString() {
            return "FlowGraph.FlowGraphBuilder(nodes=" + this.nodes + ", edges=" + this.edges + ", clusters=" + this.clusters + ", flowables=" + this.flowables + ")";
        }
    }

    public static class Cluster {
        private final AbstractGraph cluster;
        private final List<String> nodes;
        private final List<String> parents;
        private final String start;
        private final String end;

        @Generated
        public AbstractGraph getCluster() {
            return this.cluster;
        }

        @Generated
        public List<String> getNodes() {
            return this.nodes;
        }

        @Generated
        public List<String> getParents() {
            return this.parents;
        }

        @Generated
        public String getStart() {
            return this.start;
        }

        @Generated
        public String getEnd() {
            return this.end;
        }

        @ConstructorProperties(value={"cluster", "nodes", "parents", "start", "end"})
        @Generated
        public Cluster(AbstractGraph cluster, List<String> nodes, List<String> parents, String start, String end) {
            this.cluster = cluster;
            this.nodes = nodes;
            this.parents = parents;
            this.start = start;
            this.end = end;
        }

        @Generated
        public String toString() {
            return "FlowGraph.Cluster(cluster=" + this.getCluster() + ", nodes=" + this.getNodes() + ", parents=" + this.getParents() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cluster)) {
                return false;
            }
            Cluster other = (Cluster)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AbstractGraph this$cluster = this.getCluster();
            AbstractGraph other$cluster = other.getCluster();
            if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
                return false;
            }
            List<String> this$nodes = this.getNodes();
            List<String> other$nodes = other.getNodes();
            if (this$nodes == null ? other$nodes != null : !((Object)this$nodes).equals(other$nodes)) {
                return false;
            }
            List<String> this$parents = this.getParents();
            List<String> other$parents = other.getParents();
            if (this$parents == null ? other$parents != null : !((Object)this$parents).equals(other$parents)) {
                return false;
            }
            String this$start = this.getStart();
            String other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            String this$end = this.getEnd();
            String other$end = other.getEnd();
            return !(this$end == null ? other$end != null : !this$end.equals(other$end));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cluster;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AbstractGraph $cluster = this.getCluster();
            result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
            List<String> $nodes = this.getNodes();
            result = result * 59 + ($nodes == null ? 43 : ((Object)$nodes).hashCode());
            List<String> $parents = this.getParents();
            result = result * 59 + ($parents == null ? 43 : ((Object)$parents).hashCode());
            String $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            String $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : $end.hashCode());
            return result;
        }
    }

    public static class Edge {
        private final String source;
        private final String target;
        private final Relation relation;

        @Generated
        public String getSource() {
            return this.source;
        }

        @Generated
        public String getTarget() {
            return this.target;
        }

        @Generated
        public Relation getRelation() {
            return this.relation;
        }

        @ConstructorProperties(value={"source", "target", "relation"})
        @Generated
        public Edge(String source, String target, Relation relation) {
            this.source = source;
            this.target = target;
            this.relation = relation;
        }

        @Generated
        public String toString() {
            return "FlowGraph.Edge(source=" + this.getSource() + ", target=" + this.getTarget() + ", relation=" + this.getRelation() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            Relation this$relation = this.getRelation();
            Relation other$relation = other.getRelation();
            return !(this$relation == null ? other$relation != null : !((Object)this$relation).equals(other$relation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Edge;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            Relation $relation = this.getRelation();
            result = result * 59 + ($relation == null ? 43 : ((Object)$relation).hashCode());
            return result;
        }
    }
}

