/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers.multipleflows;

import io.kestra.core.models.conditions.types.MultipleCondition;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public interface MultipleConditionStorageInterface {
    public Optional<MultipleConditionWindow> get(Flow var1, String var2);

    public List<MultipleConditionWindow> expired();

    default public MultipleConditionWindow getOrCreate(Flow flow, MultipleCondition multipleCondition) {
        ZonedDateTime now = ZonedDateTime.now().withNano(0);
        if (multipleCondition.getWindow().toDays() > 0L) {
            now = now.withHour(0);
        }
        if (multipleCondition.getWindow().toHours() > 0L) {
            now = now.withMinute(0);
        }
        if (multipleCondition.getWindow().toMinutes() > 0L) {
            now = now.withSecond(0).withMinute(0).plusMinutes(multipleCondition.getWindow().toMinutes() * ((long)now.getMinute() / multipleCondition.getWindow().toMinutes()));
        }
        ZonedDateTime start = now.plus(multipleCondition.getWindowAdvance()).truncatedTo(ChronoUnit.MILLIS);
        ZonedDateTime end = start.plus(multipleCondition.getWindow()).minus(Duration.ofMillis(1L)).truncatedTo(ChronoUnit.MILLIS);
        return this.get(flow, multipleCondition.getId()).filter(m -> m.isValid(ZonedDateTime.now())).orElseGet(() -> MultipleConditionWindow.builder().namespace(flow.getNamespace()).flowId(flow.getId()).conditionId(multipleCondition.getId()).start(start).end(end).results(new HashMap<String, Boolean>()).build());
    }
}

