/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.ExternalPlugin;
import io.kestra.core.plugins.PluginClassLoader;
import io.kestra.core.plugins.PluginResolver;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.storages.StorageInterface;
import io.micronaut.core.beans.BeanIntrospectionReference;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.http.annotation.Controller;
import io.swagger.v3.oas.annotations.Hidden;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginScanner.class);
    ClassLoader parent;

    public PluginScanner(ClassLoader parent) {
        this.parent = parent;
    }

    public List<RegisteredPlugin> scan(Path pluginPaths) {
        return new PluginResolver(pluginPaths).resolves().stream().map(plugin -> {
            log.debug("Loading plugins from path: {}", (Object)plugin.getLocation());
            PluginClassLoader classLoader = PluginClassLoader.of(plugin.getLocation(), plugin.getResources(), this.parent);
            log.debug("Scanning plugins from paths '{}' with classLoader '{}'", (Object)Arrays.stream(plugin.getResources()).map(URL::getPath).collect(Collectors.joining("", "\n\t", "")), (Object)classLoader);
            return this.scanClassLoader(classLoader, (ExternalPlugin)plugin, null);
        }).filter(RegisteredPlugin::isValid).collect(Collectors.toList());
    }

    public RegisteredPlugin scan() {
        try {
            Manifest manifest = new Manifest(IOUtils.toInputStream((String)"Manifest-Version: 1.0\nX-Kestra-Title: core\nX-Kestra-Group: io.kestra.core.tasks\n", (Charset)StandardCharsets.UTF_8));
            return this.scanClassLoader(PluginScanner.class.getClassLoader(), null, manifest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RegisteredPlugin scanClassLoader(ClassLoader classLoader, ExternalPlugin externalPlugin, Manifest manifest) {
        ArrayList<Class<? extends Task>> tasks = new ArrayList<Class<? extends Task>>();
        ArrayList<Class<? extends AbstractTrigger>> triggers = new ArrayList<Class<? extends AbstractTrigger>>();
        ArrayList<Class<? extends Condition>> conditions = new ArrayList<Class<? extends Condition>>();
        ArrayList<Class<? extends StorageInterface>> storages = new ArrayList<Class<? extends StorageInterface>>();
        ArrayList controllers = new ArrayList();
        ArrayList<String> guides = new ArrayList<String>();
        SoftServiceLoader loader = SoftServiceLoader.load(BeanIntrospectionReference.class, (ClassLoader)classLoader);
        if (manifest == null) {
            manifest = PluginScanner.getManifest(classLoader);
        }
        ArrayList definitions = new ArrayList(100);
        loader.collectAll(definitions);
        for (BeanIntrospectionReference definition : definitions) {
            Class beanType = definition.getBeanType();
            if (Modifier.isAbstract(beanType.getModifiers()) || beanType.isAnnotationPresent(Hidden.class)) continue;
            if (Task.class.isAssignableFrom(beanType)) {
                tasks.add(beanType);
            }
            if (AbstractTrigger.class.isAssignableFrom(beanType)) {
                triggers.add(beanType);
            }
            if (Condition.class.isAssignableFrom(beanType)) {
                conditions.add(beanType);
            }
            if (StorageInterface.class.isAssignableFrom(beanType)) {
                storages.add(beanType);
            }
            if (!beanType.isAnnotationPresent(Controller.class)) continue;
            controllers.add(beanType);
        }
        URL guidesDirectory = classLoader.getResource("doc/guides");
        if (guidesDirectory != null) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(guidesDirectory.toURI(), Collections.emptyMap());){
                Path root = fileSystem.getPath("/doc/guides", new String[0]);
                try (Stream<Path> stream = Files.walk(root, 1, new FileVisitOption[0]);){
                    stream.skip(1L).forEach(guide -> {
                        String guideName = guide.getName(guide.getParent().getNameCount()).toString();
                        guides.add(guideName.substring(0, guideName.lastIndexOf(46)));
                    });
                }
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return RegisteredPlugin.builder().externalPlugin(externalPlugin).manifest(manifest).classLoader(classLoader).tasks(tasks).triggers(triggers).conditions(conditions).controllers(controllers).storages(storages).guides(guides).build();
    }

    public static Manifest getManifest(ClassLoader classLoader) {
        try {
            URL url = classLoader.getResource("META-INF/MANIFEST.MF");
            if (url != null) {
                return new Manifest(url.openStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

