/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.ExecutionDelay;
import io.kestra.core.runners.Executor;
import io.kestra.core.runners.FlowExecutorInterface;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskExecution;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.services.ConditionService;
import io.kestra.core.tasks.flows.Pause;
import io.kestra.core.tasks.flows.Worker;
import io.kestra.core.utils.Rethrow;
import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExecutorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutorService.class);
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    protected RunContextFactory runContextFactory;
    @Inject
    protected MetricRegistry metricRegistry;
    @Inject
    protected ConditionService conditionService;
    protected FlowExecutorInterface flowExecutorInterface;

    protected FlowExecutorInterface flowExecutorInterface() {
        if (this.flowExecutorInterface == null) {
            this.flowExecutorInterface = (FlowExecutorInterface)this.applicationContext.getBean(FlowExecutorInterface.class);
        }
        return this.flowExecutorInterface;
    }

    public Executor process(Executor executor) {
        if (!executor.canBeProcessed().booleanValue()) {
            return executor;
        }
        try {
            executor = this.handleRestart(executor);
            executor = this.handleEnd(executor);
            executor = this.handleKilling(executor);
            if (executor.getExecution().getState().getCurrent() != State.Type.KILLING && executor.getExecution().getState().getCurrent() != State.Type.KILLED) {
                executor = this.handleNext(executor);
                executor = this.handleChildNext(executor);
            }
            executor = this.handleListeners(executor);
            executor = this.handleWorkerTask(executor);
            executor = this.handleChildWorkerCreatedKilling(executor);
            executor = this.handleChildWorkerTaskResult(executor);
            executor = this.handleFlowTask(executor);
        }
        catch (Exception e) {
            return executor.withException(e, "process");
        }
        return executor;
    }

    public Execution onNexts(Flow flow, Execution execution, List<TaskRun> nexts) {
        List<TaskRun> executionTasksRun;
        if (log.isTraceEnabled()) {
            log.trace("[namespace: {}] [flow: {}] [execution: {}] Found {} next(s) {}", new Object[]{execution.getNamespace(), execution.getFlowId(), execution.getId(), nexts.size(), nexts});
        }
        if (execution.getTaskRunList() == null) {
            executionTasksRun = nexts;
        } else {
            executionTasksRun = new ArrayList<TaskRun>(execution.getTaskRunList());
            executionTasksRun.addAll(nexts);
        }
        Execution newExecution = execution.withTaskRunList(executionTasksRun);
        if (execution.getState().getCurrent() == State.Type.CREATED) {
            this.metricRegistry.counter("executor.execution.started.count", this.metricRegistry.tags(execution)).increment();
            flow.logger().info("[namespace: {}] [flow: {}] [execution: {}] Flow started", new Object[]{execution.getNamespace(), execution.getFlowId(), execution.getId()});
            newExecution = newExecution.withState(State.Type.RUNNING);
        }
        this.metricRegistry.counter("executor.taskrun.next.count", this.metricRegistry.tags(execution)).increment((double)nexts.size());
        return newExecution;
    }

    private Optional<WorkerTaskResult> childWorkerTaskResult(Flow flow, Execution execution, TaskRun parentTaskRun) throws InternalException {
        Task parent = flow.findTaskByTaskId(parentTaskRun.getTaskId());
        if (parent instanceof FlowableTask) {
            FlowableTask flowableParent = (FlowableTask)((Object)parent);
            RunContext runContext = this.runContextFactory.of(flow, parent, execution, parentTaskRun);
            Optional<WorkerTaskResult> endedTask = this.childWorkerTaskTypeToWorkerTask(flowableParent.resolveState(runContext, execution, parentTaskRun), parent, parentTaskRun);
            if (endedTask.isPresent()) {
                return endedTask;
            }
            if (execution.getState().getCurrent() == State.Type.KILLING) {
                if (parentTaskRun.getState().getCurrent() != State.Type.KILLING) {
                    return this.childWorkerTaskTypeToWorkerTask(Optional.of(State.Type.KILLING), parent, parentTaskRun);
                }
                List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(flowableParent.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(flowableParent.getErrors(), parentTaskRun));
                List<TaskRun> taskRunByTasks = execution.findTaskRunByTasks(currentTasks, parentTaskRun);
                if (taskRunByTasks.stream().filter(t -> t.getState().isTerminated()).count() == (long)taskRunByTasks.size()) {
                    return this.childWorkerTaskTypeToWorkerTask(Optional.of(State.Type.KILLED), parent, parentTaskRun);
                }
            }
        }
        return Optional.empty();
    }

    private Optional<WorkerTaskResult> childWorkerTaskTypeToWorkerTask(Optional<State.Type> findState, Task task, TaskRun taskRun) {
        return findState.map(Rethrow.throwFunction(type -> new WorkerTaskResult(taskRun.withState((State.Type)((Object)type))))).stream().peek(workerTaskResult -> this.metricRegistry.counter("executor.workertaskresult.count", this.metricRegistry.tags((WorkerTaskResult)workerTaskResult, new String[0])).increment()).findFirst();
    }

    private List<TaskRun> childNextsTaskRun(Executor executor, TaskRun parentTaskRun) throws InternalException {
        FlowableTask flowableParent;
        List<NextTaskRun> nexts;
        Task parent = executor.getFlow().findTaskByTaskId(parentTaskRun.getTaskId());
        if (parent instanceof FlowableTask && (nexts = (flowableParent = (FlowableTask)((Object)parent)).resolveNexts(this.runContextFactory.of(executor.getFlow(), parent, executor.getExecution(), parentTaskRun), executor.getExecution(), parentTaskRun)).size() > 0) {
            return this.saveFlowableOutput(nexts, executor, parentTaskRun);
        }
        return new ArrayList<TaskRun>();
    }

    private List<TaskRun> saveFlowableOutput(List<NextTaskRun> nextTaskRuns, Executor executor, TaskRun parentTaskRun) {
        return nextTaskRuns.stream().map(Rethrow.throwFunction(t -> {
            TaskRun taskRun = t.getTaskRun();
            if (!(t.getTask() instanceof FlowableTask)) {
                return taskRun;
            }
            FlowableTask flowableTask = (FlowableTask)((Object)t.getTask());
            try {
                RunContext runContext = this.runContextFactory.of(executor.getFlow(), t.getTask(), executor.getExecution(), t.getTaskRun());
                taskRun = taskRun.withOutputs(flowableTask.outputs(runContext, executor.getExecution(), parentTaskRun) != null ? flowableTask.outputs(runContext, executor.getExecution(), parentTaskRun).toMap() : ImmutableMap.of());
            }
            catch (Exception e) {
                executor.getFlow().logger().warn("Unable to save output on taskRun '{}'", (Object)taskRun, (Object)e);
            }
            return taskRun;
        })).collect(Collectors.toList());
    }

    private Executor onEnd(Executor executor) {
        Execution newExecution = executor.getExecution().withState(executor.getExecution().guessFinalState(executor.getFlow()));
        Logger logger = executor.getFlow().logger();
        logger.info("[namespace: {}] [flow: {}] [execution: {}] Flow completed with state {} in {}", new Object[]{newExecution.getNamespace(), newExecution.getFlowId(), newExecution.getId(), newExecution.getState().getCurrent(), newExecution.getState().humanDuration()});
        if (logger.isTraceEnabled()) {
            logger.debug(newExecution.toString(true));
        }
        this.metricRegistry.counter("executor.execution.end.count", this.metricRegistry.tags(newExecution)).increment();
        this.metricRegistry.timer("executor.execution.duration", this.metricRegistry.tags(newExecution)).record(newExecution.getState().getDuration());
        return executor.withExecution(newExecution, "onEnd");
    }

    private Executor handleNext(Executor Executor2) {
        List<NextTaskRun> nextTaskRuns = FlowableUtils.resolveSequentialNexts(Executor2.getExecution(), ResolvedTask.of(Executor2.getFlow().getTasks()), ResolvedTask.of(Executor2.getFlow().getErrors()));
        if (nextTaskRuns.size() == 0) {
            return Executor2;
        }
        return Executor2.withTaskRun(this.saveFlowableOutput(nextTaskRuns, Executor2, null), "handleNext");
    }

    private Executor handleChildNext(Executor executor) throws InternalException {
        if (executor.getExecution().getTaskRunList() == null) {
            return executor;
        }
        List running = executor.getExecution().getTaskRunList().stream().filter(taskRun -> taskRun.getState().isRunning()).collect(Collectors.toList());
        ArrayList<TaskRun> result = new ArrayList<TaskRun>();
        for (TaskRun taskRun2 : running) {
            result.addAll(this.childNextsTaskRun(executor, taskRun2));
        }
        if (result.size() == 0) {
            return executor;
        }
        return executor.withTaskRun(result, "handleChildNext");
    }

    private Executor handleChildWorkerTaskResult(Executor executor) throws InternalException {
        if (executor.getExecution().getTaskRunList() == null) {
            return executor;
        }
        ArrayList<WorkerTaskResult> list = new ArrayList<WorkerTaskResult>();
        for (TaskRun taskRun : executor.getExecution().getTaskRunList()) {
            if (!taskRun.getState().isRunning()) continue;
            Optional<WorkerTaskResult> workerTaskResult = this.childWorkerTaskResult(executor.getFlow(), executor.getExecution(), taskRun);
            workerTaskResult.ifPresent(list::add);
        }
        if (list.size() == 0) {
            return executor;
        }
        executor = this.handlePausedDelay(executor, list);
        return executor.withWorkerTaskResults(list, "handleChildWorkerTaskResult");
    }

    private Executor handlePausedDelay(Executor executor, List<WorkerTaskResult> workerTaskResults) throws InternalException {
        if (workerTaskResults.stream().noneMatch(workerTaskResult -> workerTaskResult.getTaskRun().getState().getCurrent() == State.Type.PAUSED)) {
            return executor;
        }
        List<ExecutionDelay> list = workerTaskResults.stream().filter(workerTaskResult -> workerTaskResult.getTaskRun().getState().getCurrent() == State.Type.PAUSED).map(Rethrow.throwFunction(workerTaskResult -> {
            Pause pauseTask;
            Task task = executor.getFlow().findTaskByTaskId(workerTaskResult.getTaskRun().getTaskId());
            if (task instanceof Pause && ((pauseTask = (Pause)task).getDelay() != null || pauseTask.getTimeout() != null)) {
                return ExecutionDelay.builder().taskRunId(workerTaskResult.getTaskRun().getId()).executionId(executor.getExecution().getId()).date(workerTaskResult.getTaskRun().getState().maxDate().plus(pauseTask.getDelay() != null ? pauseTask.getDelay() : pauseTask.getTimeout())).state(pauseTask.getDelay() != null ? State.Type.RUNNING : State.Type.FAILED).build();
            }
            return null;
        })).filter(Objects::nonNull).collect(Collectors.toList());
        if (executor.getExecution().getState().getCurrent() != State.Type.PAUSED) {
            return executor.withExecution(executor.getExecution().withState(State.Type.PAUSED), "handlePausedDelay").withWorkerTaskDelays(list, "handlePausedDelay");
        }
        return executor.withWorkerTaskDelays(list, "handlePausedDelay");
    }

    private Executor handleChildWorkerCreatedKilling(Executor executor) throws InternalException {
        if (executor.getExecution().getTaskRunList() == null || executor.getExecution().getState().getCurrent() != State.Type.KILLING) {
            return executor;
        }
        List<WorkerTaskResult> workerTaskResults = executor.getExecution().getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent().isCreated()).map(Rethrow.throwFunction(t -> {
            Task task = executor.getFlow().findTaskByTaskId(t.getTaskId());
            return this.childWorkerTaskTypeToWorkerTask(Optional.of(State.Type.KILLED), task, (TaskRun)t);
        })).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return executor.withWorkerTaskResults(workerTaskResults, "handleChildWorkerCreatedKilling");
    }

    private Executor handleListeners(Executor executor) {
        if (!executor.getExecution().getState().isTerminated()) {
            return executor;
        }
        List<ResolvedTask> currentTasks = this.conditionService.findValidListeners(executor.getFlow(), executor.getExecution());
        List<TaskRun> nexts = this.saveFlowableOutput(FlowableUtils.resolveSequentialNexts(executor.getExecution(), currentTasks), executor, null);
        if (nexts.size() == 0) {
            return executor;
        }
        return executor.withTaskRun(nexts, "handleListeners");
    }

    private Executor handleEnd(Executor executor) {
        if (executor.getExecution().getState().isTerminated() || executor.getExecution().getState().isPaused()) {
            return executor;
        }
        List<ResolvedTask> currentTasks = executor.getExecution().findTaskDependingFlowState(ResolvedTask.of(executor.getFlow().getTasks()), ResolvedTask.of(executor.getFlow().getErrors()));
        if (!executor.getExecution().isTerminated(currentTasks)) {
            return executor;
        }
        return this.onEnd(executor);
    }

    private Executor handleRestart(Executor executor) {
        if (executor.getExecution().getState().getCurrent() != State.Type.RESTARTED) {
            return executor;
        }
        this.metricRegistry.counter("executor.execution.started.count", this.metricRegistry.tags(executor.getExecution())).increment();
        executor.getFlow().logger().info("[namespace: {}] [flow: {}] [execution: {}] Flow restarted", new Object[]{executor.getExecution().getNamespace(), executor.getExecution().getFlowId(), executor.getExecution().getId()});
        return executor.withExecution(executor.getExecution().withState(State.Type.RUNNING), "handleRestart");
    }

    private Executor handleKilling(Executor executor) {
        if (executor.getExecution().getState().getCurrent() != State.Type.KILLING) {
            return executor;
        }
        List<ResolvedTask> currentTasks = executor.getExecution().findTaskDependingFlowState(ResolvedTask.of(executor.getFlow().getTasks()), ResolvedTask.of(executor.getFlow().getErrors()));
        if (executor.getExecution().hasRunning(currentTasks) || executor.getExecution().hasCreated()) {
            return executor;
        }
        Execution newExecution = executor.getExecution().withState(State.Type.KILLED);
        return executor.withExecution(newExecution, "handleKilling");
    }

    private Executor handleWorkerTask(Executor executor) throws InternalException {
        if (executor.getExecution().getTaskRunList() == null || executor.getExecution().getState().getCurrent() == State.Type.KILLING) {
            return executor;
        }
        List<WorkerTask> workerTasks = executor.getExecution().getTaskRunList().stream().filter(taskRun -> taskRun.getState().getCurrent().isCreated()).map(Rethrow.throwFunction(taskRun -> {
            Task task = executor.getFlow().findTaskByTaskId(taskRun.getTaskId());
            return WorkerTask.builder().runContext(this.runContextFactory.of(executor.getFlow(), task, executor.getExecution(), (TaskRun)taskRun)).taskRun((TaskRun)taskRun).task(task).build();
        })).collect(Collectors.toList());
        if (workerTasks.size() == 0) {
            return executor;
        }
        return executor.withWorkerTasks(workerTasks, "handleWorkerTask");
    }

    private Executor handleFlowTask(Executor executor) {
        ArrayList<WorkerTaskExecution> executions = new ArrayList<WorkerTaskExecution>();
        ArrayList<WorkerTaskResult> workerTaskResults = new ArrayList<WorkerTaskResult>();
        boolean haveFlows = executor.getWorkerTasks().removeIf(workerTask -> {
            if (!(workerTask.getTask() instanceof io.kestra.core.tasks.flows.Flow)) {
                return false;
            }
            io.kestra.core.tasks.flows.Flow flowTask = (io.kestra.core.tasks.flows.Flow)workerTask.getTask();
            RunContext runContext = this.runContextFactory.of(executor.getFlow(), flowTask, executor.getExecution(), workerTask.getTaskRun());
            try {
                Execution execution = flowTask.createExecution(runContext, this.flowExecutorInterface());
                WorkerTaskExecution workerTaskExecution = WorkerTaskExecution.builder().task(flowTask).taskRun(workerTask.getTaskRun()).execution(execution).build();
                executions.add(workerTaskExecution);
                if (!flowTask.getWait().booleanValue()) {
                    workerTaskResults.add(flowTask.createWorkerTaskResult(null, workerTaskExecution, null, execution));
                }
            }
            catch (Exception e) {
                workerTaskResults.add(WorkerTaskResult.builder().taskRun(workerTask.getTaskRun().withState(State.Type.FAILED)).build());
                executor.withException(e, "handleFlowTask");
            }
            return true;
        });
        if (!haveFlows) {
            return executor;
        }
        Executor resultExecutor = executor.withWorkerTaskExecutions(executions, "handleFlowTask");
        if (workerTaskResults.size() > 0) {
            resultExecutor = executor.withWorkerTaskResults(workerTaskResults, "handleFlowTaskWorkerTaskResults");
        }
        return resultExecutor;
    }

    public Execution addDynamicTaskRun(Execution execution, Flow flow, WorkerTaskResult workerTaskResult) throws InternalException {
        ArrayList<TaskRun> taskRuns;
        block4: {
            taskRuns = new ArrayList<TaskRun>(execution.getTaskRunList());
            if (workerTaskResult.getDynamicTaskRuns() != null) {
                taskRuns.addAll(workerTaskResult.getDynamicTaskRuns());
            }
            if (workerTaskResult.getTaskRun().getParentTaskRunId() != null) {
                try {
                    execution.findTaskRunByTaskRunId(workerTaskResult.getTaskRun().getId());
                }
                catch (InternalException e) {
                    TaskRun parentTaskRun = execution.findTaskRunByTaskRunId(workerTaskResult.getTaskRun().getParentTaskRunId());
                    Task parentTask = flow.findTaskByTaskId(parentTaskRun.getTaskId());
                    if (!(parentTask instanceof Worker)) break block4;
                    taskRuns.add(workerTaskResult.getTaskRun());
                }
            }
        }
        return taskRuns.size() > execution.getTaskRunList().size() ? execution.withTaskRunList(taskRuns) : null;
    }

    public boolean canBePurged(Executor executor) {
        return executor.getExecution().isDeleted() || executor.getFlow() != null && this.conditionService.isTerminatedWithListeners(executor.getFlow(), executor.getExecution()) && executor.getExecution().getState().getCurrent() != State.Type.PAUSED && executor.getExecution().getState().getCurrent() != State.Type.KILLED;
    }

    public void log(Logger log, Boolean in, WorkerTask value) {
        log.debug("{} {} : {}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getTaskRun().toStringState()});
    }

    public void log(Logger log, Boolean in, WorkerTaskResult value) {
        log.debug("{} {} : {}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getTaskRun().toStringState()});
    }

    public void log(Logger log, Boolean in, Execution value) {
        log.debug("{} {} [key='{}']\n{}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getId(), value.toStringState()});
    }

    public void log(Logger log, Boolean in, Executor value) {
        log.debug("{} {} [key='{}', from='{}', offset='{}', crc32='{}']\n{}", new Object[]{in != false ? "<< IN " : ">> OUT", value.getClass().getSimpleName(), value.getExecution().getId(), value.getFrom(), value.getOffset(), value.getExecution().toCrc32State(), value.getExecution().toStringState()});
    }
}

