/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FlowableUtils {
    private static final TypeReference<List<Object>> TYPE_REFERENCE = new TypeReference<List<Object>>(){};
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson();

    public static List<NextTaskRun> resolveSequentialNexts(Execution execution, List<ResolvedTask> tasks) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks);
        return FlowableUtils.innerResolveSequentialNexts(execution, currentTasks, null);
    }

    public static List<NextTaskRun> resolveSequentialNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors) {
        return FlowableUtils.resolveSequentialNexts(execution, tasks, errors, null);
    }

    public static List<NextTaskRun> resolveSequentialNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, TaskRun parentTaskRun) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks, errors, parentTaskRun);
        return FlowableUtils.innerResolveSequentialNexts(execution, currentTasks, parentTaskRun);
    }

    private static List<NextTaskRun> innerResolveSequentialNexts(Execution execution, List<ResolvedTask> currentTasks, TaskRun parentTaskRun) {
        if (currentTasks == null || currentTasks.size() == 0) {
            return new ArrayList<NextTaskRun>();
        }
        List<TaskRun> taskRuns = execution.findTaskRunByTasks(currentTasks, parentTaskRun);
        if (taskRuns.size() == 0) {
            return Collections.singletonList(currentTasks.get(0).toNextTaskRun(execution));
        }
        Optional<TaskRun> lastCreated = execution.findLastCreated(currentTasks, parentTaskRun);
        if (lastCreated.isPresent()) {
            return new ArrayList<NextTaskRun>();
        }
        Optional<TaskRun> lastRunning = execution.findLastRunning(currentTasks, parentTaskRun);
        if (lastRunning.isPresent()) {
            return new ArrayList<NextTaskRun>();
        }
        Optional<TaskRun> lastTerminated = execution.findLastTerminated(currentTasks, parentTaskRun);
        if (lastTerminated.isPresent()) {
            int lastIndex = taskRuns.indexOf(lastTerminated.get());
            if (currentTasks.size() > lastIndex + 1) {
                return Collections.singletonList(currentTasks.get(lastIndex + 1).toNextTaskRun(execution));
            }
        }
        return new ArrayList<NextTaskRun>();
    }

    public static Optional<State.Type> resolveState(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, TaskRun parentTaskRun, RunContext runContext) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks, errors, parentTaskRun);
        if (currentTasks == null) {
            runContext.logger().warn("No task found on flow '{}', task '{}', execution '{}'", new Object[]{execution.getNamespace() + "." + execution.getFlowId(), parentTaskRun.getTaskId(), execution.getId()});
            return Optional.of(State.Type.FAILED);
        }
        if (currentTasks.size() > 0 ? execution.isTerminated(currentTasks, parentTaskRun) : execution.hasFailed(tasks, parentTaskRun)) {
            return Optional.of(execution.guessFinalState(tasks, parentTaskRun));
        }
        return Optional.empty();
    }

    public static List<ResolvedTask> resolveTasks(List<Task> tasks, TaskRun parentTaskRun) {
        if (tasks == null) {
            return null;
        }
        return tasks.stream().map(task -> ResolvedTask.builder().task((Task)task).parentId(parentTaskRun.getId()).build()).collect(Collectors.toList());
    }

    public static List<NextTaskRun> resolveParallelNexts(Execution execution, List<ResolvedTask> tasks, List<ResolvedTask> errors, TaskRun parentTaskRun, Integer concurrency) {
        List<ResolvedTask> currentTasks = execution.findTaskDependingFlowState(tasks, errors, parentTaskRun);
        List<TaskRun> taskRuns = execution.findTaskRunByTasks(currentTasks, parentTaskRun);
        List notFinds = currentTasks.stream().filter(resolvedTask -> taskRuns.stream().noneMatch(taskRun -> FlowableUtils.isTaskRunFor(resolvedTask, taskRun, parentTaskRun))).collect(Collectors.toList());
        long runningCount = taskRuns.stream().filter(taskRun -> taskRun.getState().isRunning()).count();
        if (concurrency > 0 && runningCount > (long)concurrency.intValue()) {
            return new ArrayList<NextTaskRun>();
        }
        Optional<TaskRun> lastCreated = execution.findLastCreated(currentTasks, parentTaskRun);
        if (notFinds.size() > 0 && lastCreated.isEmpty()) {
            Stream<NextTaskRun> nextTaskRunStream = notFinds.stream().map(resolvedTask -> resolvedTask.toNextTaskRun(execution));
            if (concurrency > 0) {
                nextTaskRunStream = nextTaskRunStream.limit((long)concurrency.intValue() - runningCount);
            }
            return nextTaskRunStream.collect(Collectors.toList());
        }
        return new ArrayList<NextTaskRun>();
    }

    public static List<ResolvedTask> resolveEachTasks(RunContext runContext, TaskRun parentTaskRun, List<Task> tasks, Object value) throws IllegalVariableEvaluationException {
        List<String> values;
        if (value instanceof String) {
            String renderValue = runContext.render((String)value);
            try {
                values = (List)MAPPER.readValue(renderValue, TYPE_REFERENCE);
            }
            catch (JsonProcessingException e) {
                throw new IllegalVariableEvaluationException(e);
            }
        } else if (value instanceof List) {
            values = new ArrayList(((List)value).size());
            for (Object obj : (List)value) {
                if (obj instanceof String) {
                    values.add(runContext.render((String)obj));
                    continue;
                }
                if (obj instanceof Map) {
                    values.add((String)((Object)runContext.render((Map)obj)));
                    continue;
                }
                throw new IllegalVariableEvaluationException("Unknown value element type: " + obj.getClass());
            }
        } else {
            throw new IllegalVariableEvaluationException("Unknown value type: " + value.getClass());
        }
        List distinctValue = values.stream().distinct().collect(Collectors.toList());
        long nullCount = distinctValue.stream().filter(Objects::isNull).count();
        if (nullCount > 0L) {
            throw new IllegalVariableEvaluationException("Found '" + nullCount + "' null values on Each, with values=" + Arrays.toString(values.toArray()));
        }
        ArrayList<ResolvedTask> result = new ArrayList<ResolvedTask>();
        for (Object current : distinctValue) {
            for (Task task : tasks) {
                try {
                    String resolvedValue = current instanceof String ? (String)current : MAPPER.writeValueAsString(current);
                    result.add(ResolvedTask.builder().task(task).value(resolvedValue).parentId(parentTaskRun.getId()).build());
                }
                catch (JsonProcessingException e) {
                    throw new IllegalVariableEvaluationException(e);
                }
            }
        }
        return result;
    }

    public static boolean isTaskRunFor(ResolvedTask resolvedTask, TaskRun taskRun, TaskRun parentTaskRun) {
        return !(!resolvedTask.getTask().getId().equals(taskRun.getTaskId()) || parentTaskRun != null && !parentTaskRun.getId().equals(taskRun.getParentTaskRunId()) || resolvedTask.getValue() != null && !resolvedTask.getValue().equals(taskRun.getValue()));
    }
}

