/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.github.jknack.handlebars.EscapingStrategy;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.EachHelper;
import com.github.jknack.handlebars.helper.LogHelper;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.helper.UnlessHelper;
import com.github.jknack.handlebars.helper.WithHelper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.handlebars.VariableRendererPlugins;
import io.kestra.core.runners.handlebars.helpers.DateHelper;
import io.kestra.core.runners.handlebars.helpers.EvalHelper;
import io.kestra.core.runners.handlebars.helpers.FirstDefinedEvalHelper;
import io.kestra.core.runners.handlebars.helpers.JqHelper;
import io.kestra.core.runners.handlebars.helpers.JsonHelper;
import io.kestra.core.runners.handlebars.helpers.MiscHelper;
import io.kestra.core.runners.handlebars.helpers.OtherBooleansHelper;
import io.kestra.core.runners.handlebars.helpers.OtherStringsHelper;
import io.kestra.core.runners.pebble.ExtensionCustomizer;
import io.kestra.core.runners.pebble.JsonWriter;
import io.kestra.core.runners.pebble.PebbleLruCache;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.cache.PebbleCache;
import io.pebbletemplates.pebble.error.AttributeNotFoundException;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.AbstractExtension;
import io.pebbletemplates.pebble.extension.Extension;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@Singleton
public class VariableRenderer {
    private Handlebars handlebars;
    private final PebbleEngine pebbleEngine;
    private final VariableConfiguration variableConfiguration;

    @Inject
    public VariableRenderer(ApplicationContext applicationContext, @Nullable VariableConfiguration variableConfiguration) {
        VariableConfiguration variableConfiguration2 = this.variableConfiguration = variableConfiguration != null ? variableConfiguration : new VariableConfiguration();
        if (!this.variableConfiguration.getDisableHandlebars().booleanValue()) {
            this.handlebars = new Handlebars().with(EscapingStrategy.NOOP).registerHelpers(ConditionalHelpers.class).registerHelpers(EachHelper.class).registerHelpers(LogHelper.class).registerHelpers(StringHelpers.class).registerHelpers(OtherStringsHelper.class).registerHelpers(UnlessHelper.class).registerHelpers(WithHelper.class).registerHelpers(DateHelper.class).registerHelpers(JsonHelper.class).registerHelpers(MiscHelper.class).registerHelpers(OtherBooleansHelper.class).registerHelper("eval", (Helper)new EvalHelper(this)).registerHelper("firstDefinedEval", (Helper)new FirstDefinedEvalHelper(this)).registerHelper("jq", (Helper)new JqHelper()).registerHelperMissing((context, options) -> {
                throw new IllegalStateException("Missing variable: " + options.helperName);
            });
            applicationContext.getBeansOfType(VariableRendererPlugins.class).forEach(variableRendererPlugins -> this.handlebars.registerHelper(variableRendererPlugins.name(), variableRendererPlugins.helper()));
        }
        PebbleEngine.Builder pebbleBuilder = new PebbleEngine.Builder().registerExtensionCustomizer(ExtensionCustomizer::new).strictVariables(true).cacheActive(this.variableConfiguration.getCacheEnabled().booleanValue()).newLineTrimming(false).autoEscaping(false);
        applicationContext.getBeansOfType(AbstractExtension.class).forEach(xva$0 -> pebbleBuilder.extension(new Extension[]{xva$0}));
        if (this.variableConfiguration.getCacheEnabled().booleanValue()) {
            pebbleBuilder.templateCache((PebbleCache)new PebbleLruCache(this.variableConfiguration.getCacheSize()));
        }
        this.pebbleEngine = pebbleBuilder.build();
    }

    public String recursiveRender(String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        if (inline == null) {
            return null;
        }
        boolean isSame = false;
        String currentTemplate = inline;
        String current = "";
        while (!isSame) {
            try {
                PebbleTemplate compiledTemplate = this.pebbleEngine.getLiteralTemplate(currentTemplate);
                JsonWriter writer = new JsonWriter(new StringWriter());
                compiledTemplate.evaluate((Writer)writer, variables);
                current = ((Object)writer).toString();
            }
            catch (PebbleException | IOException e) {
                if (this.variableConfiguration.disableHandlebars.booleanValue()) {
                    if (e instanceof PebbleException) {
                        throw this.properPebbleException((PebbleException)e);
                    }
                    throw new IllegalVariableEvaluationException(e);
                }
                try {
                    Template template = this.handlebars.compileInline(currentTemplate);
                    current = template.apply(variables);
                }
                catch (HandlebarsException | IOException hbE) {
                    throw new IllegalVariableEvaluationException("Pebble evaluation failed with '" + e.getMessage() + "' and Handlebars fallback failed also  with '" + hbE.getMessage() + "'", e);
                }
            }
            isSame = currentTemplate.equals(current);
            currentTemplate = current;
        }
        return current;
    }

    public IllegalVariableEvaluationException properPebbleException(PebbleException e) {
        if (e instanceof AttributeNotFoundException) {
            AttributeNotFoundException current = (AttributeNotFoundException)((Object)e);
            return new IllegalVariableEvaluationException("Missing variable: '" + current.getAttributeName() + "' on '" + current.getFileName() + "' at line " + current.getLineNumber(), e);
        }
        return new IllegalVariableEvaluationException(e);
    }

    public String render(String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.recursiveRender(inline, variables);
    }

    public Map<String, Object> render(Map<String, Object> in, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> r : in.entrySet()) {
            String key = this.render(r.getKey(), variables);
            Object value = this.renderObject(r.getValue(), variables).orElse(r.getValue());
            map.putIfAbsent(key, value);
        }
        return map;
    }

    private Optional<Object> renderObject(Object object, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        if (object instanceof Map) {
            return Optional.of(this.render((Map)object, variables));
        }
        if (object instanceof Collection) {
            return Optional.of(this.renderList((List)object, variables));
        }
        if (object instanceof String) {
            return Optional.of(this.render((String)object, variables));
        }
        return Optional.empty();
    }

    public List<Object> renderList(List<Object> list, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object inline : list) {
            this.renderObject(inline, variables).ifPresent(result::add);
        }
        return result;
    }

    public List<String> render(List<String> list, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        ArrayList<String> result = new ArrayList<String>();
        for (String inline : list) {
            result.add(this.recursiveRender(inline, variables));
        }
        return result;
    }

    @ConfigurationProperties(value="kestra.variables")
    public static class VariableConfiguration {
        Boolean disableHandlebars = true;
        Boolean cacheEnabled = true;
        Integer cacheSize = 1000;

        @Generated
        public Boolean getDisableHandlebars() {
            return this.disableHandlebars;
        }

        @Generated
        public Boolean getCacheEnabled() {
            return this.cacheEnabled;
        }

        @Generated
        public Integer getCacheSize() {
            return this.cacheSize;
        }
    }
}

