/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.serializers.JacksonMapper;
import io.pebbletemplates.pebble.extension.writer.SpecializedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;

public class JsonWriter
extends Writer
implements SpecializedWriter {
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson();
    private final StringWriter stringWriter;

    public JsonWriter(StringWriter stringWriter) {
        this.stringWriter = stringWriter;
    }

    public void writeSpecialized(int i) {
        this.stringWriter.getBuffer().append(i);
    }

    public void writeSpecialized(long l) {
        this.stringWriter.getBuffer().append(l);
    }

    public void writeSpecialized(double d) {
        this.stringWriter.getBuffer().append(d);
    }

    public void writeSpecialized(float f) {
        this.stringWriter.getBuffer().append(f);
    }

    public void writeSpecialized(short s) {
        this.stringWriter.getBuffer().append(s);
    }

    public void writeSpecialized(byte b) {
        this.stringWriter.getBuffer().append(b);
    }

    public void writeSpecialized(char c) {
        this.stringWriter.getBuffer().append(c);
    }

    public void writeSpecialized(String s) {
        this.stringWriter.getBuffer().append(s);
    }

    public void write(Object o) {
        if (o instanceof Map) {
            this.writeSpecialized(MAPPER.writeValueAsString(o));
        } else if (o instanceof Collection) {
            this.writeSpecialized(MAPPER.writeValueAsString(o));
        } else if (o.getClass().isArray()) {
            this.writeSpecialized(MAPPER.writeValueAsString(o));
        } else {
            super.write(o);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.stringWriter.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.stringWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.stringWriter.flush();
    }

    public String toString() {
        return this.stringWriter.toString();
    }
}

