/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.schedulers;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.PollingTriggerInterface;
import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.schedulers.Scheduler;
import io.kestra.core.schedulers.SchedulerExecutionStateInterface;
import io.kestra.core.schedulers.SchedulerExecutionWithTrigger;
import io.kestra.core.schedulers.SchedulerTriggerStateInterface;
import io.kestra.core.services.ConditionService;
import io.kestra.core.services.FlowListenersInterface;
import io.kestra.core.services.FlowService;
import io.kestra.core.services.TaskDefaultService;
import io.kestra.core.utils.Await;
import io.kestra.core.utils.ExecutorsUtils;
import io.kestra.core.utils.ListUtils;
import io.micronaut.context.ApplicationContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public abstract class AbstractScheduler
implements Scheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractScheduler.class);
    protected final ApplicationContext applicationContext;
    private final QueueInterface<Execution> executionQueue;
    private final QueueInterface<Trigger> triggerQueue;
    protected final FlowListenersInterface flowListeners;
    private final RunContextFactory runContextFactory;
    private final MetricRegistry metricRegistry;
    private final ConditionService conditionService;
    private final TaskDefaultService taskDefaultService;
    protected SchedulerExecutionStateInterface executionState;
    protected SchedulerTriggerStateInterface triggerState;
    protected Boolean isReady = false;
    private final ScheduledExecutorService scheduleExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ListeningExecutorService cachedExecutor;
    private final Map<String, ZonedDateTime> lastEvaluate = new ConcurrentHashMap<String, ZonedDateTime>();
    private final Map<String, ZonedDateTime> evaluateRunning = new ConcurrentHashMap<String, ZonedDateTime>();
    private final Map<String, AtomicInteger> evaluateRunningCount = new ConcurrentHashMap<String, AtomicInteger>();
    private final Map<String, Trigger> triggerStateSaved = new ConcurrentHashMap<String, Trigger>();
    private List<FlowWithTrigger> schedulable = new ArrayList<FlowWithTrigger>();
    private Map<String, FlowWithPollingTriggerNextDate> schedulableNextDate = new HashMap<String, FlowWithPollingTriggerNextDate>();

    @Inject
    public AbstractScheduler(ApplicationContext applicationContext, FlowListenersInterface flowListeners) {
        this.applicationContext = applicationContext;
        this.executionQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionQueue"));
        this.triggerQueue = (QueueInterface)applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"triggerQueue"));
        this.flowListeners = flowListeners;
        this.runContextFactory = (RunContextFactory)applicationContext.getBean(RunContextFactory.class);
        this.metricRegistry = (MetricRegistry)applicationContext.getBean(MetricRegistry.class);
        this.conditionService = (ConditionService)applicationContext.getBean(ConditionService.class);
        this.taskDefaultService = (TaskDefaultService)applicationContext.getBean(TaskDefaultService.class);
        this.cachedExecutor = MoreExecutors.listeningDecorator((ExecutorService)((ExecutorsUtils)applicationContext.getBean(ExecutorsUtils.class)).cachedThreadPool("scheduler-polling"));
    }

    @Override
    public void run() {
        this.flowListeners.run();
        ScheduledFuture<?> handle = this.scheduleExecutor.scheduleAtFixedRate(this::handle, 0L, 1L, TimeUnit.SECONDS);
        this.flowListeners.listen(this::computeSchedulable);
        Thread thread = new Thread(() -> {
            Await.until(handle::isDone);
            try {
                handle.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Executor fatal exception", (Throwable)e);
                this.applicationContext.close();
                Runtime.getRuntime().exit(1);
            }
        }, "scheduler-listener");
        thread.start();
        this.flowListeners.listen((flow, previous) -> {
            AbstractScheduler abstractScheduler = this;
            synchronized (abstractScheduler) {
                if (flow.isDeleted()) {
                    ListUtils.emptyOnNull(flow.getTriggers()).forEach(abstractTrigger -> {
                        Trigger trigger = Trigger.of(flow, abstractTrigger);
                        this.triggerStateSaved.remove(trigger.uid());
                        this.triggerQueue.delete(trigger);
                    });
                } else if (previous != null) {
                    FlowService.findRemovedTrigger(flow, previous).forEach(abstractTrigger -> {
                        Trigger trigger = Trigger.of(flow, abstractTrigger);
                        this.triggerStateSaved.remove(trigger.uid());
                        this.triggerQueue.delete(trigger);
                    });
                }
            }
        });
    }

    private void computeSchedulable(List<Flow> flows) {
        this.schedulableNextDate = new HashMap<String, FlowWithPollingTriggerNextDate>();
        this.schedulable = flows.stream().filter(flow -> flow.getTriggers() != null && flow.getTriggers().size() > 0).filter(flow -> !flow.isDisabled()).flatMap(flow -> flow.getTriggers().stream().filter(abstractTrigger -> !abstractTrigger.isDisabled()).map(trigger -> {
            RunContext runContext = this.runContextFactory.of((Flow)flow, (AbstractTrigger)trigger);
            return new FlowWithTrigger((Flow)flow, (AbstractTrigger)trigger, runContext, this.conditionService.conditionContext(runContext, (Flow)flow, null));
        })).filter(flowWithTrigger -> flowWithTrigger.getTrigger() instanceof PollingTriggerInterface).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle() {
        if (!this.isReady.booleanValue()) {
            log.warn("Scheduler is not ready, waiting");
        }
        this.metricRegistry.counter("scheduler.loop.count", new String[0]).increment();
        ZonedDateTime now = AbstractScheduler.now();
        AbstractScheduler abstractScheduler = this;
        synchronized (abstractScheduler) {
            if (log.isDebugEnabled()) {
                log.debug("Scheduler next iteration for {} with {} schedulables of {} flows", new Object[]{now, this.schedulable.size(), this.flowListeners.flows().size()});
            }
            List<FlowWithPollingTriggerNextDate> readyForEvaluate = this.schedulable.stream().filter(f -> this.conditionService.isValid(f.getFlow(), f.getTrigger(), f.getConditionContext())).map(flowWithTrigger -> ((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)((FlowWithPollingTrigger.FlowWithPollingTriggerBuilder)FlowWithPollingTrigger.builder().flow(flowWithTrigger.getFlow())).trigger(flowWithTrigger.getTrigger())).pollingTrigger((PollingTriggerInterface)((Object)flowWithTrigger.getTrigger()))).conditionContext(flowWithTrigger.getConditionContext())).triggerContext((TriggerContext)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)TriggerContext.builder().namespace(flowWithTrigger.getFlow().getNamespace())).flowId(flowWithTrigger.getFlow().getId())).flowRevision(flowWithTrigger.getFlow().getRevision())).triggerId(flowWithTrigger.getTrigger().getId())).date(AbstractScheduler.now())).build())).build()).filter(f -> this.isEvaluationInterval((FlowWithPollingTrigger)f, now)).filter(f -> this.isExecutionNotRunning((FlowWithPollingTrigger)f, now)).map(f -> {
                AbstractScheduler abstractScheduler = this;
                synchronized (abstractScheduler) {
                    Trigger lastTrigger = this.getLastTrigger((FlowWithPollingTrigger)f, now);
                    return FlowWithPollingTriggerNextDate.of(f, f.getPollingTrigger().nextEvaluationDate(f.getConditionContext(), Optional.of(lastTrigger)));
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (log.isDebugEnabled()) {
                log.debug("Scheduler will evaluate for {} with {} readyForEvaluate of {} schedulables", new Object[]{now, readyForEvaluate.size(), this.schedulable.size()});
            }
            this.metricRegistry.counter("scheduler.evaluate.count", new String[0]).increment((double)readyForEvaluate.size());
            readyForEvaluate.forEach(f -> {
                this.schedulableNextDate.put(f.getTriggerContext().uid(), (FlowWithPollingTriggerNextDate)f);
                if (f.getPollingTrigger().getInterval() == null) {
                    try {
                        this.handleEvaluatePollingTriggerResult(this.evaluatePollingTrigger((FlowWithPollingTrigger)f));
                    }
                    catch (Exception e) {
                        AbstractScheduler.logError(f, e);
                    }
                } else {
                    this.addToRunning(f.getTriggerContext(), now);
                    ListenableFuture result = this.cachedExecutor.submit(() -> this.evaluatePollingTrigger((FlowWithPollingTrigger)f));
                    Futures.addCallback((ListenableFuture)result, (FutureCallback)new EvaluateFuture(this, (FlowWithPollingTriggerNextDate)f), (Executor)this.cachedExecutor);
                }
            });
        }
    }

    private static void logError(FlowWithPollingTrigger flowWithPollingTriggerNextDate, Throwable e) {
        Logger logger = flowWithPollingTriggerNextDate.getConditionContext().getRunContext().logger();
        logger.warn("[namespace: {}] [flow: {}] [trigger: {}] [date: {}] Evaluate Failed with error '{}'", new Object[]{flowWithPollingTriggerNextDate.getFlow().getNamespace(), flowWithPollingTriggerNextDate.getFlow().getId(), flowWithPollingTriggerNextDate.getTriggerContext().getTriggerId(), flowWithPollingTriggerNextDate.getTriggerContext().getDate(), e.getMessage(), e});
        if (logger.isTraceEnabled()) {
            logger.trace(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void handleEvaluatePollingTriggerResult(SchedulerExecutionWithTrigger result) {
        Stream.of(result).filter(Objects::nonNull).peek(this::log).forEach(this::saveLastTriggerAndEmitExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToRunning(TriggerContext triggerContext, ZonedDateTime now) {
        AbstractScheduler abstractScheduler = this;
        synchronized (abstractScheduler) {
            this.evaluateRunningCount.computeIfAbsent(triggerContext.uid(), s -> this.metricRegistry.gauge("scheduler.evaluate.running.count", new AtomicInteger(0), this.metricRegistry.tags(triggerContext)));
            this.evaluateRunning.put(triggerContext.uid(), now);
            this.evaluateRunningCount.get(triggerContext.uid()).addAndGet(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromRunning(TriggerContext triggerContext) {
        AbstractScheduler abstractScheduler = this;
        synchronized (abstractScheduler) {
            if (this.evaluateRunning.remove(triggerContext.uid()) == null) {
                throw new IllegalStateException("Can't remove trigger '" + triggerContext.uid() + "' from running");
            }
            this.evaluateRunningCount.get(triggerContext.uid()).addAndGet(-1);
        }
    }

    private boolean isExecutionNotRunning(FlowWithPollingTrigger f, ZonedDateTime now) {
        Trigger lastTrigger = this.getLastTrigger(f, now);
        if (lastTrigger.getExecutionId() == null) {
            return true;
        }
        Optional<Execution> execution = this.executionState.findById(lastTrigger.getExecutionId());
        if (execution.isEmpty()) {
            if (lastTrigger.getUpdatedDate() != null) {
                this.metricRegistry.timer("scheduler.execution.missing.duration", this.metricRegistry.tags(lastTrigger)).record(Duration.between(lastTrigger.getUpdatedDate(), Instant.now()));
            }
            if (lastTrigger.getUpdatedDate() == null || lastTrigger.getUpdatedDate().plusSeconds(60L).isBefore(Instant.now())) {
                log.warn("Execution '{}' for flow '{}.{}' is not found, schedule is blocked since {}", new Object[]{lastTrigger.getExecutionId(), lastTrigger.getNamespace(), lastTrigger.getFlowId(), lastTrigger.getUpdatedDate()});
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            if (lastTrigger.getUpdatedDate() != null) {
                this.metricRegistry.timer("scheduler.execution.running.duration", this.metricRegistry.tags(lastTrigger)).record(Duration.between(lastTrigger.getUpdatedDate(), Instant.now()));
            }
            log.debug("Execution '{}' for flow '{}.{}' is still '{}', waiting for next backfill", new Object[]{lastTrigger.getExecutionId(), lastTrigger.getNamespace(), lastTrigger.getFlowId(), execution.get().getState().getCurrent()});
        }
        return false;
    }

    private void log(SchedulerExecutionWithTrigger executionWithTrigger) {
        this.metricRegistry.counter("scheduler.trigger.count", this.metricRegistry.tags(executionWithTrigger, new String[0])).increment();
        ZonedDateTime now = AbstractScheduler.now();
        if (executionWithTrigger.getExecution().getTrigger() != null) {
            ZonedDateTime next;
            Object nextVariable = executionWithTrigger.getExecution().getTrigger().getVariables().get("next");
            ZonedDateTime zonedDateTime = next = nextVariable != null ? ZonedDateTime.parse((CharSequence)nextVariable) : null;
            if (next != null && now.isBefore(next)) {
                this.metricRegistry.timer("scheduler.trigger.delay.duration", this.metricRegistry.tags(executionWithTrigger, new String[0])).record(Duration.between(executionWithTrigger.getTriggerContext().getDate(), now));
            }
        }
        log.info("Scheduled execution '{}' for flow '{}.{}' at '{}' started at '{}' for trigger [{}]", new Object[]{executionWithTrigger.getExecution().getId(), executionWithTrigger.getExecution().getNamespace(), executionWithTrigger.getExecution().getFlowId(), executionWithTrigger.getTriggerContext().getDate(), now, executionWithTrigger.getTriggerContext().getTriggerId()});
    }

    private Trigger getLastTrigger(FlowWithPollingTrigger f, ZonedDateTime now) {
        return this.triggerState.findLast(f.getTriggerContext()).orElseGet(() -> {
            ZonedDateTime nextDate = f.getPollingTrigger().nextEvaluationDate(f.getConditionContext(), Optional.empty());
            TriggerContext build = ((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)((Trigger.TriggerBuilder)Trigger.builder().date(nextDate.compareTo(now) < 0 ? nextDate : now)).flowId(f.getFlow().getId())).flowRevision(f.getFlow().getRevision())).namespace(f.getFlow().getNamespace())).triggerId(f.getTriggerContext().getTriggerId())).updatedDate(Instant.now())).build();
            if (this.triggerStateSaved.containsKey(((Trigger)build).uid())) {
                Trigger cachedTrigger = this.triggerStateSaved.get(((Trigger)build).uid());
                this.triggerState.save((Trigger)build);
                this.triggerStateSaved.remove(((Trigger)build).uid());
                return cachedTrigger;
            }
            this.triggerStateSaved.put(((Trigger)build).uid(), (Trigger)build);
            return build;
        });
    }

    private boolean isEvaluationInterval(FlowWithPollingTrigger flowWithPollingTrigger, ZonedDateTime now) {
        boolean result;
        String key = flowWithPollingTrigger.getTriggerContext().uid();
        if (flowWithPollingTrigger.getPollingTrigger().getInterval() == null) {
            return true;
        }
        if (this.evaluateRunning.containsKey(key)) {
            return false;
        }
        if (!this.lastEvaluate.containsKey(key)) {
            this.lastEvaluate.put(key, now);
            return true;
        }
        boolean bl = result = this.lastEvaluate.get(key).plus(flowWithPollingTrigger.getPollingTrigger().getInterval()).compareTo(now) < 0;
        if (result) {
            this.lastEvaluate.put(key, now);
        }
        return result;
    }

    protected synchronized void saveLastTriggerAndEmitExecution(SchedulerExecutionWithTrigger executionWithTrigger) {
        Trigger trigger = Trigger.of(executionWithTrigger.getTriggerContext(), executionWithTrigger.getExecution());
        this.triggerState.save(trigger);
        this.executionQueue.emit(executionWithTrigger.getExecution());
    }

    private static ZonedDateTime now() {
        return ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS);
    }

    private SchedulerExecutionWithTrigger evaluatePollingTrigger(FlowWithPollingTrigger flowWithTrigger) throws Exception {
        Optional result = (Optional)this.metricRegistry.timer("scheduler.evaluate.duration", this.metricRegistry.tags(flowWithTrigger.getTriggerContext())).record(() -> {
            try {
                FlowWithPollingTrigger flowWithPollingTrigger = flowWithTrigger.from(this.taskDefaultService.injectDefaults(flowWithTrigger.getFlow(), flowWithTrigger.getConditionContext().getRunContext().logger()));
                Optional<Execution> evaluate = flowWithPollingTrigger.getPollingTrigger().evaluate(flowWithPollingTrigger.getConditionContext(), flowWithPollingTrigger.getTriggerContext());
                if (log.isDebugEnabled() && evaluate.isEmpty()) {
                    log.trace("Empty evaluation for flow '{}.{}' for date '{}, waiting !", new Object[]{flowWithPollingTrigger.getFlow().getNamespace(), flowWithPollingTrigger.getFlow().getId(), flowWithPollingTrigger.getTriggerContext().getDate()});
                }
                flowWithPollingTrigger.getConditionContext().getRunContext().cleanup();
                return evaluate;
            }
            catch (Exception e) {
                AbstractScheduler.logError(flowWithTrigger, e);
                return Optional.empty();
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return new SchedulerExecutionWithTrigger((Execution)result.get(), flowWithTrigger.getTriggerContext());
    }

    @Override
    public void close() {
        this.scheduleExecutor.shutdown();
    }

    @Generated
    public List<FlowWithTrigger> getSchedulable() {
        return this.schedulable;
    }

    @Generated
    public Map<String, FlowWithPollingTriggerNextDate> getSchedulableNextDate() {
        return this.schedulableNextDate;
    }

    private static class FlowWithPollingTrigger {
        private Flow flow;
        private AbstractTrigger trigger;
        private PollingTriggerInterface pollingTrigger;
        private TriggerContext triggerContext;
        private ConditionContext conditionContext;

        public FlowWithPollingTrigger from(Flow flow) throws InternalException {
            AbstractTrigger abstractTrigger = flow.getTriggers().stream().filter(a -> a.getId().equals(this.trigger.getId())).findFirst().orElseThrow(() -> new InternalException("Couldn't find the trigger '" + this.trigger.getId() + "' on flow '" + flow.uid() + "'"));
            return ((FlowWithPollingTriggerBuilder)((FlowWithPollingTriggerBuilder)((FlowWithPollingTriggerBuilder)this.toBuilder().flow(flow)).trigger(abstractTrigger)).pollingTrigger((PollingTriggerInterface)((Object)abstractTrigger))).build();
        }

        @Generated
        protected FlowWithPollingTrigger(FlowWithPollingTriggerBuilder<?, ?> b) {
            this.flow = b.flow;
            this.trigger = b.trigger;
            this.pollingTrigger = b.pollingTrigger;
            this.triggerContext = b.triggerContext;
            this.conditionContext = b.conditionContext;
        }

        @Generated
        public static FlowWithPollingTriggerBuilder<?, ?> builder() {
            return new FlowWithPollingTriggerBuilderImpl();
        }

        @Generated
        public FlowWithPollingTriggerBuilder<?, ?> toBuilder() {
            return new FlowWithPollingTriggerBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public Flow getFlow() {
            return this.flow;
        }

        @Generated
        public AbstractTrigger getTrigger() {
            return this.trigger;
        }

        @Generated
        public PollingTriggerInterface getPollingTrigger() {
            return this.pollingTrigger;
        }

        @Generated
        public TriggerContext getTriggerContext() {
            return this.triggerContext;
        }

        @Generated
        public ConditionContext getConditionContext() {
            return this.conditionContext;
        }

        @Generated
        public FlowWithPollingTrigger() {
        }

        @Generated
        public static abstract class FlowWithPollingTriggerBuilder<C extends FlowWithPollingTrigger, B extends FlowWithPollingTriggerBuilder<C, B>> {
            @Generated
            private Flow flow;
            @Generated
            private AbstractTrigger trigger;
            @Generated
            private PollingTriggerInterface pollingTrigger;
            @Generated
            private TriggerContext triggerContext;
            @Generated
            private ConditionContext conditionContext;

            @Generated
            protected B $fillValuesFrom(C instance) {
                FlowWithPollingTriggerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(FlowWithPollingTrigger instance, FlowWithPollingTriggerBuilder<?, ?> b) {
                b.flow(instance.flow);
                b.trigger(instance.trigger);
                b.pollingTrigger(instance.pollingTrigger);
                b.triggerContext(instance.triggerContext);
                b.conditionContext(instance.conditionContext);
            }

            @Generated
            public B flow(Flow flow) {
                this.flow = flow;
                return this.self();
            }

            @Generated
            public B trigger(AbstractTrigger trigger) {
                this.trigger = trigger;
                return this.self();
            }

            @Generated
            public B pollingTrigger(PollingTriggerInterface pollingTrigger) {
                this.pollingTrigger = pollingTrigger;
                return this.self();
            }

            @Generated
            public B triggerContext(TriggerContext triggerContext) {
                this.triggerContext = triggerContext;
                return this.self();
            }

            @Generated
            public B conditionContext(ConditionContext conditionContext) {
                this.conditionContext = conditionContext;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AbstractScheduler.FlowWithPollingTrigger.FlowWithPollingTriggerBuilder(flow=" + this.flow + ", trigger=" + this.trigger + ", pollingTrigger=" + this.pollingTrigger + ", triggerContext=" + this.triggerContext + ", conditionContext=" + this.conditionContext + ")";
            }
        }

        @Generated
        private static final class FlowWithPollingTriggerBuilderImpl
        extends FlowWithPollingTriggerBuilder<FlowWithPollingTrigger, FlowWithPollingTriggerBuilderImpl> {
            @Generated
            private FlowWithPollingTriggerBuilderImpl() {
            }

            @Override
            @Generated
            protected FlowWithPollingTriggerBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public FlowWithPollingTrigger build() {
                return new FlowWithPollingTrigger(this);
            }
        }
    }

    public static class FlowWithPollingTriggerNextDate
    extends FlowWithPollingTrigger {
        private ZonedDateTime next;

        public static FlowWithPollingTriggerNextDate of(FlowWithPollingTrigger f, ZonedDateTime next) {
            return ((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)((FlowWithPollingTriggerNextDateBuilder)FlowWithPollingTriggerNextDate.builder().flow(f.getFlow())).trigger(f.getTrigger())).pollingTrigger(f.getPollingTrigger())).conditionContext(f.getConditionContext())).triggerContext((TriggerContext)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)((TriggerContext.TriggerContextBuilder)TriggerContext.builder().namespace(f.getTriggerContext().getNamespace())).flowId(f.getTriggerContext().getFlowId())).flowRevision(f.getTriggerContext().getFlowRevision())).triggerId(f.getTriggerContext().getTriggerId())).date(next)).build())).next(next)).build();
        }

        @Generated
        protected FlowWithPollingTriggerNextDate(FlowWithPollingTriggerNextDateBuilder<?, ?> b) {
            super(b);
            this.next = b.next;
        }

        @Generated
        public static FlowWithPollingTriggerNextDateBuilder<?, ?> builder() {
            return new FlowWithPollingTriggerNextDateBuilderImpl();
        }

        @Generated
        public ZonedDateTime getNext() {
            return this.next;
        }

        @Generated
        public FlowWithPollingTriggerNextDate() {
        }

        @Generated
        public static abstract class FlowWithPollingTriggerNextDateBuilder<C extends FlowWithPollingTriggerNextDate, B extends FlowWithPollingTriggerNextDateBuilder<C, B>>
        extends FlowWithPollingTrigger.FlowWithPollingTriggerBuilder<C, B> {
            @Generated
            private ZonedDateTime next;

            @Generated
            public B next(ZonedDateTime next) {
                this.next = next;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "AbstractScheduler.FlowWithPollingTriggerNextDate.FlowWithPollingTriggerNextDateBuilder(super=" + super.toString() + ", next=" + this.next + ")";
            }
        }

        @Generated
        private static final class FlowWithPollingTriggerNextDateBuilderImpl
        extends FlowWithPollingTriggerNextDateBuilder<FlowWithPollingTriggerNextDate, FlowWithPollingTriggerNextDateBuilderImpl> {
            @Generated
            private FlowWithPollingTriggerNextDateBuilderImpl() {
            }

            @Override
            @Generated
            protected FlowWithPollingTriggerNextDateBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public FlowWithPollingTriggerNextDate build() {
                return new FlowWithPollingTriggerNextDate(this);
            }
        }
    }

    private static class EvaluateFuture
    implements FutureCallback<SchedulerExecutionWithTrigger> {
        private final AbstractScheduler scheduler;
        private final FlowWithPollingTriggerNextDate flowWithPollingTriggerNextDate;

        public EvaluateFuture(AbstractScheduler scheduler, FlowWithPollingTriggerNextDate flowWithPollingTriggerNextDate) {
            this.scheduler = scheduler;
            this.flowWithPollingTriggerNextDate = flowWithPollingTriggerNextDate;
        }

        public void onSuccess(SchedulerExecutionWithTrigger result) {
            this.scheduler.removeFromRunning(this.flowWithPollingTriggerNextDate.getTriggerContext());
            this.scheduler.handleEvaluatePollingTriggerResult(result);
        }

        public void onFailure(Throwable e) {
            this.scheduler.removeFromRunning(this.flowWithPollingTriggerNextDate.getTriggerContext());
            AbstractScheduler.logError(this.flowWithPollingTriggerNextDate, e);
        }
    }

    public static class FlowWithTrigger {
        private final Flow flow;
        private final AbstractTrigger trigger;
        private final RunContext runContext;
        private final ConditionContext conditionContext;

        @ConstructorProperties(value={"flow", "trigger", "runContext", "conditionContext"})
        @Generated
        public FlowWithTrigger(Flow flow, AbstractTrigger trigger, RunContext runContext, ConditionContext conditionContext) {
            this.flow = flow;
            this.trigger = trigger;
            this.runContext = runContext;
            this.conditionContext = conditionContext;
        }

        @Generated
        public Flow getFlow() {
            return this.flow;
        }

        @Generated
        public AbstractTrigger getTrigger() {
            return this.trigger;
        }

        @Generated
        public RunContext getRunContext() {
            return this.runContext;
        }

        @Generated
        public ConditionContext getConditionContext() {
            return this.conditionContext;
        }
    }
}

