/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.schedulers;

import io.kestra.core.models.triggers.Trigger;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.schedulers.AbstractScheduler;
import io.kestra.core.schedulers.SchedulerExecutionStateInterface;
import io.kestra.core.schedulers.SchedulerTriggerStateInterface;
import io.kestra.core.services.FlowListenersInterface;
import io.micronaut.context.ApplicationContext;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultScheduler
extends AbstractScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultScheduler.class);
    private final Map<String, Trigger> watchingTrigger = new ConcurrentHashMap<String, Trigger>();

    @Inject
    public DefaultScheduler(ApplicationContext applicationContext, FlowListenersInterface flowListeners, SchedulerExecutionStateInterface executionState, SchedulerTriggerStateInterface triggerState) {
        super(applicationContext, flowListeners);
        this.triggerState = triggerState;
        this.executionState = executionState;
        this.isReady = true;
    }

    @Override
    public void run() {
        this.flowListeners.run();
        QueueInterface executionQueue = (QueueInterface)this.applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"executionQueue"));
        QueueInterface triggerQueue = (QueueInterface)this.applicationContext.getBean(QueueInterface.class, Qualifiers.byName((String)"triggerQueue"));
        executionQueue.receive(execution -> {
            if (execution.getState().getCurrent().isTerminated() && this.watchingTrigger.containsKey(execution.getId())) {
                Trigger trigger = this.watchingTrigger.get(execution.getId());
                triggerQueue.emit(trigger.resetExecution());
                this.triggerState.save(trigger.resetExecution());
            }
        });
        triggerQueue.receive(trigger -> {
            if (trigger != null && trigger.getExecutionId() != null) {
                this.watchingTrigger.put(trigger.getExecutionId(), (Trigger)trigger);
            }
        });
        super.run();
    }
}

