/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import java.lang.reflect.Field;

public class BeanSerializerFactoryWithGlobalIncludeDefaults
extends BeanSerializerFactory {
    private static final long serialVersionUID = 1L;
    private static final String REFLECTION_EXCEPTION_MESSAGE = "Failed to adjust " + PropertyBuilder.class + ". This workaround is probably incompatible with Jackson " + PackageVersion.VERSION;
    private final Field defaultInclusionField;
    private final Field useRealPropertyDefaultsField;

    BeanSerializerFactoryWithGlobalIncludeDefaults() {
        this(null);
    }

    private BeanSerializerFactoryWithGlobalIncludeDefaults(SerializerFactoryConfig config) {
        super(config);
        try {
            this.defaultInclusionField = PropertyBuilder.class.getDeclaredField("_defaultInclusion");
            this.defaultInclusionField.setAccessible(true);
            this.useRealPropertyDefaultsField = PropertyBuilder.class.getDeclaredField("_useRealPropertyDefaults");
            this.useRealPropertyDefaultsField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(REFLECTION_EXCEPTION_MESSAGE, e);
        }
    }

    public SerializerFactory withConfig(SerializerFactoryConfig config) {
        if (this._factoryConfig == config) {
            return this;
        }
        return new BeanSerializerFactoryWithGlobalIncludeDefaults(config);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig config, BeanDescription beanDesc) {
        PropertyBuilder propertyBuilder = super.constructPropertyBuilder(config, beanDesc);
        try {
            this.adjustUseRealPropertyDefaults(propertyBuilder);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(REFLECTION_EXCEPTION_MESSAGE, e);
        }
        return propertyBuilder;
    }

    private void adjustUseRealPropertyDefaults(PropertyBuilder propertyBuilder) throws ReflectiveOperationException {
        JsonInclude.Value defaultInclusion = (JsonInclude.Value)this.defaultInclusionField.get(propertyBuilder);
        boolean useRealPropertyDefaults = defaultInclusion.getValueInclusion() == JsonInclude.Include.NON_DEFAULT;
        this.useRealPropertyDefaultsField.setBoolean(propertyBuilder, useRealPropertyDefaults);
    }
}

