/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers.ion;

import com.amazon.ion.IonWriter;
import com.amazon.ion.Timestamp;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.io.IOContext;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;

public class IonGenerator
extends com.fasterxml.jackson.dataformat.ion.IonGenerator {
    public IonGenerator(int jsonFeatures, int ionFeatures, ObjectCodec codec, IonWriter ion, boolean ionWriterIsManaged, IOContext ctxt, Closeable dst) {
        super(jsonFeatures, ionFeatures, codec, ion, ionWriterIsManaged, ctxt, dst);
    }

    public void writeString(Object value, String serialized) throws IOException {
        this._verifyValueWrite("write " + value.getClass().getName() + " value");
        this._writer.addTypeAnnotation(value.getClass().getSimpleName());
        this._writer.writeString(serialized);
    }

    public void writeDate(Instant value) throws IOException {
        this._verifyValueWrite("write LocalDateTime value");
        this._writer.writeTimestamp(Timestamp.forDateZ((Date)Date.from(value)));
    }

    public void writeDate(LocalDate value) throws IOException {
        this._verifyValueWrite("write LocalDate value");
        this._writer.writeTimestamp(Timestamp.forDay((int)value.getYear(), (int)value.getMonth().getValue(), (int)value.getDayOfMonth()));
    }
}

