/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.executions;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.TruthUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@Schema(title="Fail the execution", description="Used to fail the execution for example on a switch branch or on some conditions based on the execution context.")
@Plugin(examples={@Example(title="Fail on a switch branch", full=true, code={"id: fail-on-switch\nnamespace: io.kestra.tests\n\ninputs:\n  - name: param\n    type: STRING\n    required: true\n\ntasks:\n  - id: switch\n    type: io.kestra.core.tasks.flows.Switch\n    value: \"{{inputs.param}}\"\n    cases:\n      case1:\n        - id: case1\n          type: io.kestra.core.tasks.log.Log\n          message: Case 1\n      case2:\n        - id: case2\n          type: io.kestra.core.tasks.log.Log\n          message: Case 2\n      notexist:\n        - id: fail\n          type: io.kestra.core.tasks.executions.Fail\n      default:\n        - id: default\n          type: io.kestra.core.tasks.log.Log\n          message: default"}), @Example(title="Fail on a condition", full=true, code={"id: fail-on-condition\nnamespace: io.kestra.tests\n\ninputs:\n  - name: param\n    type: STRING\n    required: true\n\ntasks:\n  - id: before\n    type: io.kestra.core.tasks.debugs.Echo\n    format: I'm before the fail on condition \n  - id: fail\n    type: io.kestra.core.tasks.executions.Fail\n    condition: '{{inputs.param == \"fail\"}}'\n  - id: after\n    type: io.kestra.core.tasks.debugs.Echo\n    format: I'm after the fail on condition "})})
public class Fail
extends Task
implements RunnableTask<VoidOutput> {
    @PluginProperty(dynamic=true)
    @Schema(title="Optional condition, must coerce to a boolean.", description="Boolean coercion allows 0, -0, and '' to coerce to false, all other values to coerce to true.")
    private String condition;
    @PluginProperty(dynamic=true)
    @Schema(title="Optional error message.")
    private String errorMessage;

    @Override
    public VoidOutput run(RunContext runContext) throws Exception {
        if (this.condition != null) {
            String rendered = runContext.render(this.condition);
            if (TruthUtils.isTruthy(rendered)) {
                runContext.logger().error(runContext.render(this.errorMessage));
                throw new RuntimeException("Fail on a condition");
            }
            return null;
        }
        runContext.logger().error(runContext.render(this.errorMessage));
        throw new RuntimeException("Fail always");
    }

    @Generated
    private static String $default$errorMessage() {
        return "Task failure";
    }

    @Generated
    protected Fail(FailBuilder<?, ?> b) {
        super(b);
        this.condition = b.condition;
        this.errorMessage = b.errorMessage$set ? b.errorMessage$value : Fail.$default$errorMessage();
    }

    @Generated
    public static FailBuilder<?, ?> builder() {
        return new FailBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Fail(super=" + super.toString() + ", condition=" + this.getCondition() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fail)) {
            return false;
        }
        Fail other = (Fail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Fail;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @Generated
    public String getCondition() {
        return this.condition;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public Fail() {
        this.errorMessage = Fail.$default$errorMessage();
    }

    @Generated
    public static abstract class FailBuilder<C extends Fail, B extends FailBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String condition;
        @Generated
        private boolean errorMessage$set;
        @Generated
        private String errorMessage$value;

        @Generated
        public B condition(String condition) {
            this.condition = condition;
            return (B)this.self();
        }

        @Generated
        public B errorMessage(String errorMessage) {
            this.errorMessage$value = errorMessage;
            this.errorMessage$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Fail.FailBuilder(super=" + super.toString() + ", condition=" + this.condition + ", errorMessage$value=" + this.errorMessage$value + ")";
        }
    }

    @Generated
    private static final class FailBuilderImpl
    extends FailBuilder<Fail, FailBuilderImpl> {
        @Generated
        private FailBuilderImpl() {
        }

        @Override
        @Generated
        protected FailBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Fail build() {
            return new Fail(this);
        }
    }
}

