/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FlowExecutorInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.RunnerUtils;
import io.kestra.core.runners.WorkerTaskExecution;
import io.kestra.core.runners.WorkerTaskResult;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Trigger another flow")
@Plugin(examples={@Example(title="Trigger another flow, passing some files and arguments as inputs", code={"namespace: io.kestra.tests", "flowId: my-sub-flows", "inputs:", "  file: \"{{ outputs.myTask.outputFiles.resolver }}\"", "  store: 12", "wait: false"})})
public class Flow
extends Task
implements RunnableTask<Output> {
    @NotNull
    @Schema(title="The namespace of the flow to trigger")
    @PluginProperty(dynamic=true)
    private String namespace;
    @NotNull
    @Schema(title="The identifier of the flow to trigger")
    @PluginProperty(dynamic=true)
    private String flowId;
    @Schema(title="The revision of the flow to trigger", description="By default, we trigger the last version.")
    @PluginProperty(dynamic=true)
    private Integer revision;
    @Schema(title="The input to pass to the triggered flow")
    @PluginProperty(dynamic=true)
    private Map<String, String> inputs;
    @Schema(title="Wait the end of the execution.", description="By default, we don't wait till the end of the flow, if you set to true, we wait the end of the trigger flow before continue this one.")
    @PluginProperty
    private final Boolean wait;
    @Schema(title="Failed the current execution if the waited execution is failed or killed.", description="`wait` need to be true to make it work")
    @PluginProperty
    private final Boolean transmitFailed;
    @Schema(title="Extract outputs from triggered executions.", description="Allow to specify key value (with value rendered), in order to extract any outputs from triggered execution.")
    @PluginProperty(dynamic=true)
    private Map<String, Object> outputs;

    @Override
    public Output run(RunContext runContext) throws Exception {
        throw new IllegalStateException("This task must not be run by a worker and must be run on executor side!");
    }

    public Execution createExecution(RunContext runContext, FlowExecutorInterface flowExecutorInterface) throws Exception {
        RunnerUtils runnerUtils = (RunnerUtils)runContext.getApplicationContext().getBean(RunnerUtils.class);
        HashMap<String, String> inputs = new HashMap<String, String>();
        if (this.inputs != null) {
            for (Map.Entry<String, String> entry : this.inputs.entrySet()) {
                inputs.put(entry.getKey(), runContext.render(entry.getValue()));
            }
        }
        Map flowVars = (Map)runContext.getVariables().get("flow");
        io.kestra.core.models.flows.Flow flow = flowExecutorInterface.findByIdFromFlowTask(runContext.render(this.namespace), runContext.render(this.flowId), this.revision != null ? Optional.of(this.revision) : Optional.empty(), (String)flowVars.get("namespace"), (String)flowVars.get("id")).orElseThrow(() -> new IllegalStateException("Unable to find flow '" + this.namespace + "." + this.id + "' with revision + '" + this.revision + "'"));
        if (flow.isDisabled()) {
            throw new IllegalStateException("Cannot execute disabled flow");
        }
        return runnerUtils.newExecution(flow, (f, e) -> runnerUtils.typedInputs((io.kestra.core.models.flows.Flow)f, (Execution)e, (Map<String, String>)inputs)).withTrigger(ExecutionTrigger.builder().id(this.getId()).type(this.getType()).variables((Map<String, Object>)ImmutableMap.of((Object)"executionId", ((Map)runContext.getVariables().get("execution")).get("id"), (Object)"namespace", flowVars.get("namespace"), (Object)"flowId", flowVars.get("id"), (Object)"flowRevision", flowVars.get("revision"))).build());
    }

    public WorkerTaskResult createWorkerTaskResult(@Nullable RunContextFactory runContextFactory, WorkerTaskExecution workerTaskExecution, @Nullable io.kestra.core.models.flows.Flow flow, Execution execution) {
        TaskRun taskRun = workerTaskExecution.getTaskRun();
        Output.OutputBuilder builder = Output.builder().executionId(execution.getId());
        if (workerTaskExecution.getTask().getOutputs() != null && runContextFactory != null) {
            RunContext runContext = runContextFactory.of(flow, workerTaskExecution.getTask(), execution, workerTaskExecution.getTaskRun());
            try {
                builder.outputs(runContext.render(workerTaskExecution.getTask().getOutputs()));
            }
            catch (Exception e) {
                runContext.logger().warn("Failed to extract ouputs with error: '" + e.getMessage() + "'", (Throwable)e);
                taskRun = taskRun.withState(State.Type.FAILED).withOutputs(builder.build().toMap());
                return WorkerTaskResult.builder().taskRun(taskRun).build();
            }
        }
        builder.state(execution.getState().getCurrent());
        taskRun = taskRun.withOutputs(builder.build().toMap());
        taskRun = this.transmitFailed != false && (execution.getState().isFailed() || execution.getState().isPaused() || execution.getState().getCurrent() == State.Type.KILLED || execution.getState().getCurrent() == State.Type.WARNING) ? taskRun.withState(execution.getState().getCurrent()) : taskRun.withState(State.Type.SUCCESS);
        return WorkerTaskResult.builder().taskRun(taskRun).build();
    }

    @Generated
    private static Boolean $default$wait() {
        return false;
    }

    @Generated
    private static Boolean $default$transmitFailed() {
        return false;
    }

    @Generated
    protected Flow(FlowBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.revision = b.revision;
        this.inputs = b.inputs;
        this.wait = b.wait$set ? b.wait$value : Flow.$default$wait();
        this.transmitFailed = b.transmitFailed$set ? b.transmitFailed$value : Flow.$default$transmitFailed();
        this.outputs = b.outputs;
    }

    @Generated
    public static FlowBuilder<?, ?> builder() {
        return new FlowBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Flow(super=" + super.toString() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", revision=" + this.getRevision() + ", inputs=" + this.getInputs() + ", wait=" + this.getWait() + ", transmitFailed=" + this.getTransmitFailed() + ", outputs=" + this.getOutputs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$revision = this.getRevision();
        Integer other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !((Object)this$revision).equals(other$revision)) {
            return false;
        }
        Boolean this$wait = this.getWait();
        Boolean other$wait = other.getWait();
        if (this$wait == null ? other$wait != null : !((Object)this$wait).equals(other$wait)) {
            return false;
        }
        Boolean this$transmitFailed = this.getTransmitFailed();
        Boolean other$transmitFailed = other.getTransmitFailed();
        if (this$transmitFailed == null ? other$transmitFailed != null : !((Object)this$transmitFailed).equals(other$transmitFailed)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        Map<String, String> this$inputs = this.getInputs();
        Map<String, String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, Object> this$outputs = this.getOutputs();
        Map<String, Object> other$outputs = other.getOutputs();
        return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : ((Object)$revision).hashCode());
        Boolean $wait = this.getWait();
        result = result * 59 + ($wait == null ? 43 : ((Object)$wait).hashCode());
        Boolean $transmitFailed = this.getTransmitFailed();
        result = result * 59 + ($transmitFailed == null ? 43 : ((Object)$transmitFailed).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        Map<String, String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, Object> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        return result;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public Integer getRevision() {
        return this.revision;
    }

    @Generated
    public Map<String, String> getInputs() {
        return this.inputs;
    }

    @Generated
    public Boolean getWait() {
        return this.wait;
    }

    @Generated
    public Boolean getTransmitFailed() {
        return this.transmitFailed;
    }

    @Generated
    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Flow() {
        this.wait = Flow.$default$wait();
        this.transmitFailed = Flow.$default$transmitFailed();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The id of the execution trigger.")
        private final String executionId;
        @Schema(title="The state of the execution trigger.", description="Only available if the execution is waited with `wait` options")
        private final State.Type state;
        @Schema(title="The extracted outputs from triggered executions.")
        private final Map<String, Object> outputs;

        @ConstructorProperties(value={"executionId", "state", "outputs"})
        @Generated
        Output(String executionId, State.Type state, Map<String, Object> outputs) {
            this.executionId = executionId;
            this.state = state;
            this.outputs = outputs;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getExecutionId() {
            return this.executionId;
        }

        @Generated
        public State.Type getState() {
            return this.state;
        }

        @Generated
        public Map<String, Object> getOutputs() {
            return this.outputs;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String executionId;
            @Generated
            private State.Type state;
            @Generated
            private Map<String, Object> outputs;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder executionId(String executionId) {
                this.executionId = executionId;
                return this;
            }

            @Generated
            public OutputBuilder state(State.Type state) {
                this.state = state;
                return this;
            }

            @Generated
            public OutputBuilder outputs(Map<String, Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.executionId, this.state, this.outputs);
            }

            @Generated
            public String toString() {
                return "Flow.Output.OutputBuilder(executionId=" + this.executionId + ", state=" + this.state + ", outputs=" + this.outputs + ")";
            }
        }
    }

    @Generated
    public static abstract class FlowBuilder<C extends Flow, B extends FlowBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Integer revision;
        @Generated
        private Map<String, String> inputs;
        @Generated
        private boolean wait$set;
        @Generated
        private Boolean wait$value;
        @Generated
        private boolean transmitFailed$set;
        @Generated
        private Boolean transmitFailed$value;
        @Generated
        private Map<String, Object> outputs;

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B revision(Integer revision) {
            this.revision = revision;
            return (B)this.self();
        }

        @Generated
        public B inputs(Map<String, String> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B wait(Boolean wait) {
            this.wait$value = wait;
            this.wait$set = true;
            return (B)this.self();
        }

        @Generated
        public B transmitFailed(Boolean transmitFailed) {
            this.transmitFailed$value = transmitFailed;
            this.transmitFailed$set = true;
            return (B)this.self();
        }

        @Generated
        public B outputs(Map<String, Object> outputs) {
            this.outputs = outputs;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Flow.FlowBuilder(super=" + super.toString() + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", revision=" + this.revision + ", inputs=" + this.inputs + ", wait$value=" + this.wait$value + ", transmitFailed$value=" + this.transmitFailed$value + ", outputs=" + this.outputs + ")";
        }
    }

    @Generated
    private static final class FlowBuilderImpl
    extends FlowBuilder<Flow, FlowBuilderImpl> {
        @Generated
        private FlowBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Flow build() {
            return new Flow(this);
        }
    }
}

