/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.repositories.TemplateRepositoryInterface;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.GraphService;
import io.kestra.core.utils.Rethrow;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.runtime.event.annotation.EventListener;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Include a reusable template inside a flow")
@Plugin(examples={@Example(full=true, code={"id: template", "namespace: io.kestra.tests", "", "inputs:", "  - name: with-string", "    type: STRING", "", "tasks:", "  - id: 1-return", "    type: io.kestra.core.tasks.debugs.Return", "    format: \"{{task.id}} > {{taskrun.startDate}}\"", "  - id: 2-template", "    type: io.kestra.core.tasks.flows.Template", "    namespace: io.kestra.tests", "    templateId: template", "    args:", "      my-forward: \"{{ inputs.with-string }}\"", "  - id: 3-end", "    type: io.kestra.core.tasks.debugs.Return", "    format: \"{{task.id}} > {{taskrun.startDate}}\"\n"})})
public class Template
extends Task
implements FlowableTask<Output> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Template.class);
    @Valid
    @PluginProperty
    protected List<Task> errors;
    @NotNull
    @Schema(title="The namespace of the template")
    @PluginProperty
    private String namespace;
    @NotNull
    @Schema(title="The id of the template")
    @PluginProperty
    private String templateId;
    @Schema(title="The args to pass to the template", description="You can provide a list of named arguments (like function argument on dev) allowing to rename outputs of current flow for this template.\nfor example, if you declare this use of template like this: \n```yaml\n  - id: 2-template\n    type: io.kestra.core.tasks.flows.Template\n    namespace: io.kestra.tests\n    templateId: template\n    args:\n      forward: \"{{ output.task-id.uri }}\"\n```\nYou will be able to get this output on the template with `{{ parent.outputs.args.forward }}`")
    @PluginProperty(dynamic=true, additionalProperties=String.class)
    private Map<String, String> args;

    @Override
    public GraphCluster tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.SEQUENTIAL);
        io.kestra.core.models.templates.Template template = this.findTemplate(ContextHelper.context());
        GraphService.sequential(subGraph, template.getTasks(), template.getErrors(), taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        try {
            io.kestra.core.models.templates.Template template = this.findTemplate(ContextHelper.context());
            return Stream.concat(template.getTasks() != null ? template.getTasks().stream() : Stream.empty(), template.getErrors() != null ? template.getErrors().stream() : Stream.empty()).collect(Collectors.toList());
        }
        catch (IllegalVariableEvaluationException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        io.kestra.core.models.templates.Template template = this.findTemplate(ContextHelper.context());
        return FlowableUtils.resolveTasks(template.getTasks(), parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        io.kestra.core.models.templates.Template template = this.findTemplate(ContextHelper.context());
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(template.getErrors(), parentTaskRun), parentTaskRun);
    }

    @Override
    public Output outputs(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        Output.OutputBuilder builder = Output.builder();
        if (this.args != null) {
            builder.args(runContext.render(this.args.entrySet().stream().map(Rethrow.throwFunction(e -> new AbstractMap.SimpleEntry<String, String>((String)e.getKey(), runContext.render((String)e.getValue())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        }
        return builder.build();
    }

    protected io.kestra.core.models.templates.Template findTemplate(ApplicationContext applicationContext) throws IllegalVariableEvaluationException {
        TemplateExecutorInterface templateExecutor = (TemplateExecutorInterface)applicationContext.getBean(TemplateExecutorInterface.class);
        return templateExecutor.findById(this.namespace, this.templateId).orElseThrow(() -> new IllegalVariableEvaluationException("Can't find flow template '" + this.namespace + "." + this.templateId + "'"));
    }

    public static Flow injectTemplate(Flow flow, Execution execution, BiFunction<String, String, io.kestra.core.models.templates.Template> provider) throws InternalException {
        AtomicReference<Flow> flowReference = new AtomicReference<Flow>(flow);
        boolean haveTemplate = true;
        while (haveTemplate) {
            List<Template> templates = flowReference.get().allTasks().filter(task -> task instanceof Template).map(task -> (Template)task).filter(t -> !(t instanceof ExecutorTemplate)).collect(Collectors.toList());
            templates.forEach(Rethrow.throwConsumer(templateTask -> {
                io.kestra.core.models.templates.Template template = (io.kestra.core.models.templates.Template)provider.apply(templateTask.getNamespace(), templateTask.getTemplateId());
                if (template == null) {
                    throw new InternalException("Unable to find template '" + templateTask.getNamespace() + "." + templateTask.getTemplateId() + "'");
                }
                flowReference.set(((Flow)flowReference.get()).updateTask(templateTask.getId(), ExecutorTemplate.of(templateTask, template)));
            }));
            haveTemplate = templates.size() > 0;
        }
        return flowReference.get();
    }

    @Generated
    protected Template(TemplateBuilder<?, ?> b) {
        super(b);
        this.errors = b.errors;
        this.namespace = b.namespace;
        this.templateId = b.templateId;
        this.args = b.args;
    }

    @Generated
    public static TemplateBuilder<?, ?> builder() {
        return new TemplateBuilderImpl();
    }

    @Generated
    public TemplateBuilder<?, ?> toBuilder() {
        return new TemplateBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String toString() {
        return "Template(super=" + super.toString() + ", errors=" + this.getErrors() + ", namespace=" + this.getNamespace() + ", templateId=" + this.getTemplateId() + ", args=" + this.getArgs() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        Map<String, String> this$args = this.getArgs();
        Map<String, String> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        Map<String, String> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getTemplateId() {
        return this.templateId;
    }

    @Generated
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Generated
    public Template() {
    }

    @Singleton
    public static class ContextHelper {
        @Inject
        private ApplicationContext applicationContext;
        private static ApplicationContext context;

        public static ApplicationContext context() {
            return context;
        }

        @EventListener
        void onStartup(StartupEvent event) {
            context = this.applicationContext;
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The args passed to the template")
        private final Map<String, Object> args;

        @ConstructorProperties(value={"args"})
        @Generated
        Output(Map<String, Object> args) {
            this.args = args;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Map<String, Object> getArgs() {
            return this.args;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Map<String, Object> args;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder args(Map<String, Object> args) {
                this.args = args;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.args);
            }

            @Generated
            public String toString() {
                return "Template.Output.OutputBuilder(args=" + this.args + ")";
            }
        }
    }

    public static interface TemplateExecutorInterface {
        public Optional<io.kestra.core.models.templates.Template> findById(String var1, String var2);
    }

    @Generated
    public static abstract class TemplateBuilder<C extends Template, B extends TemplateBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private List<Task> errors;
        @Generated
        private String namespace;
        @Generated
        private String templateId;
        @Generated
        private Map<String, String> args;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TemplateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Template instance, TemplateBuilder<?, ?> b) {
            b.errors(instance.errors);
            b.namespace(instance.namespace);
            b.templateId(instance.templateId);
            b.args(instance.args);
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B templateId(String templateId) {
            this.templateId = templateId;
            return (B)this.self();
        }

        @Generated
        public B args(Map<String, String> args) {
            this.args = args;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Template.TemplateBuilder(super=" + super.toString() + ", errors=" + this.errors + ", namespace=" + this.namespace + ", templateId=" + this.templateId + ", args=" + this.args + ")";
        }
    }

    @Generated
    private static final class TemplateBuilderImpl
    extends TemplateBuilder<Template, TemplateBuilderImpl> {
        @Generated
        private TemplateBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Template build() {
            return new Template(this);
        }
    }

    @Hidden
    public static class ExecutorTemplate
    extends Template {
        private io.kestra.core.models.templates.Template template;

        @Override
        protected io.kestra.core.models.templates.Template findTemplate(ApplicationContext applicationContext) throws IllegalVariableEvaluationException {
            return this.template;
        }

        public static ExecutorTemplate of(Template templateTask, io.kestra.core.models.templates.Template template) {
            Map<String, Object> map = JacksonMapper.toMap(templateTask);
            map.put("type", ExecutorTemplate.class.getName());
            ExecutorTemplate executorTemplate = JacksonMapper.toMap(map, ExecutorTemplate.class);
            executorTemplate.template = template;
            return executorTemplate;
        }

        @Generated
        protected ExecutorTemplate(ExecutorTemplateBuilder<?, ?> b) {
            super((TemplateBuilder<?, ?>)b);
            this.template = b.template;
        }

        @Generated
        public static ExecutorTemplateBuilder<?, ?> builder() {
            return new ExecutorTemplateBuilderImpl();
        }

        @Generated
        public ExecutorTemplateBuilder<?, ?> toBuilder() {
            return new ExecutorTemplateBuilderImpl().$fillValuesFrom(this);
        }

        @Override
        @Generated
        public String toString() {
            return "Template.ExecutorTemplate(super=" + super.toString() + ", template=" + this.getTemplate() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecutorTemplate)) {
                return false;
            }
            ExecutorTemplate other = (ExecutorTemplate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            io.kestra.core.models.templates.Template this$template = this.getTemplate();
            io.kestra.core.models.templates.Template other$template = other.getTemplate();
            return !(this$template == null ? other$template != null : !((Object)this$template).equals(other$template));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExecutorTemplate;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            io.kestra.core.models.templates.Template $template = this.getTemplate();
            result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
            return result;
        }

        @Generated
        public io.kestra.core.models.templates.Template getTemplate() {
            return this.template;
        }

        @Generated
        public ExecutorTemplate() {
        }

        @ConstructorProperties(value={"template"})
        @Generated
        public ExecutorTemplate(io.kestra.core.models.templates.Template template) {
            this.template = template;
        }

        @Generated
        public static abstract class ExecutorTemplateBuilder<C extends ExecutorTemplate, B extends ExecutorTemplateBuilder<C, B>>
        extends TemplateBuilder<C, B> {
            @Generated
            private io.kestra.core.models.templates.Template template;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                ExecutorTemplateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(ExecutorTemplate instance, ExecutorTemplateBuilder<?, ?> b) {
                b.template(instance.template);
            }

            @Generated
            public B template(io.kestra.core.models.templates.Template template) {
                this.template = template;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "Template.ExecutorTemplate.ExecutorTemplateBuilder(super=" + super.toString() + ", template=" + this.template + ")";
            }
        }

        @Generated
        private static final class ExecutorTemplateBuilderImpl
        extends ExecutorTemplateBuilder<ExecutorTemplate, ExecutorTemplateBuilderImpl> {
            @Generated
            private ExecutorTemplateBuilderImpl() {
            }

            @Override
            @Generated
            protected ExecutorTemplateBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ExecutorTemplate build() {
                return new ExecutorTemplate(this);
            }
        }
    }

    public static class MemoryTemplateExecutor
    implements TemplateExecutorInterface {
        @Inject
        private TemplateRepositoryInterface templateRepository;

        @Override
        public Optional<io.kestra.core.models.templates.Template> findById(String namespace, String templateId) {
            return this.templateRepository.findById(namespace, templateId);
        }
    }
}

