/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.flows;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.DynamicTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.tasks.flows.Sequential;
import io.kestra.core.utils.IdUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Schema(title="Run tasks sequentially sharing the same filesystem", description="By default, Kestra will launch each task on a fresh filesystem and on a new worker instance.\nThis task will run sequentially keeping the same filesystem allowing reuse previous task file on next tasks andkeep tracking of execution time for each task. This task is mostly useful when working with large filesystem operation.")
@Plugin(examples={@Example(full=true, code={"id: worker", "namespace: io.kestra.tests", "", "tasks:", "  - id: worker", "    type: io.kestra.core.tasks.flows.Worker", "    tasks:", "      - id: first", "        type: io.kestra.core.tasks.scripts.Bash", "        commands:", "        - 'echo \"{{ taskrun.id }}\" > {{ workingDir }}/stay.txt'", "      - id: second", "        type: io.kestra.core.tasks.scripts.Bash", "        commands:", "        - |", "          echo '::{\"outputs\": {\"stay\":\"'$(cat {{ workingDir }}/stay.txt)'\"}}::'"})})
public class Worker
extends Sequential
implements DynamicTask {
    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = this.childTasks(runContext, parentTaskRun);
        if (execution.hasFailed(childTasks, parentTaskRun)) {
            return super.resolveNexts(runContext, execution, parentTaskRun);
        }
        return new ArrayList<NextTaskRun>();
    }

    public WorkerTask workerTask(TaskRun parent, Task task, RunContext runContext) {
        return WorkerTask.builder().task(task).taskRun(TaskRun.builder().id(IdUtils.create()).executionId(parent.getExecutionId()).namespace(parent.getNamespace()).flowId(parent.getFlowId()).taskId(task.getId()).parentTaskRunId(parent.getId()).state(new State()).build()).runContext(runContext).build();
    }

    @Generated
    protected Worker(WorkerBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder)b);
    }

    @Generated
    public static WorkerBuilder<?, ?> builder() {
        return new WorkerBuilderImpl();
    }

    @Generated
    public WorkerBuilder<?, ?> toBuilder() {
        return new WorkerBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String toString() {
        return "Worker(super=" + super.toString() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Worker)) {
            return false;
        }
        Worker other = (Worker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Worker;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Worker() {
    }

    @Generated
    private static final class WorkerBuilderImpl
    extends WorkerBuilder<Worker, WorkerBuilderImpl> {
        @Generated
        private WorkerBuilderImpl() {
        }

        @Override
        @Generated
        protected WorkerBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Worker build() {
            return new Worker(this);
        }
    }

    @Generated
    public static abstract class WorkerBuilder<C extends Worker, B extends WorkerBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            WorkerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Worker instance, WorkerBuilder<?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Worker.WorkerBuilder(super=" + super.toString() + ")";
        }
    }
}

