/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.scripts.AbstractBash;
import io.kestra.core.tasks.scripts.ScriptOutput;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@Schema(title="Execute a Bash script, command or set of commands.")
@Plugin(examples={@Example(title="Single bash command", code={"commands:", "- 'echo \"The current execution is : {{execution.id}}\"'"}), @Example(title="Bash command that generate file in storage accessible through outputs", code={"outputFiles:", "- first", "- second", "commands:", "- echo \"1\" >> {{ outputFiles.first }}", "- echo \"2\" >> {{ outputFiles.second }}"}), @Example(title="Bash with some inputs files", code={"inputFiles:", "  script.sh: |", "    echo {{ workingDir }}", "commands:", "- /bin/bash script.sh"}), @Example(title="Bash with an input file from Kestra's local storage created by a previous task.", code={"inputFiles:", "  data.csv: {{outputs.previousTaskId.uri}}", "commands:", "  - cat data.csv"}), @Example(title="Run a command on a docker image", code={"runner: DOCKER", "dockerOptions:", "  image: php", "commands:", "- 'php -r 'print(phpversion() . \"\\n\");'"}), @Example(title="Execute cmd on windows", code={"commands:", "  - 'echo \"The current execution is : {{execution.id}}\"'", "exitOnFailed: false", "interpreter: cmd", "interpreterArgs:", "  - /c"}), @Example(title="Set outputs from bash standard output", code={"commands:", "  - echo '::{\"outputs\":{\"test\":\"value\",\"int\":2,\"bool\":true,\"float\":3.65}}::'"}), @Example(title="Send a counter metric from bash standard output", code={"commands:", "  - echo '::{\"metrics\":[{\"name\":\"count\",\"type\":\"counter\",\"value\":1,\"tags\":{\"tag1\":\"i\",\"tag2\":\"win\"}}]}::'"})})
public class Bash
extends AbstractBash
implements RunnableTask<ScriptOutput> {
    @Schema(title="The commands to run", description="Default command will be launched with `/bin/sh -c \"commands\"`")
    @PluginProperty(dynamic=true)
    @NotNull
    @NotEmpty
    protected String[] commands;

    @Override
    public ScriptOutput run(RunContext runContext) throws Exception {
        return this.run(runContext, Rethrow.throwSupplier(() -> {
            ArrayList<String> renderer = new ArrayList<String>();
            if (this.exitOnFailed.booleanValue()) {
                renderer.add("set -o errexit");
            }
            for (String command : this.commands) {
                renderer.add(runContext.render(command, (Map<String, Object>)this.additionalVars));
            }
            return String.join((CharSequence)"\n", renderer);
        }));
    }

    @Generated
    protected Bash(BashBuilder<?, ?> b) {
        super((AbstractBash.AbstractBashBuilder)b);
        this.commands = b.commands;
    }

    @Generated
    public static BashBuilder<?, ?> builder() {
        return new BashBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Bash(super=" + super.toString() + ", commands=" + Arrays.deepToString(this.getCommands()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bash)) {
            return false;
        }
        Bash other = (Bash)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getCommands(), other.getCommands());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bash;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getCommands());
        return result;
    }

    @Generated
    public String[] getCommands() {
        return this.commands;
    }

    @Generated
    public Bash() {
    }

    @Generated
    public static abstract class BashBuilder<C extends Bash, B extends BashBuilder<C, B>>
    extends AbstractBash.AbstractBashBuilder<C, B> {
        @Generated
        private String[] commands;

        @Generated
        public B commands(String[] commands) {
            this.commands = commands;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Bash.BashBuilder(super=" + super.toString() + ", commands=" + Arrays.deepToString(this.commands) + ")";
        }
    }

    @Generated
    private static final class BashBuilderImpl
    extends BashBuilder<Bash, BashBuilderImpl> {
        @Generated
        private BashBuilderImpl() {
        }

        @Override
        @Generated
        protected BashBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Bash build() {
            return new Bash(this);
        }
    }
}

