/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.tasks.scripts.AbstractBash;
import io.kestra.core.utils.Rethrow;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;

public abstract class BashService {
    protected static final ObjectMapper MAPPER = JacksonMapper.ofJson();
    private static final Pattern PATTERN = Pattern.compile("^::(\\{.*})::$");

    public static List<String> finalCommandsWithInterpreter(String interpreter, String[] interpreterArgs, String commandAsString, Path workingDirectory) throws IOException {
        ArrayList<String> commandsWithInterpreter = new ArrayList<String>(Collections.singletonList(interpreter));
        if (commandAsString.length() > 131072) {
            File bashTempFiles = File.createTempFile("bash", ".sh", workingDirectory.toFile());
            Files.write(bashTempFiles.toPath(), commandAsString.getBytes(), new OpenOption[0]);
            commandAsString = bashTempFiles.getAbsolutePath();
        } else {
            commandsWithInterpreter.addAll(Arrays.asList(interpreterArgs));
        }
        commandsWithInterpreter.add(commandAsString);
        return commandsWithInterpreter;
    }

    public static Map<String, String> createOutputFiles(Path tempDirectory, List<String> outputFiles, Map<String, Object> additionalVars) throws IOException {
        return BashService.createOutputFiles(tempDirectory, outputFiles, additionalVars, false);
    }

    public static Map<String, String> createOutputFiles(Path tempDirectory, List<String> outputFiles, Map<String, Object> additionalVars, Boolean isDir) throws IOException {
        ArrayList<String> outputs = new ArrayList<String>();
        if (outputFiles != null && outputFiles.size() > 0) {
            outputs.addAll(outputFiles);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (outputs.size() > 0) {
            outputs.forEach(Rethrow.throwConsumer(s -> {
                BashService.validFilename(s);
                File tempFile = isDir != false ? Files.createTempDirectory(tempDirectory, s + "_", new FileAttribute[0]).toFile() : File.createTempFile(s + "_", null, tempDirectory.toFile());
                result.put((String)s, "{{workingDir}}/" + tempFile.getName());
            }));
            if (!isDir.booleanValue()) {
                additionalVars.put("temp", result);
            }
            additionalVars.put(isDir != false ? "outputDirs" : "outputFiles", result);
        }
        return result;
    }

    private static void validFilename(String s) {
        if (s.startsWith("./") || s.startsWith("..") || s.startsWith("/")) {
            throw new IllegalArgumentException("Invalid outputFile (only relative path is supported) for path '" + s + "'");
        }
    }

    public static Map<String, String> transformInputFiles(RunContext runContext, @NotNull Object inputFiles) throws IllegalVariableEvaluationException, JsonProcessingException {
        if (inputFiles instanceof Map) {
            return (Map)inputFiles;
        }
        if (inputFiles instanceof String) {
            TypeReference<Map<String, String>> reference = new TypeReference<Map<String, String>>(){};
            return (Map)JacksonMapper.ofJson(false).readValue(runContext.render((String)inputFiles), (TypeReference)reference);
        }
        throw new IllegalVariableEvaluationException("Invalid `files` properties with type '" + (Serializable)(inputFiles != null ? inputFiles.getClass() : "null") + "'");
    }

    public static void createInputFiles(RunContext runContext, Path workingDirectory, Map<String, String> inputFiles, Map<String, Object> additionalVars) throws IOException, IllegalVariableEvaluationException, URISyntaxException {
        if (inputFiles != null && inputFiles.size() > 0) {
            for (String fileName : inputFiles.keySet()) {
                Path subFolder;
                String finalFileName = runContext.render(fileName);
                BashService.validFilename(finalFileName);
                File file = new File(fileName);
                if (file.getParent() != null && !(subFolder = Paths.get(workingDirectory.toAbsolutePath().toString(), new File(finalFileName).getParent())).toFile().exists()) {
                    Files.createDirectories(subFolder, new FileAttribute[0]);
                }
                String filePath = workingDirectory + "/" + finalFileName;
                String render = runContext.render(inputFiles.get(fileName), additionalVars);
                if (render.startsWith("kestra://")) {
                    InputStream inputStream = runContext.uriToInputStream(new URI(render));
                    try {
                        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(filePath));
                        try {
                            int byteRead;
                            while ((byteRead = inputStream.read()) != -1) {
                                ((OutputStream)outputStream).write(byteRead);
                            }
                            ((OutputStream)outputStream).flush();
                            continue;
                        }
                        finally {
                            ((OutputStream)outputStream).close();
                            continue;
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        continue;
                    }
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                    writer.write(render);
                }
            }
        }
    }

    public static Map<String, Object> parseOut(String line, Logger logger, RunContext runContext) {
        Matcher m = PATTERN.matcher(line);
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        if (m.find()) {
            try {
                AbstractBash.BashCommand bashCommand = (AbstractBash.BashCommand)MAPPER.readValue(m.group(1), AbstractBash.BashCommand.class);
                if (bashCommand.getOutputs() != null) {
                    outputs.putAll(bashCommand.getOutputs());
                }
                if (bashCommand.getMetrics() != null) {
                    bashCommand.getMetrics().forEach(runContext::metric);
                }
            }
            catch (JsonProcessingException e) {
                logger.warn("Invalid outputs '{}'", (Object)e.getMessage(), (Object)e);
            }
        }
        return outputs;
    }
}

