/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Output;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class ScriptOutput
implements Output {
    @Schema(title="The value extract from output of the commands")
    private final Map<String, Object> vars;
    @Schema(title="The standard output line count")
    private final int stdOutLineCount;
    @Schema(title="The standard error line count")
    private final int stdErrLineCount;
    @Schema(title="The exit code of the whole execution")
    @NotNull
    private final int exitCode;
    @Schema(title="Deprecated output files", description="use `outputFiles`", deprecated=true)
    @Deprecated
    @PluginProperty(additionalProperties=URI.class)
    private final Map<String, URI> files;
    @Schema(title="The output files uri in Kestra internal storage")
    @PluginProperty(additionalProperties=URI.class)
    private final Map<String, URI> outputFiles;
    @JsonIgnore
    private Boolean warningOnStdErr;

    @Override
    public Optional<State.Type> finalState() {
        return this.warningOnStdErr != null && this.warningOnStdErr != false && this.stdErrLineCount > 0 ? Optional.of(State.Type.WARNING) : Output.super.finalState();
    }

    @ConstructorProperties(value={"vars", "stdOutLineCount", "stdErrLineCount", "exitCode", "files", "outputFiles", "warningOnStdErr"})
    @Generated
    ScriptOutput(Map<String, Object> vars, int stdOutLineCount, int stdErrLineCount, int exitCode, Map<String, URI> files, Map<String, URI> outputFiles, Boolean warningOnStdErr) {
        this.vars = vars;
        this.stdOutLineCount = stdOutLineCount;
        this.stdErrLineCount = stdErrLineCount;
        this.exitCode = exitCode;
        this.files = files;
        this.outputFiles = outputFiles;
        this.warningOnStdErr = warningOnStdErr;
    }

    @Generated
    public static ScriptOutputBuilder builder() {
        return new ScriptOutputBuilder();
    }

    @Generated
    public Map<String, Object> getVars() {
        return this.vars;
    }

    @Generated
    public int getStdOutLineCount() {
        return this.stdOutLineCount;
    }

    @Generated
    public int getStdErrLineCount() {
        return this.stdErrLineCount;
    }

    @Generated
    public int getExitCode() {
        return this.exitCode;
    }

    @Deprecated
    @Generated
    public Map<String, URI> getFiles() {
        return this.files;
    }

    @Generated
    public Map<String, URI> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public Boolean getWarningOnStdErr() {
        return this.warningOnStdErr;
    }

    @Generated
    public static class ScriptOutputBuilder {
        @Generated
        private Map<String, Object> vars;
        @Generated
        private int stdOutLineCount;
        @Generated
        private int stdErrLineCount;
        @Generated
        private int exitCode;
        @Generated
        private Map<String, URI> files;
        @Generated
        private Map<String, URI> outputFiles;
        @Generated
        private Boolean warningOnStdErr;

        @Generated
        ScriptOutputBuilder() {
        }

        @Generated
        public ScriptOutputBuilder vars(Map<String, Object> vars) {
            this.vars = vars;
            return this;
        }

        @Generated
        public ScriptOutputBuilder stdOutLineCount(int stdOutLineCount) {
            this.stdOutLineCount = stdOutLineCount;
            return this;
        }

        @Generated
        public ScriptOutputBuilder stdErrLineCount(int stdErrLineCount) {
            this.stdErrLineCount = stdErrLineCount;
            return this;
        }

        @Generated
        public ScriptOutputBuilder exitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        @Deprecated
        @Generated
        public ScriptOutputBuilder files(Map<String, URI> files) {
            this.files = files;
            return this;
        }

        @Generated
        public ScriptOutputBuilder outputFiles(Map<String, URI> outputFiles) {
            this.outputFiles = outputFiles;
            return this;
        }

        @JsonIgnore
        @Generated
        public ScriptOutputBuilder warningOnStdErr(Boolean warningOnStdErr) {
            this.warningOnStdErr = warningOnStdErr;
            return this;
        }

        @Generated
        public ScriptOutput build() {
            return new ScriptOutput(this.vars, this.stdOutLineCount, this.stdErrLineCount, this.exitCode, this.files, this.outputFiles, this.warningOnStdErr);
        }

        @Generated
        public String toString() {
            return "ScriptOutput.ScriptOutputBuilder(vars=" + this.vars + ", stdOutLineCount=" + this.stdOutLineCount + ", stdErrLineCount=" + this.stdErrLineCount + ", exitCode=" + this.exitCode + ", files=" + this.files + ", outputFiles=" + this.outputFiles + ", warningOnStdErr=" + this.warningOnStdErr + ")";
        }
    }
}

