/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.scripts.runners;

import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.scripts.AbstractBash;
import io.kestra.core.tasks.scripts.AbstractLogThread;
import io.kestra.core.tasks.scripts.RunResult;
import io.kestra.core.tasks.scripts.runners.ScriptRunnerInterface;
import io.kestra.core.utils.Rethrow;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ProcessBuilderScriptRunner
implements ScriptRunnerInterface {
    @Override
    public RunResult run(AbstractBash abstractBash, RunContext runContext, Logger logger, Path workingDirectory, List<String> commandsWithInterpreter, Map<String, String> env, AbstractBash.LogSupplier logSupplier, Map<String, Object> additionalVars) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        if (env != null && env.size() > 0) {
            Map<String, String> environment = processBuilder.environment();
            environment.putAll(env.entrySet().stream().map(Rethrow.throwFunction(r -> new AbstractMap.SimpleEntry<String, String>(runContext.render((String)r.getKey(), additionalVars), runContext.render((String)r.getValue(), additionalVars)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory.toFile());
        }
        processBuilder.command(commandsWithInterpreter);
        Process process = processBuilder.start();
        long pid = process.pid();
        logger.debug("Starting command with pid {} [{}]", (Object)pid, (Object)String.join((CharSequence)" ", commandsWithInterpreter));
        try {
            AbstractLogThread stdOut = logSupplier.call(process.getInputStream(), false);
            AbstractLogThread stdErr = logSupplier.call(process.getErrorStream(), true);
            int exitCode = process.waitFor();
            stdOut.join();
            stdErr.join();
            if (exitCode != 0) {
                throw new AbstractBash.BashException(exitCode, stdOut.getLogsCount(), stdErr.getLogsCount());
            }
            logger.debug("Command succeed with code " + exitCode);
            return new RunResult(exitCode, stdOut, stdErr);
        }
        catch (InterruptedException e) {
            logger.warn("Killing process {} for InterruptedException", (Object)pid);
            this.killDescendantsOf(process.toHandle(), logger);
            process.destroy();
            throw e;
        }
    }

    private void killDescendantsOf(ProcessHandle process, Logger logger) {
        process.descendants().forEach(processHandle -> {
            if (!processHandle.destroy()) {
                logger.warn("Descendant process {} of {} couldn't be killed", (Object)processHandle.pid(), (Object)process.pid());
            }
        });
    }
}

