/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.states;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.core.tasks.states.AbstractState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

@Schema(title="Set a state in the state store.", description="Values will be merged: \n* If you provide a new key, the new key will be added\n* If you provide an existing key, the previous key will be overwrite\n\n::: warning\nThis method have no concurrency safe, if many executions for the same flow are concurrent, there is no guarantee on isolation on the value.\nThe value can be overwrite by others executions.\n:::\n")
@Plugin(examples={@Example(title="Set the default state for the current flow", code={"id: setState", "type: io.kestra.core.tasks.states.Set", "data:", "  '{{ inputs.store }}': '{{ outputs.download.md5 }}'"}, full=true), @Example(title="Set the `myState` state for the current flow", code={"id: setState", "type: io.kestra.core.tasks.states.Set", "name: myState", "data:", "  '{{ inputs.store }}': '{{ outputs.download.md5 }}'"}, full=true)})
public class Set
extends AbstractState
implements RunnableTask<Output> {
    @Schema(title="The data to save into the state")
    @PluginProperty(dynamic=true, additionalProperties=Object.class)
    private Map<String, Object> data;

    @Override
    public Output run(RunContext runContext) throws Exception {
        Pair<URI, Map<String, Object>> data = this.merge(runContext, runContext.render(this.data));
        return Output.builder().count(((Map)data.getRight()).size()).uri(((URI)data.getLeft()).toString()).build();
    }

    @Generated
    protected Set(SetBuilder<?, ?> b) {
        super((AbstractState.AbstractStateBuilder)b);
        this.data = b.data;
    }

    @Generated
    public static SetBuilder<?, ?> builder() {
        return new SetBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Set(super=" + super.toString() + ", data=" + this.getData() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set other = (Set)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$data = this.getData();
        Map<String, Object> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Set;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public Map<String, Object> getData() {
        return this.data;
    }

    @Generated
    public Set() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The count of properties found in the state")
        private final int count;
        @Schema(title="The uri of the current state")
        private final String uri;

        @ConstructorProperties(value={"count", "uri"})
        @Generated
        Output(int count, String uri) {
            this.count = count;
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public String getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private int count;
            @Generated
            private String uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder count(int count) {
                this.count = count;
                return this;
            }

            @Generated
            public OutputBuilder uri(String uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.count, this.uri);
            }

            @Generated
            public String toString() {
                return "Set.Output.OutputBuilder(count=" + this.count + ", uri=" + this.uri + ")";
            }
        }
    }

    @Generated
    public static abstract class SetBuilder<C extends Set, B extends SetBuilder<C, B>>
    extends AbstractState.AbstractStateBuilder<C, B> {
        @Generated
        private Map<String, Object> data;

        @Generated
        public B data(Map<String, Object> data) {
            this.data = data;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Set.SetBuilder(super=" + super.toString() + ", data=" + this.data + ")";
        }
    }

    @Generated
    private static final class SetBuilderImpl
    extends SetBuilder<Set, SetBuilderImpl> {
        @Generated
        private SetBuilderImpl() {
        }

        @Override
        @Generated
        protected SetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Set build() {
            return new Set(this);
        }
    }
}

