/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.tasks.storages;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.ExecutionService;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;

@Schema(title="Purge execution, logs or storage files.")
@Plugin(examples={@Example(code={"endDate: \"{{ now() | dateAdd(-1, 'MONTHS') }}\"", "states: ", " - KILLED", " - FAILED", " - WARNING", " - SUCCESS"})})
public class Purge
extends Task
implements RunnableTask<Output> {
    @Schema(title="Namespace to purge or namespace for a flow", description="If `flowId` isn't provide, this is a namespace prefix, else the namespace of flow")
    @PluginProperty(dynamic=true)
    private String namespace;
    @Schema(title="The flow id to purge", description="You need to provide the `namespace` properties if you want to purge a flow")
    @PluginProperty(dynamic=true)
    private String flowId;
    @Schema(title="The max date to purge", description="All date after this date will be purged.")
    @PluginProperty(dynamic=true)
    private String endDate;
    @Schema(title="The state of the execution that can be purged.")
    @PluginProperty
    private List<State.Type> states;
    @Schema(title="Purge execution from repository")
    @PluginProperty
    private boolean purgeExecution;
    @Schema(title="Purge log from repository")
    @PluginProperty
    private boolean purgeLog;
    @Schema(title="Purge metric from repository")
    @PluginProperty
    private boolean purgeMetric;
    @Schema(title="Purge file from internal storage")
    @PluginProperty
    private boolean purgeStorage;

    @Override
    public Output run(RunContext runContext) throws Exception {
        ExecutionService executionService = (ExecutionService)runContext.getApplicationContext().getBean(ExecutionService.class);
        ExecutionService.PurgeResult purgeResult = executionService.purge(this.purgeExecution, this.purgeLog, this.purgeMetric, this.purgeStorage, this.namespace, this.flowId, ZonedDateTime.parse(runContext.render(this.endDate)), this.states);
        return ((Output.OutputBuilder)((Output.OutputBuilder)((Output.OutputBuilder)Output.builder().executionsCount(purgeResult.getExecutionsCount())).logsCount(purgeResult.getLogsCount())).storagesCount(purgeResult.getStoragesCount())).build();
    }

    @Generated
    private static boolean $default$purgeExecution() {
        return true;
    }

    @Generated
    private static boolean $default$purgeLog() {
        return true;
    }

    @Generated
    private static boolean $default$purgeMetric() {
        return true;
    }

    @Generated
    private static boolean $default$purgeStorage() {
        return true;
    }

    @Generated
    protected Purge(PurgeBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.endDate = b.endDate;
        this.states = b.states;
        this.purgeExecution = b.purgeExecution$set ? b.purgeExecution$value : Purge.$default$purgeExecution();
        this.purgeLog = b.purgeLog$set ? b.purgeLog$value : Purge.$default$purgeLog();
        this.purgeMetric = b.purgeMetric$set ? b.purgeMetric$value : Purge.$default$purgeMetric();
        this.purgeStorage = b.purgeStorage$set ? b.purgeStorage$value : Purge.$default$purgeStorage();
    }

    @Generated
    public static PurgeBuilder<?, ?> builder() {
        return new PurgeBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Purge(super=" + super.toString() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", endDate=" + this.getEndDate() + ", states=" + this.getStates() + ", purgeExecution=" + this.isPurgeExecution() + ", purgeLog=" + this.isPurgeLog() + ", purgeMetric=" + this.isPurgeMetric() + ", purgeStorage=" + this.isPurgeStorage() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Purge)) {
            return false;
        }
        Purge other = (Purge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isPurgeExecution() != other.isPurgeExecution()) {
            return false;
        }
        if (this.isPurgeLog() != other.isPurgeLog()) {
            return false;
        }
        if (this.isPurgeMetric() != other.isPurgeMetric()) {
            return false;
        }
        if (this.isPurgeStorage() != other.isPurgeStorage()) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        List<State.Type> this$states = this.getStates();
        List<State.Type> other$states = other.getStates();
        return !(this$states == null ? other$states != null : !((Object)this$states).equals(other$states));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Purge;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPurgeExecution() ? 79 : 97);
        result = result * 59 + (this.isPurgeLog() ? 79 : 97);
        result = result * 59 + (this.isPurgeMetric() ? 79 : 97);
        result = result * 59 + (this.isPurgeStorage() ? 79 : 97);
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        List<State.Type> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        return result;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public String getEndDate() {
        return this.endDate;
    }

    @Generated
    public List<State.Type> getStates() {
        return this.states;
    }

    @Generated
    public boolean isPurgeExecution() {
        return this.purgeExecution;
    }

    @Generated
    public boolean isPurgeLog() {
        return this.purgeLog;
    }

    @Generated
    public boolean isPurgeMetric() {
        return this.purgeMetric;
    }

    @Generated
    public boolean isPurgeStorage() {
        return this.purgeStorage;
    }

    @Generated
    public Purge() {
        this.purgeExecution = Purge.$default$purgeExecution();
        this.purgeLog = Purge.$default$purgeLog();
        this.purgeMetric = Purge.$default$purgeMetric();
        this.purgeStorage = Purge.$default$purgeStorage();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The count of executions deleted")
        private int executionsCount;
        @Schema(title="The count of logs deleted")
        private int logsCount;
        @Schema(title="The count of storage deleted")
        private int storagesCount;

        @Generated
        protected Output(OutputBuilder<?, ?> b) {
            this.executionsCount = b.executionsCount;
            this.logsCount = b.logsCount;
            this.storagesCount = b.storagesCount;
        }

        @Generated
        public static OutputBuilder<?, ?> builder() {
            return new OutputBuilderImpl();
        }

        @Generated
        public OutputBuilder<?, ?> toBuilder() {
            return new OutputBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public int getExecutionsCount() {
            return this.executionsCount;
        }

        @Generated
        public int getLogsCount() {
            return this.logsCount;
        }

        @Generated
        public int getStoragesCount() {
            return this.storagesCount;
        }

        @Generated
        public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
            @Generated
            private int executionsCount;
            @Generated
            private int logsCount;
            @Generated
            private int storagesCount;

            @Generated
            protected B $fillValuesFrom(C instance) {
                OutputBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Output instance, OutputBuilder<?, ?> b) {
                b.executionsCount(instance.executionsCount);
                b.logsCount(instance.logsCount);
                b.storagesCount(instance.storagesCount);
            }

            @Generated
            public B executionsCount(int executionsCount) {
                this.executionsCount = executionsCount;
                return this.self();
            }

            @Generated
            public B logsCount(int logsCount) {
                this.logsCount = logsCount;
                return this.self();
            }

            @Generated
            public B storagesCount(int storagesCount) {
                this.storagesCount = storagesCount;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "Purge.Output.OutputBuilder(executionsCount=" + this.executionsCount + ", logsCount=" + this.logsCount + ", storagesCount=" + this.storagesCount + ")";
            }
        }

        @Generated
        private static final class OutputBuilderImpl
        extends OutputBuilder<Output, OutputBuilderImpl> {
            @Generated
            private OutputBuilderImpl() {
            }

            @Override
            @Generated
            protected OutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Output build() {
                return new Output(this);
            }
        }
    }

    @Generated
    public static abstract class PurgeBuilder<C extends Purge, B extends PurgeBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String endDate;
        @Generated
        private List<State.Type> states;
        @Generated
        private boolean purgeExecution$set;
        @Generated
        private boolean purgeExecution$value;
        @Generated
        private boolean purgeLog$set;
        @Generated
        private boolean purgeLog$value;
        @Generated
        private boolean purgeMetric$set;
        @Generated
        private boolean purgeMetric$value;
        @Generated
        private boolean purgeStorage$set;
        @Generated
        private boolean purgeStorage$value;

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B endDate(String endDate) {
            this.endDate = endDate;
            return (B)this.self();
        }

        @Generated
        public B states(List<State.Type> states) {
            this.states = states;
            return (B)this.self();
        }

        @Generated
        public B purgeExecution(boolean purgeExecution) {
            this.purgeExecution$value = purgeExecution;
            this.purgeExecution$set = true;
            return (B)this.self();
        }

        @Generated
        public B purgeLog(boolean purgeLog) {
            this.purgeLog$value = purgeLog;
            this.purgeLog$set = true;
            return (B)this.self();
        }

        @Generated
        public B purgeMetric(boolean purgeMetric) {
            this.purgeMetric$value = purgeMetric;
            this.purgeMetric$set = true;
            return (B)this.self();
        }

        @Generated
        public B purgeStorage(boolean purgeStorage) {
            this.purgeStorage$value = purgeStorage;
            this.purgeStorage$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Purge.PurgeBuilder(super=" + super.toString() + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", endDate=" + this.endDate + ", states=" + this.states + ", purgeExecution$value=" + this.purgeExecution$value + ", purgeLog$value=" + this.purgeLog$value + ", purgeMetric$value=" + this.purgeMetric$value + ", purgeStorage$value=" + this.purgeStorage$value + ")";
        }
    }

    @Generated
    private static final class PurgeBuilderImpl
    extends PurgeBuilder<Purge, PurgeBuilderImpl> {
        @Generated
        private PurgeBuilderImpl() {
        }

        @Override
        @Generated
        protected PurgeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Purge build() {
            return new Purge(this);
        }
    }
}

