/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Rethrow {
    public static <T, E extends Exception> Consumer<T> throwConsumer(ConsumerChecked<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                Rethrow.throwException(exception);
            }
        };
    }

    public static <K, V, E extends Exception> BiConsumer<K, V> throwBiConsumer(BiConsumerChecked<K, V, E> consumer) throws E {
        return (k, v) -> {
            try {
                consumer.accept(k, v);
            }
            catch (Exception exception) {
                Rethrow.throwException(exception);
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> throwSupplier(SupplierChecked<T, E> supplier) throws E {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                return Rethrow.throwException(exception);
            }
        };
    }

    public static <T, E extends Exception> Predicate<T> throwPredicate(PredicateChecked<T, E> consumer) throws E {
        return t -> {
            try {
                return consumer.test(t);
            }
            catch (Exception exception) {
                return (Boolean)Rethrow.throwException(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> throwFunction(FunctionChecked<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                return Rethrow.throwException(exception);
            }
        };
    }

    public static <A, B, R, E extends Exception> BiFunction<A, B, R> throwBiFunction(BiFunctionChecked<A, B, R, E> function) throws E {
        return (a, b) -> {
            try {
                return function.apply(a, b);
            }
            catch (Exception exception) {
                return Rethrow.throwException(exception);
            }
        };
    }

    public static <E extends Exception> Runnable throwRunnable(RunnableChecked<E> runnable) throws E {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                Rethrow.throwException(exception);
            }
        };
    }

    public static <R, E extends Exception> Callable<R> throwCallable(CallableChecked<R, E> runnable) throws E {
        return () -> {
            try {
                return runnable.call();
            }
            catch (Exception exception) {
                return Rethrow.throwException(exception);
            }
        };
    }

    private static <E extends Exception, R> R throwException(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface ConsumerChecked<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface BiConsumerChecked<K, V, E extends Exception> {
        public void accept(K var1, V var2) throws E;
    }

    @FunctionalInterface
    public static interface SupplierChecked<T, E extends Exception> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface PredicateChecked<T, E extends Exception> {
        public boolean test(T var1) throws E;
    }

    @FunctionalInterface
    public static interface FunctionChecked<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface BiFunctionChecked<A, B, R, E extends Exception> {
        public R apply(A var1, B var2) throws E;
    }

    @FunctionalInterface
    public static interface RunnableChecked<E extends Exception> {
        public void run() throws E;
    }

    @FunctionalInterface
    public static interface CallableChecked<R, E extends Exception> {
        public R call() throws E;
    }
}

