/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.tasks.retrys.Exponential;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeException;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Fallback;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RetryUtils {
    public <T, E extends Throwable> Instance<T, E> of() {
        return Instance.builder().build();
    }

    public <T, E extends Throwable> Instance<T, E> of(AbstractRetry policy) {
        return Instance.builder().policy(policy).build();
    }

    public <T, E extends Throwable> Instance<T, E> of(AbstractRetry policy, Function<RetryFailed, E> failureFunction) {
        return Instance.builder().policy(policy).failureFunction(failureFunction).build();
    }

    public <T, E extends Throwable> Instance<T, E> of(AbstractRetry policy, Logger logger) {
        return Instance.builder().policy(policy).logger(logger).build();
    }

    public static class Instance<T, E extends Throwable> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Instance.class);
        private final AbstractRetry policy;
        private final Logger logger;
        private final Function<RetryFailed, E> failureFunction;

        public T run(Class<E> exception, CheckedSupplier<T> run) throws E {
            return Instance.wrap(Failsafe.with((Policy)((Policy)this.exceptionFallback(this.failureFunction).handle(exception)), (Policy[])new Policy[]{(Policy)this.toPolicy(this.policy).handle(exception)}), run);
        }

        public T run(List<Class<? extends Throwable>> list, CheckedSupplier<T> run) throws Throwable {
            return Instance.wrap(Failsafe.with((Policy)((Policy)this.exceptionFallback(this.failureFunction).handleIf((t, throwable) -> list.stream().anyMatch(cls -> cls.isInstance(throwable)))), (Policy[])new Policy[]{(Policy)this.toPolicy(this.policy).handleIf((t, throwable) -> list.stream().anyMatch(cls -> cls.isInstance(throwable)))}), run);
        }

        public T runRetryIf(Predicate<? extends E> predicate, CheckedSupplier<T> run) {
            return Instance.wrap(Failsafe.with((Policy)((Policy)this.exceptionFallback(this.failureFunction).handleIf(predicate)), (Policy[])new Policy[]{(Policy)this.toPolicy(this.policy).handleIf(predicate)}), run);
        }

        public T run(BiPredicate<T, Throwable> predicate, CheckedSupplier<T> run) throws E {
            return Instance.wrap(Failsafe.with((Policy)((Policy)this.exceptionFallback(this.failureFunction).handleIf(predicate)), (Policy[])new Policy[]{(Policy)this.toPolicy(this.policy).handleIf(predicate)}), run);
        }

        public T run(Predicate<T> predicate, CheckedSupplier<T> run) throws E {
            return Instance.wrap(Failsafe.with((Policy)((Policy)this.exceptionFallback(this.failureFunction).handleResultIf(predicate)), (Policy[])new Policy[]{(Policy)this.toPolicy(this.policy).handleResultIf(predicate)}), run);
        }

        private static <T, E extends Throwable> T wrap(FailsafeExecutor<T> failsafeExecutor, CheckedSupplier<T> run) throws E {
            try {
                return (T)failsafeExecutor.get(run::get);
            }
            catch (FailsafeException e) {
                throw e.getCause();
            }
        }

        private Fallback<T> exceptionFallback(Function<RetryFailed, E> failureFunction) {
            return Fallback.ofException(executionAttemptedEvent -> {
                RetryFailed retryFailed = new RetryFailed(executionAttemptedEvent);
                throw failureFunction != null ? (Throwable)failureFunction.apply(retryFailed) : retryFailed;
            });
        }

        private RetryPolicy<T> toPolicy(AbstractRetry abstractRetry) {
            RetryPolicy retryPolicy = abstractRetry.toPolicy();
            Logger currentLogger = this.logger != null ? this.logger : log;
            Object method = "";
            if (Thread.currentThread().getStackTrace().length > 4) {
                method = " [class '" + Thread.currentThread().getStackTrace()[3].getClassName() + "', method '" + Thread.currentThread().getStackTrace()[3].getMethodName() + "' on line '" + Thread.currentThread().getStackTrace()[3].getLineNumber() + "']";
            }
            String finalMethod = method;
            ((RetryPolicy)retryPolicy.onFailure(event -> currentLogger.warn("Stop retry{}, elapsed {} and {} attempts", new Object[]{finalMethod, event.getElapsedTime().truncatedTo(ChronoUnit.SECONDS), event.getAttemptCount(), event.getFailure()}))).onRetry(event -> currentLogger.info("Retrying{}, elapsed {} and {} attempts", new Object[]{finalMethod, event.getElapsedTime().truncatedTo(ChronoUnit.SECONDS), event.getAttemptCount()}));
            return retryPolicy;
        }

        @Generated
        private static <T, E extends Throwable> AbstractRetry $default$policy() {
            return ((Exponential.ExponentialBuilder)((AbstractRetry.AbstractRetryBuilder)((Exponential.ExponentialBuilder)((Exponential.ExponentialBuilder)Exponential.builder().delayFactor(2.0)).interval(Duration.ofSeconds(1L))).maxInterval(Duration.ofSeconds(10L))).maxAttempt(3)).build();
        }

        @Generated
        private static <T, E extends Throwable> Logger $default$logger() {
            return log;
        }

        @Generated
        public static <T, E extends Throwable> InstanceBuilder<T, E> builder() {
            return new InstanceBuilder();
        }

        @ConstructorProperties(value={"policy", "logger", "failureFunction"})
        @Generated
        public Instance(AbstractRetry policy, Logger logger, Function<RetryFailed, E> failureFunction) {
            this.policy = policy;
            this.logger = logger;
            this.failureFunction = failureFunction;
        }

        @Generated
        public static class InstanceBuilder<T, E extends Throwable> {
            @Generated
            private boolean policy$set;
            @Generated
            private AbstractRetry policy$value;
            @Generated
            private boolean logger$set;
            @Generated
            private Logger logger$value;
            @Generated
            private Function<RetryFailed, E> failureFunction;

            @Generated
            InstanceBuilder() {
            }

            @Generated
            public InstanceBuilder<T, E> policy(AbstractRetry policy) {
                this.policy$value = policy;
                this.policy$set = true;
                return this;
            }

            @Generated
            public InstanceBuilder<T, E> logger(Logger logger) {
                this.logger$value = logger;
                this.logger$set = true;
                return this;
            }

            @Generated
            public InstanceBuilder<T, E> failureFunction(Function<RetryFailed, E> failureFunction) {
                this.failureFunction = failureFunction;
                return this;
            }

            @Generated
            public Instance<T, E> build() {
                AbstractRetry policy$value = this.policy$value;
                if (!this.policy$set) {
                    policy$value = Instance.$default$policy();
                }
                Logger logger$value = this.logger$value;
                if (!this.logger$set) {
                    logger$value = Instance.$default$logger();
                }
                return new Instance(policy$value, logger$value, this.failureFunction);
            }

            @Generated
            public String toString() {
                return "RetryUtils.Instance.InstanceBuilder(policy$value=" + this.policy$value + ", logger$value=" + this.logger$value + ", failureFunction=" + this.failureFunction + ")";
            }
        }
    }

    public static class RetryFailed
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final int attemptCount;
        private final Duration elapsedTime;
        private final Duration startTime;

        public <T> RetryFailed(ExecutionAttemptedEvent<? extends T> event) {
            super("Stop retry, attempts " + event.getAttemptCount() + " elapsed after " + event.getElapsedTime().getSeconds() + " seconds", event.getLastFailure());
            this.attemptCount = event.getAttemptCount();
            this.elapsedTime = event.getElapsedTime();
            this.startTime = event.getStartTime();
        }

        @Generated
        public int getAttemptCount() {
            return this.attemptCount;
        }

        @Generated
        public Duration getElapsedTime() {
            return this.elapsedTime;
        }

        @Generated
        public Duration getStartTime() {
            return this.startTime;
        }
    }

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T get() throws Throwable;
    }
}

