/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import io.micronaut.context.ApplicationContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class ThreadUncaughtExceptionHandlers
implements Thread.UncaughtExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadUncaughtExceptionHandlers.class);
    @Inject
    private ApplicationContext applicationContext;
    private final Runtime runtime = Runtime.getRuntime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        boolean isTest = this.applicationContext.getEnvironment().getActiveNames().contains("test");
        try {
            log.error("Caught an exception in {}. " + (isTest ? "Keeping it running for test." : "Shutting down."), (Object)t, (Object)e);
        }
        catch (Throwable errorInLogging) {
            System.err.println(e.getMessage());
            System.err.println(errorInLogging.getMessage());
        }
        finally {
            if (!isTest) {
                this.applicationContext.close();
                this.runtime.exit(1);
            }
        }
    }
}

