/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations;

import com.cronutils.model.Cron;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.tasks.flows.Switch;
import io.kestra.core.validations.CronExpression;
import io.kestra.core.validations.DateFormat;
import io.kestra.core.validations.FlowValidation;
import io.kestra.core.validations.JsonString;
import io.kestra.core.validations.Schedule;
import io.kestra.core.validations.SwitchTaskValidation;
import io.micronaut.context.annotation.Factory;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

@Factory
public class ValidationFactory {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Singleton
    ConstraintValidator<DateFormat, String> dateTimeValidator() {
        return (value, annotationMetadata, context) -> {
            if (value == null) {
                return true;
            }
            try {
                Date now = new Date();
                SimpleDateFormat dateFormat = new SimpleDateFormat((String)value);
                dateFormat.format(now);
            }
            catch (Exception e) {
                context.messageTemplate("invalid date format value '({validatedValue})': " + e.getMessage());
                return false;
            }
            return true;
        };
    }

    @Singleton
    ConstraintValidator<CronExpression, CharSequence> cronExpressionValidator() {
        return (value, annotationMetadata, context) -> {
            if (value == null) {
                return true;
            }
            try {
                Cron parse = io.kestra.core.models.triggers.types.Schedule.CRON_PARSER.parse(value.toString());
                parse.validate();
            }
            catch (IllegalArgumentException e) {
                context.messageTemplate("invalid cron expression '({validatedValue})': " + e.getMessage());
                return false;
            }
            return true;
        };
    }

    @Singleton
    ConstraintValidator<Schedule, io.kestra.core.models.triggers.types.Schedule> scheduleValidator() {
        return (value, annotationMetadata, context) -> {
            if (value == null) {
                return true;
            }
            if (value.getBackfill() != null && value.getBackfill().getStart() != null && value.getLateMaximumDelay() != null) {
                context.messageTemplate("invalid schedule: backfill and lateMaximumDelay are incompatible options");
                return false;
            }
            return true;
        };
    }

    @Singleton
    ConstraintValidator<JsonString, String> jsonStringValidator() {
        return (value, annotationMetadata, context) -> {
            if (value == null) {
                return true;
            }
            try {
                OBJECT_MAPPER.readTree(value);
            }
            catch (IOException e) {
                context.messageTemplate("invalid json '({validatedValue})': " + e.getMessage());
                return false;
            }
            return true;
        };
    }

    @Singleton
    ConstraintValidator<SwitchTaskValidation, Switch> switchTaskValidation() {
        return (value, annotationMetadata, context) -> {
            HashSet violations = new HashSet();
            if (value == null) {
                return true;
            }
            if (!(value.getCases() != null && value.getCases().size() != 0 || value.getDefaults() != null && value.getDefaults().size() != 0)) {
                context.messageTemplate("No task defined, neither cases or default have any tasks");
                return false;
            }
            return true;
        };
    }

    @Singleton
    ConstraintValidator<FlowValidation, Flow> flowValidation() {
        return (value, annotationMetadata, context) -> {
            if (value == null) {
                return true;
            }
            ArrayList<CallSite> violations = new ArrayList<CallSite>();
            List<Task> allTasks = value.allTasksWithChilds();
            List ids = allTasks.stream().map(Task::getId).collect(Collectors.toList());
            List duplicates = ids.stream().distinct().filter(entry -> Collections.frequency(ids, entry) > 1).collect(Collectors.toList());
            if (duplicates.size() > 0) {
                violations.add((CallSite)((Object)("Duplicate task id with name [" + String.join((CharSequence)", ", duplicates) + "]")));
            }
            if (violations.size() > 0) {
                context.messageTemplate("Invalid Flow: " + String.join((CharSequence)", ", violations));
                return false;
            }
            return true;
        };
    }
}

