/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import io.kestra.core.models.annotations.PluginSubGroup;
import io.kestra.core.plugins.RegisteredPlugin;
import io.micronaut.core.annotation.Nullable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;

public class Plugin {
    private String name;
    private String title;
    private String description;
    private String license;
    private String longDescription;
    private String group;
    private String version;
    private Map<String, String> manifest;
    private List<String> guides;
    private List<String> aliases;
    private List<PluginElementMetadata> tasks;
    private List<PluginElementMetadata> triggers;
    private List<PluginElementMetadata> conditions;
    private List<PluginElementMetadata> controllers;
    private List<PluginElementMetadata> storages;
    private List<PluginElementMetadata> secrets;
    private List<PluginElementMetadata> taskRunners;
    private List<PluginElementMetadata> apps;
    private List<PluginElementMetadata> appBlocks;
    private List<PluginElementMetadata> charts;
    private List<PluginElementMetadata> dataFilters;
    private List<PluginElementMetadata> dataFiltersKPI;
    private List<PluginElementMetadata> logExporters;
    private List<PluginElementMetadata> additionalPlugins;
    private List<PluginSubGroup.PluginCategory> categories;
    private String subGroup;

    public static Plugin of(RegisteredPlugin registeredPlugin, @Nullable String subgroup) {
        Plugin plugin = new Plugin();
        plugin.name = registeredPlugin.name();
        PluginSubGroup subGroupInfos = null;
        plugin.title = subgroup == null ? registeredPlugin.title() : (!(subGroupInfos = registeredPlugin.allClass().stream().filter(c -> c.getPackageName().contains(subgroup)).min(Comparator.comparingInt(a -> a.getPackageName().length())).map(clazz -> clazz.getPackage().getDeclaredAnnotation(PluginSubGroup.class)).orElseThrow()).title().isEmpty() ? subGroupInfos.title() : subgroup.substring(subgroup.lastIndexOf(46) + 1));
        plugin.group = registeredPlugin.group();
        plugin.description = subGroupInfos != null && !subGroupInfos.description().isEmpty() ? subGroupInfos.description() : registeredPlugin.description();
        plugin.license = registeredPlugin.license();
        plugin.longDescription = registeredPlugin.longDescription();
        plugin.version = registeredPlugin.version();
        plugin.guides = registeredPlugin.getGuides();
        plugin.aliases = registeredPlugin.getAliases().values().stream().map(Map.Entry::getKey).toList();
        plugin.manifest = registeredPlugin.getManifest().getMainAttributes().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>(e.getKey().toString(), e.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        plugin.categories = subGroupInfos != null ? Arrays.stream(subGroupInfos.categories()).toList() : registeredPlugin.allClass().stream().map(clazz -> clazz.getPackage().getDeclaredAnnotation(PluginSubGroup.class)).filter(Objects::nonNull).flatMap(r -> Arrays.stream(r.categories())).distinct().toList();
        plugin.subGroup = subgroup;
        Predicate<Class<?>> packagePredicate = c -> subgroup == null || c.getPackageName().equals(subgroup);
        plugin.tasks = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getTasks(), packagePredicate);
        plugin.triggers = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getTriggers(), packagePredicate);
        plugin.conditions = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getConditions(), packagePredicate);
        plugin.storages = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getStorages(), packagePredicate);
        plugin.secrets = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getSecrets(), packagePredicate);
        plugin.taskRunners = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getTaskRunners(), packagePredicate);
        plugin.apps = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getApps(), packagePredicate);
        plugin.appBlocks = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getAppBlocks(), packagePredicate);
        plugin.charts = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getCharts(), packagePredicate);
        plugin.dataFilters = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getDataFilters(), packagePredicate);
        plugin.dataFiltersKPI = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getDataFiltersKPI(), packagePredicate);
        plugin.logExporters = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getLogExporters(), packagePredicate);
        plugin.additionalPlugins = Plugin.filterAndGetTypeWithMetadata(registeredPlugin.getAdditionalPlugins(), packagePredicate);
        return plugin;
    }

    private static List<PluginElementMetadata> filterAndGetTypeWithMetadata(List<? extends Class<?>> list, Predicate<Class<?>> clazzFilter) {
        return list.stream().filter(Predicate.not(io.kestra.core.models.Plugin::isInternal)).filter(clazzFilter).filter(c -> !c.getName().startsWith("org.kestra.")).map(c -> new PluginElementMetadata(c.getName(), io.kestra.core.models.Plugin.isDeprecated((Class)c) ? Boolean.valueOf(true) : null)).toList();
    }

    @Generated
    public Plugin() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getLicense() {
        return this.license;
    }

    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Map<String, String> getManifest() {
        return this.manifest;
    }

    @Generated
    public List<String> getGuides() {
        return this.guides;
    }

    @Generated
    public List<String> getAliases() {
        return this.aliases;
    }

    @Generated
    public List<PluginElementMetadata> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<PluginElementMetadata> getTriggers() {
        return this.triggers;
    }

    @Generated
    public List<PluginElementMetadata> getConditions() {
        return this.conditions;
    }

    @Generated
    public List<PluginElementMetadata> getControllers() {
        return this.controllers;
    }

    @Generated
    public List<PluginElementMetadata> getStorages() {
        return this.storages;
    }

    @Generated
    public List<PluginElementMetadata> getSecrets() {
        return this.secrets;
    }

    @Generated
    public List<PluginElementMetadata> getTaskRunners() {
        return this.taskRunners;
    }

    @Generated
    public List<PluginElementMetadata> getApps() {
        return this.apps;
    }

    @Generated
    public List<PluginElementMetadata> getAppBlocks() {
        return this.appBlocks;
    }

    @Generated
    public List<PluginElementMetadata> getCharts() {
        return this.charts;
    }

    @Generated
    public List<PluginElementMetadata> getDataFilters() {
        return this.dataFilters;
    }

    @Generated
    public List<PluginElementMetadata> getDataFiltersKPI() {
        return this.dataFiltersKPI;
    }

    @Generated
    public List<PluginElementMetadata> getLogExporters() {
        return this.logExporters;
    }

    @Generated
    public List<PluginElementMetadata> getAdditionalPlugins() {
        return this.additionalPlugins;
    }

    @Generated
    public List<PluginSubGroup.PluginCategory> getCategories() {
        return this.categories;
    }

    @Generated
    public String getSubGroup() {
        return this.subGroup;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setLicense(String license) {
        this.license = license;
    }

    @Generated
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Generated
    public void setGroup(String group) {
        this.group = group;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setManifest(Map<String, String> manifest) {
        this.manifest = manifest;
    }

    @Generated
    public void setGuides(List<String> guides) {
        this.guides = guides;
    }

    @Generated
    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    @Generated
    public void setTasks(List<PluginElementMetadata> tasks) {
        this.tasks = tasks;
    }

    @Generated
    public void setTriggers(List<PluginElementMetadata> triggers) {
        this.triggers = triggers;
    }

    @Generated
    public void setConditions(List<PluginElementMetadata> conditions) {
        this.conditions = conditions;
    }

    @Generated
    public void setControllers(List<PluginElementMetadata> controllers) {
        this.controllers = controllers;
    }

    @Generated
    public void setStorages(List<PluginElementMetadata> storages) {
        this.storages = storages;
    }

    @Generated
    public void setSecrets(List<PluginElementMetadata> secrets) {
        this.secrets = secrets;
    }

    @Generated
    public void setTaskRunners(List<PluginElementMetadata> taskRunners) {
        this.taskRunners = taskRunners;
    }

    @Generated
    public void setApps(List<PluginElementMetadata> apps) {
        this.apps = apps;
    }

    @Generated
    public void setAppBlocks(List<PluginElementMetadata> appBlocks) {
        this.appBlocks = appBlocks;
    }

    @Generated
    public void setCharts(List<PluginElementMetadata> charts) {
        this.charts = charts;
    }

    @Generated
    public void setDataFilters(List<PluginElementMetadata> dataFilters) {
        this.dataFilters = dataFilters;
    }

    @Generated
    public void setDataFiltersKPI(List<PluginElementMetadata> dataFiltersKPI) {
        this.dataFiltersKPI = dataFiltersKPI;
    }

    @Generated
    public void setLogExporters(List<PluginElementMetadata> logExporters) {
        this.logExporters = logExporters;
    }

    @Generated
    public void setAdditionalPlugins(List<PluginElementMetadata> additionalPlugins) {
        this.additionalPlugins = additionalPlugins;
    }

    @Generated
    public void setCategories(List<PluginSubGroup.PluginCategory> categories) {
        this.categories = categories;
    }

    @Generated
    public void setSubGroup(String subGroup) {
        this.subGroup = subGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plugin)) {
            return false;
        }
        Plugin other = (Plugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$license = this.getLicense();
        String other$license = other.getLicense();
        if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Map<String, String> this$manifest = this.getManifest();
        Map<String, String> other$manifest = other.getManifest();
        if (this$manifest == null ? other$manifest != null : !((Object)this$manifest).equals(other$manifest)) {
            return false;
        }
        List<String> this$guides = this.getGuides();
        List<String> other$guides = other.getGuides();
        if (this$guides == null ? other$guides != null : !((Object)this$guides).equals(other$guides)) {
            return false;
        }
        List<String> this$aliases = this.getAliases();
        List<String> other$aliases = other.getAliases();
        if (this$aliases == null ? other$aliases != null : !((Object)this$aliases).equals(other$aliases)) {
            return false;
        }
        List<PluginElementMetadata> this$tasks = this.getTasks();
        List<PluginElementMetadata> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<PluginElementMetadata> this$triggers = this.getTriggers();
        List<PluginElementMetadata> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        List<PluginElementMetadata> this$conditions = this.getConditions();
        List<PluginElementMetadata> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<PluginElementMetadata> this$controllers = this.getControllers();
        List<PluginElementMetadata> other$controllers = other.getControllers();
        if (this$controllers == null ? other$controllers != null : !((Object)this$controllers).equals(other$controllers)) {
            return false;
        }
        List<PluginElementMetadata> this$storages = this.getStorages();
        List<PluginElementMetadata> other$storages = other.getStorages();
        if (this$storages == null ? other$storages != null : !((Object)this$storages).equals(other$storages)) {
            return false;
        }
        List<PluginElementMetadata> this$secrets = this.getSecrets();
        List<PluginElementMetadata> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        List<PluginElementMetadata> this$taskRunners = this.getTaskRunners();
        List<PluginElementMetadata> other$taskRunners = other.getTaskRunners();
        if (this$taskRunners == null ? other$taskRunners != null : !((Object)this$taskRunners).equals(other$taskRunners)) {
            return false;
        }
        List<PluginElementMetadata> this$apps = this.getApps();
        List<PluginElementMetadata> other$apps = other.getApps();
        if (this$apps == null ? other$apps != null : !((Object)this$apps).equals(other$apps)) {
            return false;
        }
        List<PluginElementMetadata> this$appBlocks = this.getAppBlocks();
        List<PluginElementMetadata> other$appBlocks = other.getAppBlocks();
        if (this$appBlocks == null ? other$appBlocks != null : !((Object)this$appBlocks).equals(other$appBlocks)) {
            return false;
        }
        List<PluginElementMetadata> this$charts = this.getCharts();
        List<PluginElementMetadata> other$charts = other.getCharts();
        if (this$charts == null ? other$charts != null : !((Object)this$charts).equals(other$charts)) {
            return false;
        }
        List<PluginElementMetadata> this$dataFilters = this.getDataFilters();
        List<PluginElementMetadata> other$dataFilters = other.getDataFilters();
        if (this$dataFilters == null ? other$dataFilters != null : !((Object)this$dataFilters).equals(other$dataFilters)) {
            return false;
        }
        List<PluginElementMetadata> this$dataFiltersKPI = this.getDataFiltersKPI();
        List<PluginElementMetadata> other$dataFiltersKPI = other.getDataFiltersKPI();
        if (this$dataFiltersKPI == null ? other$dataFiltersKPI != null : !((Object)this$dataFiltersKPI).equals(other$dataFiltersKPI)) {
            return false;
        }
        List<PluginElementMetadata> this$logExporters = this.getLogExporters();
        List<PluginElementMetadata> other$logExporters = other.getLogExporters();
        if (this$logExporters == null ? other$logExporters != null : !((Object)this$logExporters).equals(other$logExporters)) {
            return false;
        }
        List<PluginElementMetadata> this$additionalPlugins = this.getAdditionalPlugins();
        List<PluginElementMetadata> other$additionalPlugins = other.getAdditionalPlugins();
        if (this$additionalPlugins == null ? other$additionalPlugins != null : !((Object)this$additionalPlugins).equals(other$additionalPlugins)) {
            return false;
        }
        List<PluginSubGroup.PluginCategory> this$categories = this.getCategories();
        List<PluginSubGroup.PluginCategory> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        String this$subGroup = this.getSubGroup();
        String other$subGroup = other.getSubGroup();
        return !(this$subGroup == null ? other$subGroup != null : !this$subGroup.equals(other$subGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Plugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $license = this.getLicense();
        result = result * 59 + ($license == null ? 43 : $license.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Map<String, String> $manifest = this.getManifest();
        result = result * 59 + ($manifest == null ? 43 : ((Object)$manifest).hashCode());
        List<String> $guides = this.getGuides();
        result = result * 59 + ($guides == null ? 43 : ((Object)$guides).hashCode());
        List<String> $aliases = this.getAliases();
        result = result * 59 + ($aliases == null ? 43 : ((Object)$aliases).hashCode());
        List<PluginElementMetadata> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<PluginElementMetadata> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        List<PluginElementMetadata> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<PluginElementMetadata> $controllers = this.getControllers();
        result = result * 59 + ($controllers == null ? 43 : ((Object)$controllers).hashCode());
        List<PluginElementMetadata> $storages = this.getStorages();
        result = result * 59 + ($storages == null ? 43 : ((Object)$storages).hashCode());
        List<PluginElementMetadata> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        List<PluginElementMetadata> $taskRunners = this.getTaskRunners();
        result = result * 59 + ($taskRunners == null ? 43 : ((Object)$taskRunners).hashCode());
        List<PluginElementMetadata> $apps = this.getApps();
        result = result * 59 + ($apps == null ? 43 : ((Object)$apps).hashCode());
        List<PluginElementMetadata> $appBlocks = this.getAppBlocks();
        result = result * 59 + ($appBlocks == null ? 43 : ((Object)$appBlocks).hashCode());
        List<PluginElementMetadata> $charts = this.getCharts();
        result = result * 59 + ($charts == null ? 43 : ((Object)$charts).hashCode());
        List<PluginElementMetadata> $dataFilters = this.getDataFilters();
        result = result * 59 + ($dataFilters == null ? 43 : ((Object)$dataFilters).hashCode());
        List<PluginElementMetadata> $dataFiltersKPI = this.getDataFiltersKPI();
        result = result * 59 + ($dataFiltersKPI == null ? 43 : ((Object)$dataFiltersKPI).hashCode());
        List<PluginElementMetadata> $logExporters = this.getLogExporters();
        result = result * 59 + ($logExporters == null ? 43 : ((Object)$logExporters).hashCode());
        List<PluginElementMetadata> $additionalPlugins = this.getAdditionalPlugins();
        result = result * 59 + ($additionalPlugins == null ? 43 : ((Object)$additionalPlugins).hashCode());
        List<PluginSubGroup.PluginCategory> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        String $subGroup = this.getSubGroup();
        result = result * 59 + ($subGroup == null ? 43 : $subGroup.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Plugin(name=" + this.getName() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", license=" + this.getLicense() + ", longDescription=" + this.getLongDescription() + ", group=" + this.getGroup() + ", version=" + this.getVersion() + ", manifest=" + String.valueOf(this.getManifest()) + ", guides=" + String.valueOf(this.getGuides()) + ", aliases=" + String.valueOf(this.getAliases()) + ", tasks=" + String.valueOf(this.getTasks()) + ", triggers=" + String.valueOf(this.getTriggers()) + ", conditions=" + String.valueOf(this.getConditions()) + ", controllers=" + String.valueOf(this.getControllers()) + ", storages=" + String.valueOf(this.getStorages()) + ", secrets=" + String.valueOf(this.getSecrets()) + ", taskRunners=" + String.valueOf(this.getTaskRunners()) + ", apps=" + String.valueOf(this.getApps()) + ", appBlocks=" + String.valueOf(this.getAppBlocks()) + ", charts=" + String.valueOf(this.getCharts()) + ", dataFilters=" + String.valueOf(this.getDataFilters()) + ", dataFiltersKPI=" + String.valueOf(this.getDataFiltersKPI()) + ", logExporters=" + String.valueOf(this.getLogExporters()) + ", additionalPlugins=" + String.valueOf(this.getAdditionalPlugins()) + ", categories=" + String.valueOf(this.getCategories()) + ", subGroup=" + this.getSubGroup() + ")";
    }

    public record PluginElementMetadata(String cls, Boolean deprecated) {
    }
}

